'\"
'\" Copyright (c) 1996, Expert Interface Technologies
'\"
'\" See the file "license.terms" for information on usage and
'\" redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" The definitions below are for supplemental macros used in Tix
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
.\"
'\"	# Heading for Tix man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tcl    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'tix'        .TH "\\$1" n "\\*(^3"  Tix    "Tix Commands"
.if '\\$2'tixcmds'    .TH "\\$1" 1 "\\*(^3"  Tix    "Tix Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
'\" The definitions below are for supplemental macros used in Tix
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
.\"
'\"	# Heading for Tix man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tcl    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'tix'        .TH "\\$1" n "\\*(^3"  Tix    "Tix Commands"
.if '\\$2'tixcmds'    .TH "\\$1" 1 "\\*(^3"  Tix    "Tix Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..


.HS tixGrid tix 4.1
.BS
.SH NAME
tixGrid \- Create and manipulate Tix Grid widgets
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5c 11c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR
\fBfont\fR	\fBforeground\fR	\fBheight\fR
\fBhighlightColor\fR	\fBhighlightThickness\fR	\fBrelief\fR
\fBselectBackground\fR	\fBselectForeground\fR	\fBwidth\fR
\fBxScrollCommand\fR	\fByScrollCommand\fR	\fB\fR
.fi
.LP
See the \fBoptions(n)\fR manual entry for details on the standard options.
.SH "STANDARD OPTIONS"
.ta 5c
.LP
.nf
Name:	\fBeditDoneCmd\fR
Class:	\fBEditDoneCmd\fR
Command-line switch:	\fB\-editdonecmd\fR
.fi
.IP
If non-empty, gives a Tcl command to be executed when the user has edited grid cell. When this command is called, it is passed with two additional parameters: \fIx\fR \fIy\fR, where (\fIx\fR,\fIy\fR) is the location of the cell that has just been edited.
.LP
.nf
Name:	\fBeditNotifyCmd\fR
Class:	\fBEditNotifyCmd\fR
Command-line switch:	\fB\-editnotifycmd\fR
.fi
.IP
If non-empty, gives a Tcl command to be executed when the user tries to edit a grid cell. When this command is called, it is passed with two additional parameters: \fIx\fR \fIy\fR, where (\fIx\fR,\fIy\fR,) is the location of the cell. This command should return a boolean value: \fBtrue\fR indicates that the cells is editable and \fBfalse\fR otherwise.
.LP
.nf
Name:	\fBformatCmd\fR
Class:	\fBFormatCmd\fR
Command-line switch:	\fB\-formatcmd\fR
.fi
.IP
If non-empty, gives a Tcl command to be executed when the grid cells need to be formatted on the screen. Normally, this command calls the \fBformat\fR widget command (see below). When this command is called, it is passed with five additional parameters: \fItype\fR \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR. \fItype\fR gives the logical type of the region in the grid. It may be one of the following. \fBx-region\fR: the horizontal margin; \fBy-region\fR: the vertical margin; \fBs-region\fR, the area where the the horizontal and vertical margins are joined; \fBmain\fR: all the cells that do not fall into the above three types.  \fIx1\fR \fIy1\fR \fIx2\fR \fIy2\fR gives the extent of the region that needs formatting.
.LP
.nf
Name:	\fBleftMargin\fR
Class:	\fBLeftMargin\fR
Command-line switch:	\fB\-leftmargin\fR
.fi
.IP
In the number of cells, gives the width of vertical margin. A zero indicates that no vertical should be drawn.
.LP
.nf
Name:	\fBselectMode\fR
Class:	\fBSelectMode\fR
Command-line switch:	\fB\-selectmode\fR
.fi
.IP
Specifies one of several styles for manipulating the selection. The value of the option may be arbitrary, but the default bindings expect it to be either \fBsingle\fR, \fBbrowse\fR, \fBmultiple\fR, or \fBextended\fR; the default value is \fBsingle\fR.
.LP
.nf
Name:	\fBselectUnit\fR
Class:	\fBSelectUnit\fR
Command-line switch:	\fB\-selectunit\fR
.fi
.IP
Specifies the selection unit. Valid values are \fBcell\fR, \fBcolumn\fR or \fBrow\fR.
.LP
.nf
Name:	\fBtopMargin\fR
Class:	\fBTopMargin\fR
Command-line switch:	\fB\-topmargin\fR
.fi
.IP
In the number of cells, gives the height of horizontal margin. A zero indicates that no horizontal should be drawn.
.BE
.SH DESCRIPTION
The \fBtixGrid\fR command creates a new window (given by the \fIpathName\fR argument) and makes it into a \fBtixGrid\fR widget.  Additional options, described above, may be specified on the command line or in the option database to configure aspects of the \fBtixGrid\fR widget such as its cursor and relief.
.PP
A Grid widget displays its contents in a two dimensional grid of cells. Each cell may contain one Tix \fBdisplay\fR \fBitem\fR, which may be in text, graphics or other formats. See the \fBtixItemType(n)\fR manual page for more information about Tix display items. Individual cells, or groups of cells, can be formatted with a wide range of attributes, such as its color, relief and border.
.SH "WIDGET COMMAND"
.PP
The \fBtixGrid\fR command creates a new Tcl command whose name is the same as the path name of the \fBtixGrid\fR widget's window. This command may be used to invoke various operations on the widget. It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
.DE
\fIPathName\fR is the name of the command, which is the same as the \fBtixGrid\fR widget's path name. \fIOption\fR and the \fIarg\fRs determine the exact behavior of the command. The following commands are possible for \fBtixGrid\fR widgets:
.TP
\fIpathName\fR \fBanchor\fR \fIoption\fR \fR?\fIargs\fR \fI...\fR\fR?
Manipulates the \fBanchor cell\fR of the \fBtixGrid\fR widget. The anchor cell is the end of the selection that is fixed while the user is dragging out a selection with the mouse.
.TP
\fIpathName\fR \fBbdtype\fR
.TP
\fIpathName\fR \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given by \fIoption\fR. \fIOption\fR may have any of the values accepted by the \fBtixGrid\fR command.
.TP
\fIpathName\fR \fBconfigure\fR \fR?\fIoption\fR\fR? \fR?\fIvalue\fR \fIoption\fR \fIvalue\fR \fI...\fR\fR?
Query or modify the configuration options of the widget.  If no \fIoption\fR is specified, returns a list describing all of the available options for \fIpathName\fR (see \fBTk_ConfigureInfo(n)\fR for information on the format of this list.) If \fIoption\fR is specified with no \fIvalue\fR, then the command returns a list describing the one named option (this list will be identical to the corresponding sublist of the value returned if no \fIoption\fR is specified). If one or more \fIoption\-value\fR pairs are specified, then the command modifies the given widget option(s) to have the given value(s); in this case the command returns an empty string. \fIOption\fR may have any of the values accepted by the \fBtixGrid\fR command.
.TP
\fIpathName\fR \fBdelete\fR \fIdim\fR \fIfrom\fR \fR?\fIto\fR\fR?
\fIDim\fR may be \fBrow\fR or \fBcolumn\fR. If \fIto\fR is not given, deletes a single row (or column) at the position \fIfrom\fR. If \fIto\fR is given, deletes the range of rows (or columns) from position \fIfrom\fR through \fIto\fR.
.TP
\fIpathName\fR \fBedit apply\fR
If any cell is being edited, de-highlight the cell and applies the changes.
.TP
\fIpathName\fR \fBedit set\fR \fIx\fR \fIy\fR
Highlights the cell at (\fIx\fR,\fIy\fR) for editing, if the \fB-editnotify\fR command returns true for this cell.
.TP
\fIpathName\fR \fBentrycget\fR \fIx\fR \fIy\fR \fIoption\fR
Returns the current value of the configuration option given by \fIoption\fR of the cell at (\fIx\fR,\fIy\fR). \fIOption\fR may have any of the values accepted by the \fBset\fR widget command.
.TP
\fIpathName\fR \fBentryconfigure\fR \fIx\fR \fIy\fR \fR?\fIoption\fR\fR? \fR?\fIvalue\fR \fIoption\fR \fIvalue\fR \fI...\fR\fR?
Query or modify the configuration options of the cell at (\fIx\fR,\fIy\fR).  If no \fIoption\fR is specified, returns a list describing all of the available options for the cell (see \fBTk_ConfigureInfo(n)\fR for information on the format of this list.)  If \fIoption\fR is specified with no \fIvalue\fR, then the command returns a list describing the one named option (this list will be identical to the corresponding sublist of the value returned if no \fIoption\fR is specified.) If one or more \fIoption\-value\fR pairs are specified, then the command modifies the given widget option(s) to have the given value(s); in this case the command returns an empty string.  \fIOption\fR may have any of the values accepted by the \fBset\fR widget command.
.TP
\fIpathName\fR \fBformat\fR
.TP
\fIpathName\fR \fBindex\fR
.TP
\fIpathName\fR \fBmove\fR \fIdim\fR \fIfrom\fR \fIto\fR \fIoffset\fR
\fIDim\fR may be \fBrow\fR or \fBcolumn\fR. Moves the the range of rows (or columns) from position \fIfrom\fR through \fIto\fR by the distance indicated by \fIoffset\fR. For example, \fBmove\fR \fBrow\fR \fB2\fR \fB4\fR \fB1\fR moves the rows 2,3,4 to rows 3,4,5.
.TP
\fIpathName\fR \fBset\fR \fIx\fR \fIy\fR \fR?\fI\fB-itemtype\fR\fR \fItype\fR\fR? \fR?\fIoption\fR \fIvalue...\fR\fR?
Creates a new display item at the cell at (\fIx\fR,\fIy\fR). The optional \fB-itemtype\fR parameter gives the type of the display item. An additional list of \fIoption-value\fR pairs specify options of the display item. If a display item already exists at this cell, the old item will be deleted automatically.
.TP
\fIpathName\fR \fBsize\fR \fIdim\fR \fIindex\fR \fR?\fIoption\fR \fIvalue\fR \fI...\fR\fR?
Queries or sets the size of the row or column given by \fIdim\fR and \fIindex\fR. \fIDim\fR may be \fBrow\fR or \fBcolumn\fR.  \fIIndex\fR may be any non-negative integer that gives the position of a given row (or column). \fIIndex\fR can also be the string \fBdefault\fR; in this case, this command queries or sets the default size of all rows (or columns).

When no \fIoption\fR-\fIvalue\fR pair is given, this command returns a list containing the current size setting of the given row (or column). When \fIoption\fR-\fIvalue\fR pairs are given, the corresponding options of the size setting of the given row are changed. \fIOption\fR may be one of the follwing:
.RS
.TP
\fB-pad0\fR \fIpixels\fR
Specifies the paddings to the left or a column or the top of a row.
.TP
\fB-pad1\fR \fIpixels\fR
Specifies the paddings to the right or a column or the bottom of a row.
.TP
\fB-size\fR \fIval\fR
Specifies the width of a column or the height of a row. \fIVal\fR may be: \fBauto\fR -- the width of the column is set the the widest cell in the column; a valid Tk screen distance unit (see \fBTk_GetPixels(n)\fR); or a real number following by the word \fBchars\fR (e.g. \fB3.4chars\fR) that sets the width of the column to the given number of characters.
.RE
.TP
\fIpathName\fR \fBunset\fR \fIx\fR \fIy\fR
Clears the cell at (\fIx\fR,\fIy\fR) by removing its display item.
.TP
\fIpathName\fR \fBxview\fR
.TP
\fIpathName\fR \fByview\fR
.DE

