/* Macro definitions for GDB 4.17 an Intel i386 DG/ux.
   Copyright 1991, 1992 Free Software Foundation, Inc.
   Written by Takis Psarogiannakopoulos
   Department of Pure Mathematics, Cambridge University
   UK , e-mail <takis@dpmms.cam.ac.uk>

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* from System V xm-file */
#define HOST_BYTE_ORDER LITTLE_ENDIAN

#if !defined (USG)
#define USG 1
#endif

#include <sys/param.h>
#include <limits.h>
#include <sys/param.h>
#include <ieeefp.h>
#include <float.h>
#include <sys/dg_xtrace.h>
/* #include <dwarf.h> */


/* Definitions from an older gdb 3.6.10
 * from DG (dg-rtp) for m88k  
 */

#define x_foff _x_x._x_offset
#define x_fname _x_name
/* DG_XTRACE syscalls */
#define USER ptrace_user
#define user ptrace_user

/* ix86 DG/ux has both termio and termios facilities
   Use posix termios.
*/

#undef HAVE_TERMIO
#define HAVE_TERMIOS

#define HAVE_SIGSETMASK 1


/* SIZE of ptrace_user in ix86 DG/ux 
 * should be 2048
 */

#define KERNEL_U_SIZE i386dgux_kernel_u_size()
#define USIZE i386dgux_kernel_u_size()
#define NBPG NBPC
#define UPAGES USIZE

/* This soubroutine is in i386dgux-nat.c */
extern int
i386dgux_kernel_u_size PARAMS ((void));


/* Ptrace commnads  */

#define PT_READ_I       1       /* Read word from text space */
#define PT_READ_D       2       /* Read word from data space */
#define PT_READ_U       3       /* Read word from kernel user struct */
#define PT_WRITE_I      4       /* Write word to text space */
#define PT_WRITE_D      5       /* Write word to data space */
#define PT_WRITE_U      6       /* Write word to kernel user struct */
#define PT_CONTINUE     7       /* Continue after signal */
#define PT_STEP         9       /* Set flag for single stepping */
#define PT_KILL         8       /* Send child a SIGKILL signal */
#define PTRACE_ATTACH   128
#define PTRACE_DETACH   129

#define PT_INHERIT_TRACE 130

#define ATTACH_DETACH   1

/* Get rid of any system-imposed stack limit if possible.  */

#define SET_STACK_LIMIT_HUGE

/*
   KERNEL_U_ADDR is the amount to subtract from u.u_ar0
   to get the offset in the core file of the register values.
   Since registers in pt_mcontext (gregs and fpregs) are
   stored directly into the ptrace_user structure, the ptrace_user
   offsets are sufficient and KERNEL_U_ADDRESS can be 0.
   In any case in the file dg_xtrace.c we calculate using nlist
   the KERNEL_U_ADDR which is indeed 0 in a ix86 DG/ux.
*/

#define KERNEL_U_ADDR 0

/*****************************
 or use this subroutine that needs -lelf to see
 that indeed KERNEL_U_ADDR is 0
 Get kernel_u_addr using nlist()

 CORE_ADDR kernel_u_addr;

void
_i386dgux_initialize_kernel_u_addr ()
{
  struct nlist names[2];
  names[0].n_name = "_u";
  names[1].n_name = NULL;
  if (nlist ("/dgux", names) == 0)
  {
    kernel_u_addr = names[0].n_value;
  }
  else
  {
    fatal ("ix86 DG/ux:Unable to get kernel_u_addr user area address.");
  }
}
 this should be in i386dgux-nat.c
 then add here
 extern int _i386dgux_initialize_kernel_u_addr((void))
 define KERNEL_U_ADDR _i386dgux_initialize_kernel_u_addr
*******************************/

