// $Id: VSLRead.C,v 1.20.4.1 1999/03/04 13:17:26 zeller Exp $
// Read in VSL library

// Copyright (C) 1995 Technische Universitaet Braunschweig, Germany.
// Written by Andreas Zeller <zeller@ips.cs.tu-bs.de>.
// 
// This file is part of DDD.
// 
// DDD is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// DDD is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with DDD -- see the file COPYING.
// If not, write to the Free Software Foundation, Inc.,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// DDD is the data display debugger.
// For details, see the DDD World-Wide-Web page, 
// `http://www.cs.tu-bs.de/softech/ddd/',
// or send a mail to the DDD developers <ddd@ips.cs.tu-bs.de>.

#include "my-alloca.h"

// Yes, alloca() must come even before this simple stuff.  Sigh.
char VSLRead_rcsid[] = 
    "$Id: VSLRead.C,v 1.20.4.1 1999/03/04 13:17:26 zeller Exp $";

#include <stdlib.h>
#include <limits.h>
#include <iostream.h>
#include <fstream.h>
#include <strstream.h>

#include "assert.h"
#include "strclass.h"
#include "cook.h"

#include "VSLBuiltin.h"

#include "VSLLib.h"
#include "VSLDef.h"
#include "VSLDefList.h"

#include "Box.h"
#include "PrimitiveB.h"
#include "StringBox.h"
#include "TrueBox.h"
#include "ListBox.h"

#include "VSLNode.h"
#include "ConstNode.h"
#include "ListNode.h"
#include "TestNode.h"
#include "DefCallN.h"
#include "LetNode.h"
#include "ArgNode.h"
#include "DummyNode.h"
#include "NameNode.h"
#include "TrueNode.h"

#include "VSEFlags.h"
#include "config.h"


static VSLLib *vsllib = 0;	// The VSL library to read

static string vslfilename = "standard input";   // Current file name

// Some type decls for $$
struct VSLFunctionHeader {
    string *id;
    VSLNode *pattern;
    string *file;
    int line;
};

struct VSLVarDefinition {
    VSLNode *pattern;
    VSLNode *args;
};

// GNU C++ complains about the declaration of VSLSTYPE, so leave it alone
#ifdef __GNUG__
#define VSLSTYPE _xy_VSLSTYPE
#define _VSLSTYPE _xy_underscore_VSLSTYPE
#define vsllval  _xy_vsllval
#include "vsl-gramma.h"
#undef vsllval
#undef _VSLSTYPE
#undef VSLSTYPE
#else
#include "vsl-gramma.h"
#endif

#define ASSERT(ignore)

// Set this to enable assertions while parsing
// #undef ASSERT
// #define ASSERT(x) assert(x)

// The parse function generated by YACC -- this cannot be a C++ name
#define vslparse VSLLib_parse

#include "vsl-lex.C"
#include "vsl-gramma.C"

#undef vslparse

// Read library

// Read library from stream
VSLLib& VSLLib::read(istream& s, unsigned optimizeMode)
{
    vsllib = this;

    vslstream = &s;
    vslfilename = _lib_name;

    // Einlesen...
    vslnameSet.reset();
    pushback_ptr = pushback;
    parse();

    if (VSEFlags::verbose)
    {
	cout << ")";
	cout.flush();
    }

    // Post-processing (Binding, optimization, etc.)
    process(optimizeMode);

    if (VSEFlags::verbose)
	cout << ", done.\n";

    return *this;
}


// Read library from file
VSLLib& VSLLib::read(const string& lib_name, unsigned optimizeMode)
{
    if (VSEFlags::verbose)
    {
	if (lib_name == "")
	    cout << "standard input";
	else
	    cout << lib_name;
	cout << ": reading";
	cout.flush();
    }

    vslfilename = lib_name;

    switchreset();
    if (switchup(lib_name, True) == 0)
    {
	assert(vslstream != 0);

	topstack = 0;
	read(*vslstream, optimizeMode);
    }

    return *this;
}


// Error handling

// Yacc-specific error handling
void vslerror(char *s)
{
    string errmsg = s;

    if (errmsg == "syntax error" || errmsg == "parse error")
	 errmsg += " near " + quote((char *)vsltext);

    VSLLib::parse_error(errmsg);
}

// Parsing message
void VSLLib::parse_echo(const string& msg)
{
    ostrstream os;
    ostream& s = os;
    
    s << vslfilename << ":" << vsllinenumber << ": " << msg;
    echo(os);
}

// Parsing error
void VSLLib::parse_error(const string& errmsg)
{
    parse_echo(errmsg);
}

// Parsing warning
void VSLLib::parse_warning(const string& errmsg)
{
    parse_echo("warning: " + errmsg);
}
