XCOMM! /bin/sh

XCOMM lndir - create shadow link tree
XCOMM
XCOMM $XFree86: mit/util/scripts/lndir.cpp,v 1.3 1993/05/16 13:16:00 dawes Exp $
XCOMM $XConsortium: lndir.sh,v 1.8 91/04/15 17:55:03 rws Exp $
XCOMM
XCOMM Used to create a copy of the a directory tree that has links for all
XCOMM non- directories (except those named RCS, CVS or SCCS).  If you are
XCOMM building the distribution on more than one machine, you should use
XCOMM this script.
XCOMM
XCOMM If your master sources are located in /usr/local/src/X and you would like
XCOMM your link tree to be in /usr/local/src/new-X, do the following:
XCOMM
XCOMM 	%  mkdir /usr/local/src/new-X
XCOMM	%  cd /usr/local/src/new-X
XCOMM 	%  lndir ../X

USAGE="Usage: $0 fromdir [todir]"

if [ $# -lt 1 -o $# -gt 2 ]
then
	echo "$USAGE"
	exit 1
fi

DIRFROM=$1

if [ $# -eq 2 ];
then
	DIRTO=$2
else
	DIRTO=.
fi

if [ ! -d $DIRTO ]
then
	echo "$0: $DIRTO is not a directory"
	echo "$USAGE"
	exit 2
fi

cd $DIRTO

if [ ! -d $DIRFROM ]
then
	echo "$0: $DIRFROM is not a directory"
	echo "$USAGE"
	exit 2
fi

pwd=`pwd`

if [ `(cd $DIRFROM; pwd)` = $pwd ]
then
	echo "$pwd: FROM and TO are identical!"
	exit 1
fi

for file in `ls LSAF $DIRFROM`
do
    if [ ! -d $DIRFROM/$file ]
    then
	    ln -s $DIRFROM/$file .
    else
	    if [ $file != RCS -a $file != CVS -a $file != SCCS -a \
		 $file != . -a $file != .. ]
	    then
		    echo $file:
		    mkdir $file
		    (cd $file
		     pwd=`pwd`
		     case "$DIRFROM" in
			     /?*) ;;
			     *)  DIRFROM=../$DIRFROM ;;
		     esac
		     if [ `(cd $DIRFROM/$file; pwd)` = $pwd ]
		     then
			    echo "$pwd: FROM and TO are identical!"
			    exit 1
		     fi
		     $0 $DIRFROM/$file
		    )
	    fi
    fi
done
