/************************************************************************/
/* 									*/
/* ExtrDialog.cc: Implementation of the ExtrDialog class		*/
/*		  This is a dialog to start the file extraction		*/
/*		  Roland Krause 1998, 1999				*/
/*									*/
/************************************************************************/

// --- Include ----------------------------------------------------------

#include <stdio.h>
#include <unistd.h>

#include <X11/Intrinsic.h>		// Header of Xt
#include <X11/StringDefs.h>		// Ressource definitions

// Header of XawPlus

#include <X11/Shell.h>
#include <X11/XawPlus/Paned.h>		// The panel widget
#include <X11/XawPlus/Form.h>		// The form widget
#include <X11/XawPlus/AsciiText.h>	// The widget for the file list
#include <X11/XawPlus/Command.h>	// The command widget for the buttons

// Class definition of this class

#include "ExtrDialog.h"


// --- Implementation of callbacks -------------------------------------

// The callbacks are not part of this class ! They are only a part of
// this module. That is the reason why all callbacks works on objects.
// Since the callbacks are defined static, they are not visibile outside
// of this module.

// **********************************************************************
//
// CloseWin():	   Callback to close this dialogue window
//
// Arguments:	   clientData - Pointer to an object of this class
//
// **********************************************************************

void CloseWin(Widget w, XtPointer clientData, XtPointer callData)
{
  class ExtrDialog *extr = (class ExtrDialog *)clientData;

  XtPopdown(extr->dialogShell);
  delete(extr->FileList);
  extr->FileList = NULL;
}

// **********************************************************************
//
// ExtrFile():	   Callback to start file extraction
//
// Arguments:	   clientData - Pointer to an object of this class
//
// **********************************************************************

void ExtrFile(Widget w, XtPointer clientData, XtPointer callData)
{
  class ExtrDialog *extr = (class ExtrDialog *)clientData;

  if (extr->Extract()) XtPopdown(extr->dialogShell);
  else XBell(XtDisplay(extr->dialogShell), 100);
  delete(extr->FileList);
  extr->FileList = NULL;
}

// --- Implementation of class methods ----------------------------------

// **********************************************************************
//
// ExtrDialog(): The constructor of this class
//		 Creates the dialogue window
//
// Arguments:	 rootShell - The root shell widget of this application
//
// **********************************************************************

ExtrDialog::ExtrDialog(Widget rootShell)
{
   Widget dialogPanel, pathForm, buttonForm, pathLabel, ok, abort;
   static char	*NoCR = "<Key>Return: no-op()";
   XtTranslations TransTab;

// Initialize some variables

   FileList = NULL;
   tarObj = NULL;

// At first we create the viewer shell and base panel

   dialogShell= XtVaCreatePopupShell("extrShell", transientShellWidgetClass, rootShell,
		XtNallowShellResize, TRUE, NULL);

   dialogPanel= XtVaCreateManagedWidget("dialogPanel", panedWidgetClass, dialogShell, NULL);

// On the dialogPanel we create two forms for the text widget and the buttons

   pathForm=	XtVaCreateManagedWidget("pathForm", formWidgetClass, dialogPanel,
		XtNshowGrip, FALSE, NULL);

   buttonForm=	XtVaCreateManagedWidget("buttonForm", formWidgetClass, dialogPanel,
		XtNshowGrip, FALSE, XtNskipAdjust, TRUE, NULL);

// Now we create the widgets on the upper form

   pathLabel=	XtVaCreateManagedWidget("pathLabel", labelWidgetClass, pathForm,
		XtNborderWidth, 0, XtNjustify, XtJustifyLeft,
		XtNleft, XtChainLeft, XtNright, XtChainLeft, NULL);

   pathName=	XtVaCreateManagedWidget("path", asciiTextWidgetClass, pathForm,
		XtNleft, XtChainLeft, XtNright, XtChainRight,
		XtNeditType, XawtextEdit, XtNstring, "",
		XtNfromHoriz, pathLabel, NULL);

// This is only a one line input field. So we let the widget
// ignore the input of a newline

  TransTab = XtParseTranslationTable(NoCR);
  XtOverrideTranslations(pathName, TransTab);

// ... and the widgets on the lower form

   ok=		XtVaCreateManagedWidget("ok", commandWidgetClass, buttonForm,
		XtNleft, XtChainRight, XtNright, XtChainRight,
		XtNtop, XtChainBottom, XtNbottom, XtChainBottom,
		NULL);
   XtAddCallback(ok, XtNcallback, ExtrFile, (XtPointer)this);

   abort=	XtVaCreateManagedWidget("abort", commandWidgetClass, buttonForm,
		XtNleft, XtChainRight, XtNright, XtChainRight,
		XtNtop, XtChainBottom, XtNbottom, XtChainBottom,
		XtNfromHoriz, ok, NULL);
   XtAddCallback(abort, XtNcallback, CloseWin, (XtPointer)this);
}


// **********************************************************************
//
// PopUp():	Pop up the dialog shell at the given position
//
// Arguments:	x, y  - Position of the upper left corner of the
//			dialogue window
//		path  - A pathname string, displayed in the dialogue
//		flist - A list of file names to extract from archive
//		tar   - The object that handles the interface to tar
//
// **********************************************************************

void ExtrDialog::PopUp(int x, int y, char *path, char *flist, class HandleTar *tar)
{
   FileList = strdup(flist);
   tarObj = tar;
   XtVaSetValues(dialogShell, XtNx, x, XtNy, y, NULL);
   XtVaSetValues(pathName, XtNstring, path, NULL);
   XtPopup(dialogShell, XtGrabExclusive);
}


// **********************************************************************
//
// Extract():	Start the extraction of files from an archive
//
// Arguments:	None
//
// **********************************************************************

Boolean ExtrDialog::Extract(void)
{
   char *Path;

   XtVaGetValues(pathName, XtNstring, &Path, NULL);

  // We only can extract files, if we have access rights
  // and if the directory exists

  if (access(Path, X_OK) == 0)
  {
     tarObj->ExtractFiles(FileList, Path);
     return(TRUE);
  }
  return(FALSE);
}

