/************************************************************************/
/* 									*/
/* 	filefunc.h : Zugriffsfunktionen auf das Dateisystem fuer Xe	*/
/*		     Roland Krause 1996					*/
/*									*/
/************************************************************************/

/* Exportiert folgende Funktionen :
 *
 * InitModule()     :	Initialisiert das Modul
 * ExitModule()     :   Gibt alle durch das Modul belegte Ressourcen frei
 * BuildFileList()  :	Erzeugt eine Dateiliste mit allen Dateien im
 *			aktuellen Verzeichnis. Liefert NULL-Zeiger
 *			bei Fehlern, sonst Zeiger auf die Dateiliste.
 * GetIconDepth()   :   Ermittelt die Tiefe der Icon-Pixmaps
 * GetFileName()    :	Erzeugt vollstaendigen Dateinamen
 * GetPathName()    :   Liefert den aktuellen Pfadnamen
 * ChangeDir()      :	Wechselt das Verzeichnis
 * ResetDir()	    :	Macht den Wechsel wieder rueckgaengig
 * CheckFileType()  :   Prueft, um welchen Typ es sich bei einer Datei handelt
 */

/* Konstante fuer die Icon-Bitmaps */

#define ICON_WIDTH	16
#define ICON_HEIGHT	16

/* Datentyp fuer CheckFileType */

typedef enum
{
  XE_FAULT,		/* Ungueltiger Eintrag (z.B. nicht ausfuerbares Verzeichnis) */
  XE_FILE,		/* Normale Datei */
  XE_DIRECTORY		/* Verzeichnis */
}
  XeFileType;

extern int		InitModule(Widget shell);
extern void		ExitModule(Widget shell);
extern XawIconList	*BuildFileList(void);
extern int		GetIconDepth(void);
extern char		*GetFileName(int Index);
extern char		*GetPathName(void);
extern void		ChangeDir(int Index);
extern void		ResetDir(void);
extern XeFileType	CheckFileType(int Index);
