/****************************************************************/
/* 								*/
/* 	Demo-Programm fuer das Drawing Area Widget		*/
/*	Roland Krause 1996					*/
/*								*/
/****************************************************************/

/* --- Include ------------------------------------------------ */

#include <stdio.h>			/* Standard-Ein/Ausgabe */
#include <stdlib.h>			/* Standard-C-Funktionen */
#include <time.h>			/* Akt. Zeit als Basis fuer
					   Zufallsgenerator */
#include <X11/Intrinsic.h>		/* Xt-Header */
#include <X11/StringDefs.h>		/* Ressource-Strings */

#include <X11/Shell.h>			/* Shell-Widget */
#include <X11/XawPlus/Paned.h>		/* Das Panel-Widget als Rahmen */
#include <X11/XawPlus/Box.h>		/* Manager fuer die Buttons */

#include <X11/XawPlus/DrawingArea.h>	/* Zeichenflaeche */
#include <X11/XawPlus/Command.h>	/* Buttons */
#include <X11/XawPlus/Label.h>		/* Textmarke */

/* --- Typdefinitionen ------------------------------------------ */

typedef struct
{
  Widget  MainShell,			/* Shell-Widget der Anwendung */
	  Title,			/* Textzeile */
	  Paint;			/* Die Zeichenflaeche */
  Pixmap  icon, iconClip;		/* Icon fuer das Programm */
  GC	  gc[4];			/* Grafik-Kontexte zum Zeichnen */
}
  GLOBALS;

/* --- Globale Variable ----------------------------------------- */

GLOBALS Glob;

/* --- Fallback - Ressourcen ------------------------------------ */

/* Diese Resourcen werden genutzt, wenn keine Parameter
 * angegeben werden
 */
char *fallback[] =
{  "*font:              -*-courier-bold-r-normal-*-13-*-*-*-*-*-iso8859-1",
   "*title.label:	Demonstration for the drawing area widget",

   /* Hoehe und Breite der Zeichenflaeche */

   "*drawingArea.width:		500",
   "*drawingArea.height:	400",

   /* Icons fuer die Buttons */

   "*p1.bitmap:		rect.xpm",
   "*p1.clipMask:	rect.xpm",
   "*p2.bitmap:		circ.xpm",
   "*p2.clipMask:	circ.xpm",
   "*p3.bitmap:		fillrect.xpm",
   "*p3.clipMask:	fillrect.xpm",
   "*p4.bitmap:		fillcirc.xpm",
   "*p4.clipMask:	fillcirc.xpm",
   "*p5.bitmap:		textdemo.xpm",
   "*p5.clipMask:	textdemo.xpm",
   "*quit.bitmap:	xdrexit.xpm",
   "*quit.clipMask:	xdrexit.xpm",
   NULL};

/* --- Farbe beschaffen --------------------------------------- */

/* Belegt in der Standard-Farbtabelle des Displays die Farbe, die
 * sich aus den Grundfarben red, green und blue ergibt. Im Fehler-
 * fall wird die Farbe schwarz zurueckgegeben.
 */
Pixel GetColor(Display *dpy, int scr, short red, short green, short blue)
{
  Colormap cmap = DefaultColormap(dpy, scr);
  XColor   color;

  color.red   = red;
  color.green = green;
  color.blue  = blue;

  if (XAllocColor(dpy, cmap, &color)) return(color.pixel);
  return(BlackPixel(dpy, scr));
}

/* --- Grafik-Kontexte beschaffen ----------------------------- */

void CreateGCs(Widget shell, GC gc[])
{
  XGCValues	val;
  Display	*disp  = XtDisplay(shell);
  int		screen = XDefaultScreen(disp);

  /* GC mit blauer Zeichenfarbe beschaffen */

  val.foreground = GetColor(disp, screen, 0x0, 0x0, 0xAAAA);
  gc[0]	 	= XtGetGC(shell, GCForeground, &val);

  /* GC mit gruener Zeichenfarbe beschaffen */

  val.foreground = GetColor(disp, screen, 0x0, 0xAAAA, 0x0);
  gc[1]	 	= XtGetGC(shell, GCForeground, &val);

  /* GC mit roter Zeichenfarbe beschaffen */

  val.foreground = GetColor(disp, screen, 0xFFFF, 0x0, 0x0);
  gc[2]	 	= XtGetGC(shell, GCForeground, &val);

  /* GC mit schwarzer Zeichenfarbe beschaffen */

  val.foreground = BlackPixel(disp, screen);
  gc[3]	 	= XtGetGC(shell, GCForeground, &val);
}

/* --- Callback-Funktionen fuer Buttons ----------------------- */

/* Programm beenden
 */
static void EndOfProg(Widget w, XtPointer clientData, XtPointer callData)
{
  Display *disp = XtDisplay(Glob.MainShell);
  int	  i;

  for (i = 0; i < 4; i++) XtReleaseGC(Glob.MainShell, Glob.gc[i]);
  XFreePixmap(disp, Glob.icon);
  XFreePixmap(disp, Glob.iconClip);
  exit(0);
}

/* Zeichnet einige Rechtecke
 */
static void DrawRectangles(Widget w, XtPointer clientData, XtPointer callData)
{
   Dimension	widthArea, heightArea;
   int		i, x, y, width, height;

   XawClearWindow(Glob.Paint);
   XtVaSetValues(Glob.Title, XtNlabel, "Rectangle demonstration", NULL);
   XtVaGetValues(Glob.Paint, XtNheight, &heightArea, XtNwidth, &widthArea, NULL);
   srand(time(NULL));

   for (i = 0; i < 100; i++)
   {
      width 	= rand() % (int)(widthArea >> 2);
      height	= rand() % (int)(heightArea >> 2);
      x		= rand() % ((int)(widthArea) - width);
      y		= rand() % ((int)(heightArea) - height);
      XawDrawRectangle(Glob.Paint, Glob.gc[i % 3], x, y, width, height);
   }
}

/* Zeichnet einige Kreise
 */
static void DrawCircles(Widget w, XtPointer clientData, XtPointer callData)
{
   Dimension	widthArea, heightArea;
   int i, x, y, width, height;

   XawClearWindow(Glob.Paint);
   XtVaSetValues(Glob.Title, XtNlabel, "Circle demonstration", NULL);
   XtVaGetValues(Glob.Paint, XtNheight, &heightArea, XtNwidth, &widthArea, NULL);
   srand(time(NULL));

   for (i = 0; i < 100; i++)
   {
      width 	= rand() % (int)(widthArea >> 2);
      height	= rand() % (int)(heightArea >> 2);
      x		= rand() % ((int)(widthArea) - width);
      y		= rand() % ((int)(heightArea) - height);
      XawDrawArc(Glob.Paint, Glob.gc[i % 3], x, y, width, height, 0, 360<<6);
   }
}

/* Zeichnet gefuellte Rechtecke
 */
static void DrawFilledRectangles(Widget w, XtPointer clientData, XtPointer callData)
{
   Dimension	widthArea, heightArea;
   int		i, x, y, width, height;

   XawClearWindow(Glob.Paint);
   XtVaSetValues(Glob.Title, XtNlabel, "Filled rectangle demonstration", NULL);
   XtVaGetValues(Glob.Paint, XtNheight, &heightArea, XtNwidth, &widthArea, NULL);
   srand(time(NULL));

   /* Rechtecke mit Rahmen zeichnen */

   for (i = 0; i < 100; i++)
   {
      width 	= rand() % (int)(widthArea >> 2);
      height	= rand() % (int)(heightArea >> 2);
      x		= rand() % ((int)(widthArea) - width);
      y		= rand() % ((int)(heightArea) - height);
      XawFillRectangle(Glob.Paint, Glob.gc[i % 3], x, y, width, height);
      XawDrawRectangle(Glob.Paint, Glob.gc[3], x, y, width, height);
   }
}

/* Zeichnet gefuellte Kreise
 */
static void DrawFilledCircles(Widget w, XtPointer clientData, XtPointer callData)
{
   Dimension	widthArea, heightArea;
   int		i, x, y, width, height;


   XawClearWindow(Glob.Paint);
   XtVaSetValues(Glob.Title, XtNlabel, "Filled circle demonstration", NULL);
   XtVaGetValues(Glob.Paint, XtNheight, &heightArea, XtNwidth, &widthArea, NULL);
   srand(time(NULL));

   /* Gefuellte Kreise mit Rand zeichnen */

   for (i = 0; i < 100; i++)
   {
      width 	= rand() % (int)(widthArea >> 2);
      height	= rand() % (int)(heightArea >> 2);
      x		= rand() % ((int)(widthArea) - width);
      y		= rand() % ((int)(heightArea) - height);
      XawFillArc(Glob.Paint, Glob.gc[i % 3], x, y, width, height, 0, 360<<6);
      XawDrawArc(Glob.Paint, Glob.gc[3], x, y, width, height, 0, 360<<6);
   }
}

/* Zeichnet Text
 */
static void DrawText(Widget w, XtPointer clientData, XtPointer callData)
{
   Dimension	widthArea, heightArea;
   int		i, x, y, dy;
   static char  *str = "Draw text demonstration";

   XawClearWindow(Glob.Paint);
   XtVaSetValues(Glob.Title, XtNlabel, str, NULL);
   XtVaGetValues(Glob.Paint, XtNheight, &heightArea, XtNwidth, &widthArea, NULL);
   srand(time(NULL));

   /* Text zeichnen */

   dy = (int)heightArea/40;
   y  = 10;
   for (i = 1; i < 40; i++)
   {
      XawDrawString(Glob.Paint, Glob.gc[i % 3], x, y, str, strlen(str));
      y += dy;
      x  = y*y / 400;
   }
}

/* --- CreateMainWindow() -------------------------------------- */

/* Erzeugt alle Widgets fuer das eigene Fenster.
 */
void CreateMainWindow(Widget MainShell, Widget *Title, Widget *Paint)
{
   Widget  basePanel, panel, buttonBox,
	   p1, p2, p3, p4, p5, quit;		/* Buttons */

   /* Das Panel-Widget anmelden und darauf ein Label-Widget fuer Texte,
    * ein Form-Widget fuer die Buttons und ein Drawing-Area-Widget als Zeichen-
    * flaeche einrichten
    */
   basePanel   = XtVaCreateManagedWidget("basePanel", panedWidgetClass, MainShell,
		 XtNorientation, XtorientVertical, NULL);

  *Title       = XtVaCreateManagedWidget("title", labelWidgetClass, basePanel,
		 XtNshowGrip, FALSE, NULL);

   panel       = XtVaCreateManagedWidget("panel", panedWidgetClass, basePanel,
		 XtNorientation, XtorientHorizontal,
		 XtNshowGrip, FALSE, NULL);

   buttonBox   = XtVaCreateManagedWidget("buttonBox", boxWidgetClass, panel,
		 XtNshowGrip, FALSE, NULL);

  *Paint       = XtVaCreateManagedWidget("drawingArea", drawingAreaWidgetClass, panel,
		 XtNshowGrip, FALSE, NULL);

   /* Buttons mit ihren Callbacks auf dem Form-Widget erzeugen */

   p1 = XtVaCreateManagedWidget("p1", commandWidgetClass, buttonBox, NULL);
   p2 = XtVaCreateManagedWidget("p2", commandWidgetClass, buttonBox, NULL);
   p3 = XtVaCreateManagedWidget("p3", commandWidgetClass, buttonBox, NULL);
   p4 = XtVaCreateManagedWidget("p4", commandWidgetClass, buttonBox, NULL);
   p5 = XtVaCreateManagedWidget("p5", commandWidgetClass, buttonBox, NULL);
   quit  = XtVaCreateManagedWidget("quit", commandWidgetClass, buttonBox, NULL);

   XtAddCallback(quit, XtNcallback, EndOfProg, NULL);
   XtAddCallback(p1,   XtNcallback, DrawRectangles, NULL);
   XtAddCallback(p2,   XtNcallback, DrawCircles, NULL);
   XtAddCallback(p3,   XtNcallback, DrawFilledRectangles, NULL);
   XtAddCallback(p4,   XtNcallback, DrawFilledCircles, NULL);
   XtAddCallback(p5,   XtNcallback, DrawText, NULL);
}

/* --- main() ------------------------------------------------- */

int main(int argc, char *argv[])
{
   XtAppContext	app;			/* Kontext dieses Programms */
  Display	*disp;
  Window	win;

   /* Xt initialisieren */

   XtSetLanguageProc(NULL, NULL, NULL);
   Glob.MainShell = XtAppInitialize(&app, "XDrawDemo", NULL, 0, &argc, argv, fallback, NULL, 0);
   disp = XtDisplay(Glob.MainShell);
   win  = XDefaultRootWindow(disp);

   /* Widgets erzeugen, Ereigniswarteschleife starten */

   CreateMainWindow(Glob.MainShell, &Glob.Title, &Glob.Paint);
   CreateGCs(Glob.MainShell, Glob.gc);
   XtRealizeWidget(Glob.MainShell);
   XtAppMainLoop(app);
   return(0);
}


