
/*******************************************************************************
	file_dialog.c

       Associated Header file: file_dialog.h
*******************************************************************************/

#include <stdio.h>

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/MwmUtil.h>
#include <Xm/DialogS.h>
#include <Xm/MenuShell.h>
#endif /* MOTIF */

#include "UxXt.h"
#include <Xm/List.h>
#include <Xm/ScrolledW.h>
#include <Xm/TextF.h>
#include <Xm/Separator.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/Form.h>

/*******************************************************************************
       Includes, Defines, and Global variables from the Declarations Editor:
*******************************************************************************/


char pwdstr[BUFSIZ];
extern int getrem;
extern Widget vt1;
void popup_file_dialog();


static	int _UxIfClassId;
/*******************************************************************************
       The following header file defines the context structure.
*******************************************************************************/

#ifndef XKLOADDS
#define XKLOADDS
#endif /* XKLOADDS */

#define CONTEXT_MACRO_ACCESS 1
#include "file_dialog.h"
#undef CONTEXT_MACRO_ACCESS

Widget	file_dialog;
Widget	textField4;
Widget	filelist;
Widget	dirlist;

/*******************************************************************************
Auxiliary code from the Declarations Editor:
*******************************************************************************/

void popup_file_dialog()
{
    UxPopupInterface( file_dialog, no_grab );
}

/*******************************************************************************
       The following are callback functions.
*******************************************************************************/

static void  activateCB_pushButton8(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCfile_dialog         *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxFile_dialogContext;
	UxFile_dialogContext = UxContext =
			(_UxCfile_dialog *) UxGetContext( UxWidget );
	{
	char *filename = NULL;
	char command[BUFSIZ];
	
#ifdef VT
	filename = XmTextGetString( textField4 );
	sprintf( command, "get %s\n", filename + strlen( pwdstr ) );
	XmVtSend( vt1, command );
#endif
	}
	UxFile_dialogContext = UxSaveCtx;
}

static void  activateCB_pushButton7(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCfile_dialog         *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxFile_dialogContext;
	UxFile_dialogContext = UxContext =
			(_UxCfile_dialog *) UxGetContext( UxWidget );
	{
	UxPopdownInterface( file_dialog );
	}
	UxFile_dialogContext = UxSaveCtx;
}

static void  activateCB_pushButton12(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCfile_dialog         *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxFile_dialogContext;
	UxFile_dialogContext = UxContext =
			(_UxCfile_dialog *) UxGetContext( UxWidget );
	{
	{
	    char *filename = NULL;
	    char command[BUFSIZ];
	    int inx = 0;
	    char extension[BUFSIZ];
	    int dattype = 0;
	    int lastpd = 0;
	
#ifdef VT
	
	    filename = XmTextGetString( textField4 );
	    for (inx=0;inx < strlen(filename);inx++)
	        if (filename[inx] == '.' || filename[inx] == '/') lastpd = inx;
	
	    strcpy (extension, filename+lastpd+1);
	
	    if (strcmp (extension, "txt") == 0 )   dattype = 0;
	    if (strcmp (extension, "README") == 0) dattype = 0;
	    if (strcmp (extension, "readme") == 0) dattype = 0;
	    if (strcmp (extension, "Readme") == 0) dattype = 0;
	    if (strcmp (extension, "Readme") == 0) dattype = 0;
	
	    if (strcmp (extension, "gif") == 0)    dattype = 1;
	    if (strcmp (extension, "bmp") == 0)    dattype = 1;
	    if (strcmp (extension, "tif") == 0)    dattype = 1;
	    if (strcmp (extension, "ppm") == 0)    dattype = 1;
	    if (strcmp (extension, "pnm") == 0)    dattype = 1;
	    if (strcmp (extension, "pgm") == 0)    dattype = 1;
	    if (strcmp (extension, "pbm") == 0)    dattype = 1;
	    if (strcmp (extension, "xbm") == 0)    dattype = 1;
	    if (strcmp (extension, "jpg") == 0)    dattype = 1;
	    if (strcmp (extension, "jpeg") == 0)   dattype = 1;
	
	    if (strcmp (extension, "ps") == 0)     dattype = 2;
	
	    if (strcmp (extension, "html") == 0)   dattype = 3;
	
	    if (strcmp (extension, "tgz") == 0)    dattype = 4;
	    if (strcmp (extension, "gz") == 0)     dattype = 4;
	
	    if (strcmp (extension, "zip") == 0)    dattype = 5;
	
	
	
	
	    switch (dattype)
	    {
	        case 0:    sprintf( command, "get %s \"| cat\"\n", filename + strlen( pwdstr ) ); break;
	        case 1:    sprintf( command, "get %s \"| xv -\"\n", filename + strlen( pwdstr ) ); break;
	        case 2:    sprintf( command, "get %s \"| cat >/tmp/tmp.ps ; ghostview /tmp/tmp.ps;rm /tmp/tmp.ps\"\n", filename + strlen( pwdstr ) ); break;
	        case 3:    sprintf( command, "get %s \"| cat >/tmp/tmp.html ; Mosaic /tmp/tmp.html;rm /tmp/tmp.html\"\n", filename + strlen( pwdstr ) ); break;
	        case 4:    sprintf( command, "get %s \"| cat >%s ; gunzip %s\"\n", filename + strlen( pwdstr ), filename + strlen( pwdstr ), filename + strlen( pwdstr ) ); break;
	        case 5:    sprintf( command, "get %s \"| cat >%s ; unzip -o -x %s\"\n", filename + strlen( pwdstr ), filename + strlen( pwdstr ), filename + strlen( pwdstr ) ); break;
	    }
	
	    XmVtSend( vt1, command );
	
#endif
	}
	}
	UxFile_dialogContext = UxSaveCtx;
}

static void  activateCB_pushButton4(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCfile_dialog         *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxFile_dialogContext;
	UxFile_dialogContext = UxContext =
			(_UxCfile_dialog *) UxGetContext( UxWidget );
	{
	
	}
	UxFile_dialogContext = UxSaveCtx;
}

static void  activateCB_textField4(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCfile_dialog         *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxFile_dialogContext;
	UxFile_dialogContext = UxContext =
			(_UxCfile_dialog *) UxGetContext( UxWidget );
	{
	{
	    char command[BUFSIZ];
	
#ifdef VT
	    sprintf( command, "cd %s\n", XmTextFieldGetString (UxGetWidget (textField4)));
	    XmVtSend (vt1, command );
	    sprintf( command, "pwd\n" );
	    XmVtSend( vt1, command );
	    sprintf( command, "ls -la\n" );
	    XmVtSend( vt1, command );
	    getrem = TRUE;
#endif
	
	}
	}
	UxFile_dialogContext = UxSaveCtx;
}

static void  browseSelectionCB_filelist(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCfile_dialog         *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxFile_dialogContext;
	UxFile_dialogContext = UxContext =
			(_UxCfile_dialog *) UxGetContext( UxWidget );
	{
	{
	    XmListCallbackStruct *call_data;
	    char *line = NULL;
	    char path[BUFSIZ];
	    Widget tf4 = NULL;
	
	    tf4 = UxGetWidget( textField4 );
	    call_data = ( XmListCallbackStruct * )UxCallbackArg;
	    XmStringGetLtoR( call_data->item, XmSTRING_DEFAULT_CHARSET, &line );
	    sprintf( path, "%s%s", pwdstr, line );
	    XmTextSetString( tf4, path );
	    XmTextFieldSetInsertionPosition( tf4, XmTextFieldGetLastPosition( tf4 ) );
	}
	
	}
	UxFile_dialogContext = UxSaveCtx;
}

static void  defaultActionCB_filelist(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCfile_dialog         *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxFile_dialogContext;
	UxFile_dialogContext = UxContext =
			(_UxCfile_dialog *) UxGetContext( UxWidget );
	{
	char *filename = NULL;
	char command[BUFSIZ];
#ifdef VT
	filename = XmTextGetString( textField4 );
	sprintf( command, "get %s\n", filename + strlen( pwdstr ) );
	XmVtSend( vt1, command );
#endif
	}
	UxFile_dialogContext = UxSaveCtx;
}

static void  defaultActionCB_dirlist(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCfile_dialog         *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxFile_dialogContext;
	UxFile_dialogContext = UxContext =
			(_UxCfile_dialog *) UxGetContext( UxWidget );
	{
	{
	    char command[BUFSIZ];
	    XmListCallbackStruct *call_data;
	    char *line = NULL;
	    call_data = ( XmListCallbackStruct * )UxCallbackArg;
	    XmStringGetLtoR( call_data->item, XmSTRING_DEFAULT_CHARSET, &line );
	
#ifdef VT
	    sprintf( command, "cd %s\n", line );
	    XmVtSend( vt1, command );
	    sprintf( command, "pwd\n" );
	    XmVtSend( vt1, command );
	    sprintf( command, "ls -la\n" );
	    XmVtSend( vt1, command );
	    getrem = TRUE;
#endif
	}
	
	}
	UxFile_dialogContext = UxSaveCtx;
}

/*******************************************************************************
       The 'build_' function creates all the widgets
       using the resource values specified in the Property Editor.
*******************************************************************************/

static Widget	_Uxbuild_file_dialog()
{
	Widget		_UxParent;


	/* Creation of file_dialog */
	_UxParent = XtVaCreatePopupShell( "file_dialog_shell",
			xmDialogShellWidgetClass, UxTopLevel,
			XmNx, 391,
			XmNy, 400,
			XmNwidth, 532,
			XmNheight, 432,
			XmNallowShellResize, TRUE,
			XmNshellUnitType, XmPIXELS,
			XmNtitle, "file_dialog",
			NULL );

	file_dialog = XtVaCreateWidget( "file_dialog",
			xmFormWidgetClass,
			_UxParent,
			XmNunitType, XmPIXELS,
			XmNwidth, 532,
			XmNheight, 432,
			RES_CONVERT( XmNdialogTitle, "Remote Files" ),
			XmNresizePolicy, XmRESIZE_GROW,
			XmNrubberPositioning, TRUE,
			XmNnoResize, FALSE,
			XmNsensitive, TRUE,
			XmNautoUnmanage, FALSE,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( file_dialog, (char *) UxFile_dialogContext );
	UxPutClassCode( file_dialog, _UxIfClassId );


	/* Creation of label6 */
	label6 = XtVaCreateManagedWidget( "label6",
			xmLabelWidgetClass,
			file_dialog,
			XmNx, 10,
			XmNy, 10,
			XmNwidth, 363,
			XmNheight, 30,
			RES_CONVERT( XmNlabelString, "Directories" ),
			XmNalignment, XmALIGNMENT_BEGINNING,
			XmNmarginHeight, 2,
			XmNmarginBottom, 0,
			XmNmarginWidth, 0,
			XmNtopAttachment, XmATTACH_FORM,
			XmNtopOffset, 10,
			XmNrightAttachment, XmATTACH_NONE,
			XmNrightWidget, NULL,
			XmNrightOffset, 10,
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 10,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			XmNleftPosition, 0,
			NULL );
	UxPutContext( label6, (char *) UxFile_dialogContext );


	/* Creation of pushButton8 */
	pushButton8 = XtVaCreateManagedWidget( "pushButton8",
			xmPushButtonWidgetClass,
			file_dialog,
			XmNx, 15,
			XmNy, 400,
			XmNwidth, 52,
			XmNheight, 30,
			RES_CONVERT( XmNlabelString, "OK" ),
			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomOffset, 10,
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 15,
			XmNrightAttachment, XmATTACH_NONE,
			XmNrightPosition, 30,
			XmNtopAttachment, XmATTACH_NONE,
			XmNtopOffset, 0,
			XmNrightOffset, 0,
			XmNnavigationType, XmTAB_GROUP,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			XmNshowAsDefault, 1,
			NULL );
	XtAddCallback( pushButton8, XmNactivateCallback,
		(XtCallbackProc) activateCB_pushButton8,
		(XtPointer) UxFile_dialogContext );

	UxPutContext( pushButton8, (char *) UxFile_dialogContext );


	/* Creation of pushButton7 */
	pushButton7 = XtVaCreateManagedWidget( "pushButton7",
			xmPushButtonWidgetClass,
			file_dialog,
			XmNx, 479,
			XmNy, 380,
			XmNwidth, 52,
			XmNheight, 30,
			RES_CONVERT( XmNlabelString, "Cancel" ),
			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomOffset, 10,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftOffset, 0,
			XmNleftPosition, 60,
			XmNrightAttachment, XmATTACH_NONE,
			XmNrightOffset, 15,
			XmNtopAttachment, XmATTACH_NONE,
			XmNtopOffset, 10,
			XmNtopWidget, NULL,
			XmNnavigationType, XmTAB_GROUP,
			XmNsensitive, TRUE,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	XtAddCallback( pushButton7, XmNactivateCallback,
		(XtCallbackProc) activateCB_pushButton7,
		(XtPointer) UxFile_dialogContext );

	UxPutContext( pushButton7, (char *) UxFile_dialogContext );


	/* Creation of pushButton12 */
	pushButton12 = XtVaCreateManagedWidget( "pushButton12",
			xmPushButtonWidgetClass,
			file_dialog,
			XmNx, 247,
			XmNy, 383,
			XmNwidth, 52,
			XmNheight, 30,
			RES_CONVERT( XmNlabelString, "Launch" ),
			XmNnavigationType, XmTAB_GROUP,
			XmNsensitive, TRUE,
			XmNtopAttachment, XmATTACH_NONE,
			XmNtopPosition, 0,
			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomOffset, 10,
			XmNbottomPosition, 0,
			XmNleftPosition, 30,
			XmNrightAttachment, XmATTACH_NONE,
			XmNrightPosition, 63,
			XmNresizable, FALSE,
			XmNrightOffset, 0,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftOffset, 0,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	XtAddCallback( pushButton12, XmNactivateCallback,
		(XtCallbackProc) activateCB_pushButton12,
		(XtPointer) UxFile_dialogContext );

	UxPutContext( pushButton12, (char *) UxFile_dialogContext );


	/* Creation of pushButton4 */
	pushButton4 = XtVaCreateManagedWidget( "pushButton4",
			xmPushButtonWidgetClass,
			file_dialog,
			XmNx, 479,
			XmNy, 380,
			XmNwidth, 52,
			XmNheight, 30,
			RES_CONVERT( XmNlabelString, "Help" ),
			XmNnavigationType, XmTAB_GROUP,
			XmNsensitive, TRUE,
			XmNrightAttachment, XmATTACH_FORM,
			XmNrightOffset, 15,
			XmNrightPosition, 0,
			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomOffset, 10,
			XmNbottomPosition, 0,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	XtAddCallback( pushButton4, XmNactivateCallback,
		(XtCallbackProc) activateCB_pushButton4,
		(XtPointer) UxFile_dialogContext );

	UxPutContext( pushButton4, (char *) UxFile_dialogContext );


	/* Creation of separator1 */
	separator1 = XtVaCreateManagedWidget( "separator1",
			xmSeparatorWidgetClass,
			file_dialog,
			XmNx, 15,
			XmNy, 272,
			XmNwidth, 275,
			XmNheight, 10,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomOffset, 5,
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 1,
			XmNrightAttachment, XmATTACH_FORM,
			XmNrightOffset, 1,
			XmNtopAttachment, XmATTACH_NONE,
			XmNtopOffset, 0,
			XmNbottomWidget, pushButton12,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( separator1, (char *) UxFile_dialogContext );


	/* Creation of textField4 */
	textField4 = XtVaCreateManagedWidget( "textField4",
			xmTextFieldWidgetClass,
			file_dialog,
			XmNx, 10,
			XmNy, 309,
			XmNwidth, 528,
			XmNheight, 34,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomOffset, 5,
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 10,
			XmNrightAttachment, XmATTACH_FORM,
			XmNrightOffset, 10,
			XmNtopAttachment, XmATTACH_NONE,
			XmNtopOffset, 0,
			XmNbottomWidget, separator1,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	XtAddCallback( textField4, XmNactivateCallback,
		(XtCallbackProc) activateCB_textField4,
		(XtPointer) UxFile_dialogContext );

	UxPutContext( textField4, (char *) UxFile_dialogContext );


	/* Creation of label7 */
	label7 = XtVaCreateManagedWidget( "label7",
			xmLabelWidgetClass,
			file_dialog,
			XmNx, 13,
			XmNy, 289,
			XmNwidth, 525,
			XmNheight, 20,
			RES_CONVERT( XmNlabelString, "Selection" ),
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomPosition, 0,
			XmNbottomWidget, textField4,
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 10,
			XmNrightAttachment, XmATTACH_FORM,
			XmNrightOffset, 10,
			XmNbottomOffset, 0,
			XmNmarginWidth, 2,
			XmNmarginHeight, 2,
			XmNalignment, XmALIGNMENT_BEGINNING,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( label7, (char *) UxFile_dialogContext );


	/* Creation of scrolledWindow2 */
	scrolledWindow2 = XtVaCreateManagedWidget( "scrolledWindow2",
			xmScrolledWindowWidgetClass,
			file_dialog,
			XmNscrollingPolicy, XmAPPLICATION_DEFINED,
			XmNx, 288,
			XmNy, 40,
			XmNvisualPolicy, XmVARIABLE,
			XmNscrollBarDisplayPolicy, XmSTATIC,
			XmNshadowThickness, 0,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomPosition, 0,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftOffset, 0,
			XmNrightAttachment, XmATTACH_FORM,
			XmNrightOffset, 10,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopOffset, 0,
			XmNleftPosition, 60,
			XmNtopPosition, 0,
			XmNtopWidget, label6,
			XmNbottomOffset, 10,
			XmNbottomWidget, label7,
			XmNwidth, 229,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			XmNleftWidget, NULL,
			NULL );
	UxPutContext( scrolledWindow2, (char *) UxFile_dialogContext );


	/* Creation of filelist */
	filelist = XtVaCreateManagedWidget( "filelist",
			xmListWidgetClass,
			scrolledWindow2,
			XmNwidth, 255,
			XmNheight, 220,
			XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE,
			XmNscrollBarDisplayPolicy, XmSTATIC,
			XmNvisibleItemCount, 9,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	XtAddCallback( filelist, XmNbrowseSelectionCallback,
		(XtCallbackProc) browseSelectionCB_filelist,
		(XtPointer) UxFile_dialogContext );
	XtAddCallback( filelist, XmNdefaultActionCallback,
		(XtCallbackProc) defaultActionCB_filelist,
		(XtPointer) UxFile_dialogContext );

	UxPutContext( filelist, (char *) UxFile_dialogContext );


	/* Creation of scrolledWindow3 */
	scrolledWindow3 = XtVaCreateManagedWidget( "scrolledWindow3",
			xmScrolledWindowWidgetClass,
			file_dialog,
			XmNscrollingPolicy, XmAPPLICATION_DEFINED,
			XmNx, 10,
			XmNy, 40,
			XmNvisualPolicy, XmVARIABLE,
			XmNscrollBarDisplayPolicy, XmSTATIC,
			XmNshadowThickness, 0,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomPosition, 0,
			XmNleftAttachment, XmATTACH_FORM,
			XmNleftOffset, 10,
			XmNrightAttachment, XmATTACH_WIDGET,
			XmNrightPosition, 0,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopOffset, 0,
			XmNrightOffset, 10,
			XmNrightWidget, scrolledWindow2,
			XmNtopWidget, label6,
			XmNbottomOffset, 10,
			XmNbottomWidget, label7,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	UxPutContext( scrolledWindow3, (char *) UxFile_dialogContext );


	/* Creation of dirlist */
	dirlist = XtVaCreateManagedWidget( "dirlist",
			xmListWidgetClass,
			scrolledWindow3,
			XmNwidth, 175,
			XmNheight, 229,
			XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE,
			XmNscrollBarDisplayPolicy, XmSTATIC,
			XmNvisibleItemCount, 9,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			NULL );
	XtAddCallback( dirlist, XmNdefaultActionCallback,
		(XtCallbackProc) defaultActionCB_dirlist,
		(XtPointer) UxFile_dialogContext );

	UxPutContext( dirlist, (char *) UxFile_dialogContext );


	/* Creation of label5 */
	label5 = XtVaCreateManagedWidget( "label5",
			xmLabelWidgetClass,
			file_dialog,
			XmNx, 335,
			XmNy, 15,
			XmNwidth, 100,
			XmNheight, 30,
			RES_CONVERT( XmNlabelString, "Files" ),
			XmNalignment, XmALIGNMENT_BEGINNING,
			XmNtopAttachment, XmATTACH_FORM,
			XmNtopOffset, 10,
			XmNrightAttachment, XmATTACH_NONE,
			XmNrightOffset, 10,
			XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNleftPosition, 0,
			XmNmarginHeight, 2,
			XmNmarginBottom, 0,
			XmNmarginWidth, 2,
			RES_CONVERT( XmNbackground, "#a4a455550000" ),
			XmNleftWidget, scrolledWindow2,
			NULL );
	UxPutContext( label5, (char *) UxFile_dialogContext );

	XtVaSetValues(file_dialog,
			XmNdefaultButton, pushButton8,
			XmNcancelButton, pushButton7,
			XmNinitialFocus, pushButton8,
			NULL );


	XtAddCallback( file_dialog, XmNdestroyCallback,
		(XtCallbackProc) UxDestroyContextCB,
		(XtPointer) UxFile_dialogContext);


	return ( file_dialog );
}

/*******************************************************************************
       The following is the 'Interface function' which is the
       external entry point for creating this interface.
       This function should be called from your application or from
       a callback function.
*******************************************************************************/

Widget	create_file_dialog()
{
	Widget                  rtrn;
	_UxCfile_dialog         *UxContext;
	static int		_Uxinit = 0;

	UxFile_dialogContext = UxContext =
		(_UxCfile_dialog *) UxNewContext( sizeof(_UxCfile_dialog), False );


	if ( ! _Uxinit )
	{
		_UxIfClassId = UxNewInterfaceClassId();
		_Uxinit = 1;
	}

	rtrn = _Uxbuild_file_dialog();

	return(rtrn);
}

/*******************************************************************************
       END OF FILE
*******************************************************************************/

