
/*******************************************************************************
	topLevelShell1.c

       Associated Header file: topLevelShell1.h
*******************************************************************************/

#include <stdio.h>

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/MwmUtil.h>
#include <Xm/MenuShell.h>
#endif /* MOTIF */

#include "UxXt.h"
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <X11/Shell.h>

/*******************************************************************************
       Includes, Defines, and Global variables from the Declarations Editor:
*******************************************************************************/

#include <sys/ioctl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <fcntl.h>
#include <signal.h>
#include <termio.h>
#include <unistd.h>

#ifdef VT
#include <Xm/Separator.h>
#include <Xm/Label.h>
#include <Vt.h>
Widget    vt1 = NULL;
#endif

#define COMMAND               ( "/bin/ksh" )
#define  ENVFLAG     ( "-e" )
#define  PRGFLAG     ( "-x" )
#define  NOUID       ( -1 )
#define  NOGID       ( -1 )

FILE *incmd = NULL;
int pid = 0;
char ttyline[BUFSIZ];

extern swidget help_msg;
swidget create_help_msg();
extern swidget softkeyform;
swidget create_softkeyform();
void popup_help_msg();
void popup_softkeyform();
void addutmp();
void delutmp();
void getuser();


extern int global_argc;
extern char **global_argv;


static	int _UxIfClassId;
/*******************************************************************************
       The following header file defines the context structure.
*******************************************************************************/

#ifndef XKLOADDS
#define XKLOADDS
#endif /* XKLOADDS */

#define CONTEXT_MACRO_ACCESS 1
#include "topLevelShell1.h"
#undef CONTEXT_MACRO_ACCESS


/*******************************************************************************
Auxiliary code from the Declarations Editor:
*******************************************************************************/

#ifdef VT

static void	monitorCB_vt1( UxWidget, UxClientData, UxCallbackArg )
	Widget		UxWidget;
	XtPointer	UxClientData, UxCallbackArg;
{
    delutmp ();
    exit( 0 );
}

static void	messageCB_vt1( UxWidget, UxClientData, UxCallbackArg )
	Widget		UxWidget;
	XtPointer	UxClientData, UxCallbackArg;
{
    XmVtCallbackStruct *info = ( XmVtCallbackStruct * )UxCallbackArg;
    XtVaSetValues( topLevelShell1, XmNtitle, info->data_buffer, NULL );
    XtVaSetValues( topLevelShell1, XmNiconName, info->data_buffer, NULL );
}

static void	activateCB_my_menu2_p1_b1( UxWidget, UxClientData, UxCallbackArg )
	Widget		UxWidget;
	XtPointer	UxClientData, UxCallbackArg;
{
    char cls[BUFSIZ];
    sprintf( cls, "%c[H%c[2J", 27, 27 );
    XmVtWrite( vt1, cls, 7 );
}

XtEventHandler BtermMenuPost( wgt, client_data, event, ctd )
	Widget		wgt;
	XtPointer	client_data;
	XEvent		*event;
	Boolean		*ctd;
{
	Widget	menu = (Widget) client_data;
	int 	which_button;

	XtVaGetValues( menu, XmNwhichButton, &which_button, NULL );

	if ( event->xbutton.button == which_button )
	{
		XmMenuPosition( menu, event );
		XtManageChild( menu );
	}
}

void data_input (input_str)
char *input_str;
{
    if (input_str[0] == '?') input_str[0] = 27;
    XmVtSend( vt1, input_str);
}
#endif

/*******************************************************************************
       The following are callback functions.
*******************************************************************************/

static void  activateCB_menu1_p2_b1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
	    popup_help_msg();
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p1_b1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
	    int rcode = 0;
	    rcode = kill( ( -1*pid ), 9 );
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p8_b1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    Time timestamp1;
	
	    timestamp1 = XtLastTimestampProcessed(XtDisplay(vt1));
	     XmVtCopy (vt1, timestamp1);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p8_b2(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    XmVtPaste (vt1);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p5_b1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	XtVaSetValues( vt1, RES_CONVERT( XmNfont, "-misc-fixed-medium-*-*-*-*-50-100-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNwideFont, "-misc-fixed-medium-*-*-*-*-50-210-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNdoubleFont, "-misc-fixed-medium-*-*-*-*-50-280-200-*-*-iso8859-1" ), NULL );
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p5_b2(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	XtVaSetValues( vt1, RES_CONVERT( XmNfont, "-misc-fixed-medium-*-*-*-*-75-100-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNwideFont, "-misc-fixed-medium-*-*-*-*-75-200-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNdoubleFont, "-misc-fixed-medium-*-*-*-*-75-240-200-*-*-iso8859-1" ), NULL );
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p5_b3(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	XtVaSetValues( vt1, RES_CONVERT( XmNfont, "-misc-fixed-medium-*-*-*-*-100-100-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNwideFont, "-misc-fixed-medium-*-*-*-*-100-200-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNdoubleFont, "-misc-fixed-medium-*-*-*-*-100-210-200-*-*-iso8859-1" ), NULL );
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p5_b4(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	XtVaSetValues( vt1, RES_CONVERT( XmNfont, "-misc-fixed-medium-*-*-*-*-150-100-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNwideFont, "-misc-fixed-medium-*-*-*-*-150-200-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNdoubleFont, "-misc-fixed-medium-*-*-*-*-150-200-200-*-*-iso8859-1" ), NULL );
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p5_b5(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	XtVaSetValues( vt1, RES_CONVERT( XmNfont, "-misc-fixed-medium-*-*-*-*-200-100-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNwideFont, "-misc-fixed-medium-*-*-*-*-200-200-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNdoubleFont, "-misc-fixed-medium-*-*-*-*-200-200-200-*-*-iso8859-1" ), NULL );
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p5_b6(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	XtVaSetValues( vt1, RES_CONVERT( XmNfont, "-misc-fixed-medium-*-*-*-*-230-100-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNwideFont, "-misc-fixed-medium-*-*-*-*-230-200-100-*-*-iso8859-1" ), NULL );
	XtVaSetValues( vt1, RES_CONVERT( XmNdoubleFont, "-misc-fixed-medium-*-*-*-*-230-200-200-*-*-iso8859-1" ), NULL );
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p6_b1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	XtVaSetValues( vt1, RES_CONVERT( XmNbackground, "Black" ), NULL );
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p6_b2(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	XtVaSetValues( vt1, RES_CONVERT( XmNforeground, "Green" ), NULL );
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p7_b1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	XtVaSetValues( vt1, XmNdelonBSMode, True, NULL );
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p7_b2(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	XtVaSetValues( vt1, XmNdelonBSMode, False, NULL );
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p3_b4(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
	    popup_softkeyform();
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

/*******************************************************************************
       The 'build_' function creates all the widgets
       using the resource values specified in the Property Editor.
*******************************************************************************/

static Widget	_Uxbuild_topLevelShell1()
{
	Widget		menu1_p2_shell;
	Widget		menu1_p1_shell;
	Widget		menu1_p8_shell;
	Widget		menu1_p3_shell;
	Widget		menu1_p5_shell;
	Widget		menu1_p6_shell;
	Widget		menu1_p7_shell;


	/* Creation of topLevelShell1 */
	topLevelShell1 = XtVaCreatePopupShell( "topLevelShell1",
			topLevelShellWidgetClass,
			UxTopLevel,
			XmNx, 0,
			XmNy, 0,
			XmNiconName, "bterm",
			XmNtitle, "bterm",
			XmNallowShellResize, TRUE,
			NULL );
	UxPutContext( topLevelShell1, (char *) UxTopLevelShell1Context );
	UxPutClassCode( topLevelShell1, _UxIfClassId );


	/* Creation of form1 */
	form1 = XtVaCreateManagedWidget( "form1",
			xmFormWidgetClass,
			topLevelShell1,
			XmNresizePolicy, XmRESIZE_ANY,
			XmNunitType, XmPIXELS,
			XmNx, 40,
			XmNy, 30,
			XmNborderWidth, 0,
			RES_CONVERT( XmNaccelerators, "<Key>Return: ManagerGadgetKeyInput()" ),
			NULL );
	UxPutContext( form1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1 */
	menu1 = XtVaCreateManagedWidget( "menu1",
			xmRowColumnWidgetClass,
			form1,
			XmNrowColumnType, XmMENU_BAR,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNtopAttachment, XmATTACH_FORM,
			XmNmenuAccelerator, "<KeyUp>F10",
			NULL );
	UxPutContext( menu1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p2 */
	menu1_p2_shell = XtVaCreatePopupShell ("menu1_p2_shell",
			xmMenuShellWidgetClass, menu1,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p2 = XtVaCreateWidget( "menu1_p2",
			xmRowColumnWidgetClass,
			menu1_p2_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p2_b1 */
	menu1_p2_b1 = XtVaCreateManagedWidget( "menu1_p2_b1",
			xmPushButtonWidgetClass,
			menu1_p2,
			RES_CONVERT( XmNlabelString, "About" ),
			RES_CONVERT( XmNmnemonic, "A" ),
			NULL );
	XtAddCallback( menu1_p2_b1, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p2_b1,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p2_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_top_b2 */
	menu1_top_b2 = XtVaCreateManagedWidget( "menu1_top_b2",
			xmCascadeButtonWidgetClass,
			menu1,
			RES_CONVERT( XmNlabelString, "Help" ),
			RES_CONVERT( XmNmnemonic, "H" ),
			XmNsubMenuId, menu1_p2,
			NULL );
	UxPutContext( menu1_top_b2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p1 */
	menu1_p1_shell = XtVaCreatePopupShell ("menu1_p1_shell",
			xmMenuShellWidgetClass, menu1,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p1 = XtVaCreateWidget( "menu1_p1",
			xmRowColumnWidgetClass,
			menu1_p1_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p1_b1 */
	menu1_p1_b1 = XtVaCreateManagedWidget( "menu1_p1_b1",
			xmPushButtonWidgetClass,
			menu1_p1,
			RES_CONVERT( XmNlabelString, "Exit" ),
			RES_CONVERT( XmNmnemonic, "E" ),
			NULL );
	XtAddCallback( menu1_p1_b1, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p1_b1,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p1_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_top_b1 */
	menu1_top_b1 = XtVaCreateManagedWidget( "menu1_top_b1",
			xmCascadeButtonWidgetClass,
			menu1,
			RES_CONVERT( XmNlabelString, "File" ),
			RES_CONVERT( XmNmnemonic, "F" ),
			XmNsubMenuId, menu1_p1,
			NULL );
	UxPutContext( menu1_top_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p8 */
	menu1_p8_shell = XtVaCreatePopupShell ("menu1_p8_shell",
			xmMenuShellWidgetClass, menu1,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p8 = XtVaCreateWidget( "menu1_p8",
			xmRowColumnWidgetClass,
			menu1_p8_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p8, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p8_b1 */
	menu1_p8_b1 = XtVaCreateManagedWidget( "menu1_p8_b1",
			xmPushButtonWidgetClass,
			menu1_p8,
			RES_CONVERT( XmNlabelString, "Copy" ),
			RES_CONVERT( XmNmnemonic, "C" ),
			NULL );
	XtAddCallback( menu1_p8_b1, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p8_b1,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p8_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p8_b2 */
	menu1_p8_b2 = XtVaCreateManagedWidget( "menu1_p8_b2",
			xmPushButtonWidgetClass,
			menu1_p8,
			RES_CONVERT( XmNlabelString, "Paste" ),
			RES_CONVERT( XmNmnemonic, "P" ),
			NULL );
	XtAddCallback( menu1_p8_b2, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p8_b2,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p8_b2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_top_b4 */
	menu1_top_b4 = XtVaCreateManagedWidget( "menu1_top_b4",
			xmCascadeButtonWidgetClass,
			menu1,
			RES_CONVERT( XmNlabelString, "Edit" ),
			RES_CONVERT( XmNmnemonic, "E" ),
			XmNsubMenuId, menu1_p8,
			NULL );
	UxPutContext( menu1_top_b4, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p3 */
	menu1_p3_shell = XtVaCreatePopupShell ("menu1_p3_shell",
			xmMenuShellWidgetClass, menu1,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p3 = XtVaCreateWidget( "menu1_p3",
			xmRowColumnWidgetClass,
			menu1_p3_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p3, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p5 */
	menu1_p5_shell = XtVaCreatePopupShell ("menu1_p5_shell",
			xmMenuShellWidgetClass, menu1_p3,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p5 = XtVaCreateWidget( "menu1_p5",
			xmRowColumnWidgetClass,
			menu1_p5_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p5, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p5_b1 */
	menu1_p5_b1 = XtVaCreateManagedWidget( "menu1_p5_b1",
			xmPushButtonWidgetClass,
			menu1_p5,
			RES_CONVERT( XmNlabelString, "Tiny" ),
			RES_CONVERT( XmNmnemonic, "T" ),
			NULL );
	XtAddCallback( menu1_p5_b1, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p5_b1,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p5_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p5_b2 */
	menu1_p5_b2 = XtVaCreateManagedWidget( "menu1_p5_b2",
			xmPushButtonWidgetClass,
			menu1_p5,
			RES_CONVERT( XmNlabelString, "Small" ),
			RES_CONVERT( XmNmnemonic, "S" ),
			NULL );
	XtAddCallback( menu1_p5_b2, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p5_b2,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p5_b2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p5_b3 */
	menu1_p5_b3 = XtVaCreateManagedWidget( "menu1_p5_b3",
			xmPushButtonWidgetClass,
			menu1_p5,
			RES_CONVERT( XmNlabelString, "Medium" ),
			RES_CONVERT( XmNmnemonic, "M" ),
			NULL );
	XtAddCallback( menu1_p5_b3, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p5_b3,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p5_b3, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p5_b4 */
	menu1_p5_b4 = XtVaCreateManagedWidget( "menu1_p5_b4",
			xmPushButtonWidgetClass,
			menu1_p5,
			RES_CONVERT( XmNlabelString, "Large" ),
			RES_CONVERT( XmNmnemonic, "L" ),
			NULL );
	XtAddCallback( menu1_p5_b4, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p5_b4,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p5_b4, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p5_b5 */
	menu1_p5_b5 = XtVaCreateManagedWidget( "menu1_p5_b5",
			xmPushButtonWidgetClass,
			menu1_p5,
			RES_CONVERT( XmNlabelString, "Extra Large" ),
			RES_CONVERT( XmNmnemonic, "E" ),
			NULL );
	XtAddCallback( menu1_p5_b5, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p5_b5,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p5_b5, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p5_b6 */
	menu1_p5_b6 = XtVaCreateManagedWidget( "menu1_p5_b6",
			xmPushButtonWidgetClass,
			menu1_p5,
			RES_CONVERT( XmNlabelString, "Very Large" ),
			RES_CONVERT( XmNmnemonic, "V" ),
			NULL );
	XtAddCallback( menu1_p5_b6, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p5_b6,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p5_b6, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p3_b5 */
	menu1_p3_b5 = XtVaCreateManagedWidget( "menu1_p3_b5",
			xmCascadeButtonWidgetClass,
			menu1_p3,
			RES_CONVERT( XmNlabelString, "Fonts" ),
			XmNsubMenuId, menu1_p5,
			RES_CONVERT( XmNmnemonic, "F" ),
			NULL );
	UxPutContext( menu1_p3_b5, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p6 */
	menu1_p6_shell = XtVaCreatePopupShell ("menu1_p6_shell",
			xmMenuShellWidgetClass, menu1_p3,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p6 = XtVaCreateWidget( "menu1_p6",
			xmRowColumnWidgetClass,
			menu1_p6_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p6, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p6_b1 */
	menu1_p6_b1 = XtVaCreateManagedWidget( "menu1_p6_b1",
			xmPushButtonWidgetClass,
			menu1_p6,
			RES_CONVERT( XmNlabelString, "Background Black" ),
			RES_CONVERT( XmNmnemonic, "B" ),
			NULL );
	XtAddCallback( menu1_p6_b1, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p6_b1,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p6_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p6_b2 */
	menu1_p6_b2 = XtVaCreateManagedWidget( "menu1_p6_b2",
			xmPushButtonWidgetClass,
			menu1_p6,
			RES_CONVERT( XmNlabelString, "Foreground Green" ),
			RES_CONVERT( XmNmnemonic, "F" ),
			NULL );
	XtAddCallback( menu1_p6_b2, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p6_b2,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p6_b2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p3_b6 */
	menu1_p3_b6 = XtVaCreateManagedWidget( "menu1_p3_b6",
			xmCascadeButtonWidgetClass,
			menu1_p3,
			RES_CONVERT( XmNlabelString, "Colors" ),
			RES_CONVERT( XmNmnemonic, "C" ),
			XmNsubMenuId, menu1_p6,
			NULL );
	UxPutContext( menu1_p3_b6, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p7 */
	menu1_p7_shell = XtVaCreatePopupShell ("menu1_p7_shell",
			xmMenuShellWidgetClass, menu1_p3,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p7 = XtVaCreateWidget( "menu1_p7",
			xmRowColumnWidgetClass,
			menu1_p7_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p7, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p7_b1 */
	menu1_p7_b1 = XtVaCreateManagedWidget( "menu1_p7_b1",
			xmPushButtonWidgetClass,
			menu1_p7,
			RES_CONVERT( XmNlabelString, "Delete on Backspace Key" ),
			RES_CONVERT( XmNmnemonic, "D" ),
			NULL );
	XtAddCallback( menu1_p7_b1, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p7_b1,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p7_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p7_b2 */
	menu1_p7_b2 = XtVaCreateManagedWidget( "menu1_p7_b2",
			xmPushButtonWidgetClass,
			menu1_p7,
			RES_CONVERT( XmNlabelString, "Backspace on Backspace Key" ),
			RES_CONVERT( XmNmnemonic, "B" ),
			NULL );
	XtAddCallback( menu1_p7_b2, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p7_b2,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p7_b2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p3_b3 */
	menu1_p3_b3 = XtVaCreateManagedWidget( "menu1_p3_b3",
			xmCascadeButtonWidgetClass,
			menu1_p3,
			RES_CONVERT( XmNlabelString, "Key Mapping" ),
			RES_CONVERT( XmNmnemonic, "K" ),
			XmNsubMenuId, menu1_p7,
			NULL );
	UxPutContext( menu1_p3_b3, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p3_b4 */
	menu1_p3_b4 = XtVaCreateManagedWidget( "menu1_p3_b4",
			xmPushButtonWidgetClass,
			menu1_p3,
			RES_CONVERT( XmNlabelString, "Softkeys" ),
			RES_CONVERT( XmNmnemonic, "S" ),
			NULL );
	XtAddCallback( menu1_p3_b4, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p3_b4,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p3_b4, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_top_b3 */
	menu1_top_b3 = XtVaCreateManagedWidget( "menu1_top_b3",
			xmCascadeButtonWidgetClass,
			menu1,
			RES_CONVERT( XmNlabelString, "Options" ),
			RES_CONVERT( XmNmnemonic, "O" ),
			XmNsubMenuId, menu1_p3,
			NULL );
	UxPutContext( menu1_top_b3, (char *) UxTopLevelShell1Context );

	XtVaSetValues(menu1,
			XmNmenuHelpWidget, menu1_top_b2,
			NULL );


	XtAddCallback( topLevelShell1, XmNdestroyCallback,
		(XtCallbackProc) UxDestroyContextCB,
		(XtPointer) UxTopLevelShell1Context);


	return ( topLevelShell1 );
}

/*******************************************************************************
       The following is the 'Interface function' which is the
       external entry point for creating this interface.
       This function should be called from your application or from
       a callback function.
*******************************************************************************/

Widget	create_topLevelShell1()
{
	Widget                  rtrn;
	_UxCtopLevelShell1      *UxContext;
	static int		_Uxinit = 0;

	UxTopLevelShell1Context = UxContext =
		(_UxCtopLevelShell1 *) UxNewContext( sizeof(_UxCtopLevelShell1), False );


	if ( ! _Uxinit )
	{
		_UxIfClassId = UxNewInterfaceClassId();
		_Uxinit = 1;
	}

	rtrn = _Uxbuild_topLevelShell1();

	{
#ifdef VT
	    char environ[BUFSIZ];
	    char prog[BUFSIZ];
	    char path[BUFSIZ];
	    char *args[100];
	    char *env = NULL;
	    int  argcnt = 0;
	    int  ttyfd = 0;
	    int  ptyfd = 0;
	    int  ruid = 0;
	    int  rgid = 0;
	    short  menuheight = 0;
	    char username[BUFSIZ];
	    static char execute[BUFSIZ];
	    static char command[BUFSIZ];
	    static char shortname[BUFSIZ];
	    char element[BUFSIZ];
	    int pos = 0;
	    int inx = 0;
	    int jnx = 0;
	
	
	    env = getenv ("SHELL");
	    if (env != NULL)
	        strcpy( path, env);
	    else
	        strcpy( path, COMMAND );
	    strcpy( shortname, "-");
	    for (inx = 0;inx < strlen(path);inx++)
	        if (path[inx] == '/') pos = inx;
	    strcat (shortname, path+1+pos);
	    args[0] = shortname;
	    args[1] = NULL;
	
	    execute[0] = 0;
	    for (jnx = 1; jnx < global_argc; jnx++)
	    {
	        if (strcmp (global_argv[jnx], "-e") == 0)
	        {
	            for (inx = jnx+1; inx < global_argc; inx++)
	            {
	                 sprintf (element, "\"%s\" ", global_argv[inx]);
	                 strcat (execute, element);
	            }
	        }
	    }
	    if (strlen(execute) >= 1)
	    {
	        execute[strlen(execute)-1] = 0;
	        args[0] = "ksh";
	        args[1] = "-c";
	        args[2] = execute;
	        args[3] = NULL;
	    }
	
	    XtVaGetValues(  menu1, XmNheight, &menuheight, NULL);
	    vt1 = XtVaCreateManagedWidget( "vt1",
			    xmVtWidgetClass, form1,
	                    XmNresponsive, True,
			    XmNbottomOffset, 2,
			    XmNbottomAttachment, XmATTACH_FORM,
			    XmNtopOffset, 2,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, UxGetWidget( menu1 ),
			    XmNrightOffset, 2,
			    XmNrightAttachment, XmATTACH_FORM,
			    XmNleftOffset, 2,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNheight, 460,
			    XmNwidth, 740,
			    XmNy, 30,
			    XmNx, 40,
			    XmNapplication, "bterm",
			    NULL );
	
	    XtInstallAccelerators (form1,vt1);
	
	    XtAddCallback( vt1, XmNmonitorCallback,
			    monitorCB_vt1,
			    (XtPointer) NULL );
	
	    XtAddCallback( vt1, XmNmessageCallback,
			    messageCB_vt1,
			    (XtPointer) NULL );
	
	
	    ruid = getuid();
	    rgid = getgid();
	    getuser (username);
	    
	    incmd = procopen( path, args, ruid, rgid, &pid, &ttyfd, &ptyfd  );
	    strcpy (ttyline, ttyname(ttyfd)+5);
	    addutmp (username, ttyline, pid);
	
	    XmVtMonitor( vt1, ptyfd, pid );
#endif
	    create_help_msg( topLevelShell1);
	    create_softkeyform (topLevelShell1);
	    return(rtrn);
	}
}

/*******************************************************************************
       END OF FILE
*******************************************************************************/

