.TH XmToolbar-1.0 1
.SH NAME
\fBXmToolbar\fR \-The Toolbar widget class
.SH SYNOPSIS
.B #include <Toolbar.h>
.SH DESCRIPTION
Toolbar is a manager widget that manages its children in either rows
or columns ans shows one tooltip label while mouse cursor is inside
its children.

Following are some important considerations in using Toolbar:

.IP o 4
There is no effect when using \fBXtSetValues\fR to change the 
\fBXmNx\fR and \fBXmNy\fR resources of a child, because the Toolbar
itself decides the \fBXmNx\fR and \fBXmNy\fR resources of a child.

.SH Classes
Tab inherits behavoir and resources from  \fBCore\fR, \fBComposite\fR,
\fBConstraint\fR and \fBXmManager\fR classes.

The class pointer is \fBxmToolbarWidgetClass\fR.

The class name is \fBXmToolbar\fR.

.SH New Resources
The following table defines s set of widget resources used by
the programmer to specify data. The programmer can also set the
resource values for the inherited classes to set attributes for this
widget.

.TS
c s s s
lfCW l.
\fBXmToolbar Resource Set\fR
\fBName\fR	\fBClass\fR	\fBType\fR	\fBDefault\fR
XmNorientation	XmROrientation	unsigned char	XmHORIZONTAL
XmNspacing	XmRSpacing	Dimension	0
XmNgroupSpacing	XmRGroupSpacing	Dimension	5
XmNmarginWidth	XmRMarginWidth	Dimension	0
XmNmarginHeight	XmRMarginHeight	Dimension	0
XmNentryCount	XmREntryCount	int	XmENTRY_UNSPECIFIED
XmNtipFontList	XmRTipFontList	XmFontList	NULL
XmNtipForeground	XmRTipForeground	Pixel	dynamic
XmNtipBackground	XmRTipBackground	Pixel	dynamic
XmNtipBorderWidth	XmRTipBorderWidth	Dimension	1
XmNtipPosition	XmRTipPosition	unsigned char	XmNOTIFY_BOTTOM_RIGHT
XmNtipDistance	XmRTipDistance	Dimension	10
XmNtipNotifyDelay	XmRTipNotifyDelay	int	1000
.TE

.SS XmNorientation
The direction for laying out the children. Default is \fIXmHORIZONTAL\fR.
Other possible value is \fIXmVERTICAL\fR.

.SS XmNspacing
The space between two children. Default value \fI0\fR.

.SS XmNgroupSpacing
The spacing between two children when 2nd child is the first child of
a new group. When a child has its \fBXmNnewGourp\fR value \fITRUE\fR,
Toolbar uses this value for spacing. Default value \fI5\fR.

.SS XmNmarginWidth
.SS XmNmarginHeight
The spacing between an edge of Toolbar widget and its nearest child.
Default value is \fI0\fR.

.SS XmNentryCount
The maximum number of children should be layed out in one direction.
While \fBXmNorientation\fR is \fIXmHORIZONTAL\fR, this direction is
horizontal and for \fIXmVERTICAL\fR, it's vertical.

.SS XmNtipFontList
The fontlist for tooltip label.

.SS XmNtipForeground
.SS XmNtipBackground
The foreground and background color of tooltip label.

.SS XmNtipBorderWidth
The border width of tooltip label. default value is \fI1\fR.

.SS XmNtipPosition
The relative position where tooltip should be posted with
respect to the notified child. The possible values are:
.IP o 2
\fBXmTIP_BOTTOM_RIGHT\fR - Position the tooltip ate the right and 
bottom of notified child. This is the default.
.IP o 2
\fBXmTIP_BOTTOM_LEFT\fR - Position the tooltip at the left and 
bottom of notified child.
.IP o 2
\fBXmTIP_TOP_RIGHT\fR - Position the tooltip at the right and 
top of notified child.
.IP o 2
\fBXmTIP_TOP_LEFT\fR - Position the tooltip at the left and 
top of notified child.

.SS XmNtipDistance
The distance between the tooltip label and the nearest edge
of notified child. default value is \fI10\fR.

.SS XmNtipNotifyDelay
The delay of the posting the tooltip after mouse cursor entering
in a child widget. The value is in milli-seconds and default value
is \fI1000\fR.

\fBtab_child\fR is the current child of the XmTab selected and 
\fBtab_label\fR is corresponding tab label.

.SH Constraint Resources
Toolbar defines the following constraint resources for its children:

.TS
c s s s
lfCW l.
\fBXmToolbar Constraint Resource Set\fR
\fBName\fR	\fBClass\fR	\fBType\fR	\fBDefault\fR
XmNnotifyable	XmRNotifyable	Boolean	TRUE
XmNtipLabel	XmRTipLabel	XmString	NULL
XmNnewGroup	XmRNewGroup	Boolean	FALSE
XmNconfigurable	XmRConfigurable	Boolean	FALSE
.TE

.SS XmNnotifyable
The boolean value to mention whether or not this child will be
notified by posting the tooltip.

.SS XmNtipLabel
The label for tooltip when this child will be notified.
Point to note that, if \fBXmNnotifyable\fR is \fITRUE\fR and 
\fBXmNtipLabel\fR is \fINULL\fR (default value), the child won't
be notified.

.SS XmNnewGroup
If \fITRUE\fR, this child is treated as the first entry of next group.
Therefore, \fBXmNgroup\fR is used instead of normal spacing (\fBXmNspacing\fR).
Default is \fIFALSE\fR.

.SS XmNconfigurable
If \fITRUE\fR, Toolbar widget decides the size of the child. This is
defaut value. Otherwise, the child holds its preferred size.

.SH RELATED INFORMATION
.B Core, Composite, Constraint, XmManager.

Author: Pralay Dakua (pkanti@hotmail.com)
