.TH XmTab-1.1 1
.SH NAME
\fBXmTab\fR \-The Tab widget class
.SH SYNOPSIS
.B #include <Tab.h>
.SH DESCRIPTION
Tab is a container widget which shows the tabs at the top of it and
shows the Tab widgets (it's children) accoring to the Tab.

Following are some important considerations in using Tab:

.IP o 4
There is no effect when using \fBXtSetValues\fR to change the 
\fBXmNx\fR and \fBXmNy\fR resources of a child, because the Tab
itself decides the \fBXmNx\fR and \fBXmNy\fR resources of a child.

.IP o 4
The children of Tab get managed/unmanaged automatically while tabs 
get selected/unselected. The user shouldn't manage/unmanage
its children explicitly.

.IP o 4
TabWidget always shows only the managed children. Unmanaging a child
causes removal corresponding tab at the top. 

.IP o 4
If \fBXmNresizeChildren\fR is \fITRUE\fR (default), XmTab resizes all it's
children to same size. In such a case, the children behaves like
the children of XmForm all XmNleftAttachment, XmNrightAttachment,
XmNtopAttachment, XmNbottomAttachment set to XmATTACH_FORM.

.SH Classes
Tab inherits behavoir and resources from  \fBCore\fR, \fBComposite\fR,
\fBConstraint\fR and \fBXmManager\fR classes.

The class pointer is \fBxmTabWidgetClass\fR.

The class name is \fBXmTab\fR.

.SH New Resources
The following table defines s set of widget resources used by
the programmer to specify data. The programmer can also set the
resource values for the inherited classes to set attributes for this
widget.

.TS
c s s s
lfCW l.
\fBXmTab Resource Set\fR
\fBName\fR	\fBClass\fR	\fBType\fR	\fBDefault\fR
XmNmarginWidth	XmRMarginWidth	Dimension	3
XmNmarginHeight	XmRMarginHeight	Dimension	3
XmNresizeChildren	XmRResizeChildren	Boolean	TRUE
XmNtabFontList	XmRTabFontList	XmFontList	NULL
XmNvalueChangedCallback	XmRCallback	XtPointer	NULL
.TE

.SS XmNmarginWidth
Specify the margin width at the left and right of the window.

.SS XmNmarginHeight
Specify the margin height at the top and bottom of the window.

.SS XmNresizeChildren
Specify whether resizing of the children should be done. \fITRUE\fR
makes all children same size.

.SS XmNtabFontList
Specify the font list of the tab label.

.SS XmNvalueChangedCallback
This callback is called after selecting a tab. It passes a pointer of 
an instance of XmTabCallbackStruct where

typedef struct {
                int reason;
                XEvent *event;
                Widget tab_child;
                XmString tab_label;
  }XmTabCallbackStruct;

\fBtab_child\fR is the current child of the XmTab selected and 
\fBtab_label\fR is corresponding tab label.

.SH Constraint Resources
Tab defines the following constraint resources for its children:

.TS
c s s s
lfCW l.
\fBXmTab Constraint Resource Set\fR
\fBName\fR	\fBClass\fR	\fBType\fR	\fBDefault\fR
XmNtabLabel	XmRTabLabel	XmString	NULL
.TE

.SS XmNtabLabel
The string to be shown as tab-label. If \fBXmNtabLabel\fR is
\fINULL\fR (default), Tab shows the \fBname\fR of the child as tab label.

.SH RELATED INFORMATION
.B Core, Composite, Constraint, XmManager.

Author: Pralay Dakua (pkanti@hotmail.com)
