/*
 * xhello3.c -- A (modified) "My First Program", now with user defined
 * push button face.
 */

#include <Xm/Xm.h>
#include <pushbuttons.h>
#include <msgbox.h>

#include "QuitPB.xpm"  /* The pixmaps to be displayed */
#include "QuitPBa.xpm"

void ExitCB(Widget w, XtPointer pClientData, XtPointer pCallData)
{
    if ( XmMessageBox(w, "Quit...", 
                      "Do you really want to quit?", 
		      MB_YESNO | MB_DEFAULT2, NULL) == XmPUSHBUTTON_YES )
	exit(0);
} /* ExitCB */

int main(Cardinal argc, char **argv)
{
    static char  *Fallback[] = {
        "*.background: Gray75", 
        "*.fontList: -*-helvetica-bold-r-normal-*-*-120-*-*-*-*-iso8859-1", 
        NULL};
    XtAppContext AppCtx;
    Widget       TopLevel, Button;

    TopLevel = XtVaAppInitialize(&AppCtx, "XHello", NULL, 0, 
                                 &argc, argv, Fallback, NULL);
    Button = XmCreatePixmapPushButton(TopLevel, "ok", 
                                        QuitPB_xpm, QuitPBa_xpm, NULL,
                                        NULL, 0);
    XtAddCallback(Button, XmNactivateCallback, 
                  (XtCallbackProc) ExitCB, NULL);
    XtManageChild(Button);
    XtRealizeWidget(TopLevel);
    XtAppMainLoop(AppCtx);
    return 0;   
} /* main */
    
/* End of xhello3.c */
