/*
 * demo.c -- Simply & Silly Demo Program using the "ButtonFace Library"
 * (c) 1994 Harald Albrecht,  albrecht@igpm.rwth-aachen.de
 */
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/RowColumn.h>
#include <pushbuttons.h>
#include <msgbox.h>
#include <resource.h>

#include <stdio.h>

void CB(Widget w, XtPointer pClientData, XtPointer pCallData)
{
    char *Text, *Caption;

    Caption = XmLoadStringResource(w, "title1", NULL, "Important Help...");
    Text = XmLoadStringResource(w, "question1", NULL, 
                                "Please stand by while I'm trying\n"
                                "to find the answer to the question\n"
			        "of life, the universe and everything.");
    
    if ( XmMessageBox(w, Caption, Text, 
			   MB_STANDBYICON | MB_OKCANCEL | MB_HELP, 
			   NULL) == XmPUSHBUTTON_OK ) {
	Caption = XmLoadStringResource(w, "title3", NULL, "The answer!");
	Text = XmLoadStringResource(w, "answer1", NULL, 
	                            "The answer is 42!");
	XmMessageBox(w, Caption, Text, MB_INFOICON | MB_OK, NULL);
    } 
}


void ExitCB(Widget w, XtPointer pClientData, XtPointer pCallData)
{
    char *Text, *Caption;

    Caption = XmLoadStringResource(w, "title2", NULL, "Exit...");
    Text = XmLoadStringResource(w, "question2", NULL, 
                                "Do you really want to quit\n"
			        "this fabulous demo program?");
    if ( XmMessageBox(w, Caption, Text, 
			 MB_QUESTIONICON | MB_OKCANCEL | MB_DEFAULT2, 
			 NULL) == XmPUSHBUTTON_OK )
	exit(0);
}


int main(Cardinal argc, char **argv)
{
    static char *Fallback[] = {"*.background: Gray75", 
                               "*.fontList: -*-helvetica-bold-r-normal-*-*-120-*-*-*-*-iso8859-1", 
			       NULL};
    XtAppContext AppCtx;
    Widget       TopLevel, Main, RowCol, RC1, RC2, Child;

    TopLevel = XtVaAppInitialize(&AppCtx, "Demo", NULL, 0, 
                                 &argc, argv, Fallback, NULL);
    Main = XmCreateMainWindow(TopLevel, "main", NULL, 0);
    XtManageChild(Main);
    
    RC1 = XtVaCreateManagedWidget(
	"RowCol", xmRowColumnWidgetClass, Main, 
        NULL);
    XtVaSetValues(RC1, XmNisHomogeneous, False, 
                       XmNorientation, XmVERTICAL, 
		       NULL);

    RowCol = XtVaCreateManagedWidget(
	"RowCol", xmRowColumnWidgetClass, RC1, 
	XmNorientation, XmHORIZONTAL, 
        NULL);

    Child = XmCreateStandardPushButton(RowCol, "ok", XmPUSHBUTTON_OK, NULL, 0);
    XtManageChild(Child);
    XtAddCallback(Child, XmNactivateCallback, (XtCallbackProc) ExitCB, NULL);
    Child = XmCreateStandardPushButton(RowCol, "cancel", XmPUSHBUTTON_CANCEL, NULL, 0);   
    XtManageChild(Child);
    Child = XmCreateStandardPushButton(RowCol, "abort", XmPUSHBUTTON_ABORT, NULL, 0);   
    XtManageChild(Child);
    Child = XmCreateStandardPushButton(RowCol, "retry", XmPUSHBUTTON_RETRY, NULL, 0);   
    XtManageChild(Child);
    Child = XmCreateStandardPushButton(RowCol, "ignore", XmPUSHBUTTON_IGNORE, NULL, 0);   
    XtManageChild(Child);
    Child = XmCreateStandardPushButton(RowCol, "yes", XmPUSHBUTTON_YES, NULL, 0);   
    XtManageChild(Child);
    Child = XmCreateStandardPushButton(RowCol, "no", XmPUSHBUTTON_NO, NULL, 0);   
    XtManageChild(Child);
    Child = XmCreateStandardPushButton(RowCol, "help", XmPUSHBUTTON_HELP, NULL, 0);   
    XtManageChild(Child);
    XtAddCallback(Child, XmNactivateCallback, (XtCallbackProc) CB, NULL);
    
    RC2 = XtVaCreateManagedWidget(
	"RowCol", xmRowColumnWidgetClass, RC1, 
	XmNorientation, XmHORIZONTAL, 
         NULL);
    Child = XmCreateStandardLabel(RC2, "info", XmLABELFACE_INFO, NULL, 0);
    XtManageChild(Child);
    Child = XmCreateStandardLabel(RC2, "excl", XmLABELFACE_EXCLAMATION, NULL, 0);
    XtManageChild(Child);
    Child = XmCreateStandardLabel(RC2, "quest", XmLABELFACE_QUESTION, NULL, 0);
    XtManageChild(Child);
    Child = XmCreateStandardLabel(RC2, "hand", XmLABELFACE_HAND, NULL, 0);
    XtManageChild(Child);
    Child = XmCreateStandardLabel(RC2, "time", XmLABELFACE_TIME, NULL, 0);
    XtManageChild(Child);

    XmMainWindowSetAreas(Main, NULL, NULL, NULL, NULL, RC1);
    XtRealizeWidget(TopLevel);
    XtAppMainLoop(AppCtx);
    return 0;   
} /* main */
