'\" t
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfScrolledWindow3
.SH DESCRIPTION
The ScrolledWindow3 widget is a composite widget that contains 4
Boards and two scroll bars. The first Board is a small area in the top
left corner, where a label widget can be put. A Board along the top
and one along the left side are used for column and row titles
(usually Label widgets). The two scroll bars are along the right side
and the bottom. In the middle is the largest board, in which the main
data will be displayed.

A widget is added as the child of the large Board is called the
`controlled widget' (CW), The widget that is put in the top Board is
called the `column controlled widget' (CCW), the widget that is put in
the left Board is the `row controlled widget' (RCW).

Usually, the controlled widgets are larger than the Boards, and their
origins will have negative x and y coordinates. They are moved about
inside the Boards by the ScrolledWindow3, in reaction to the user
clicking on the scrollbars. The CCW moves left/right, the RCW moves
up/down, the CW moves in all directions. The controlled widgets are
therefore clipped by the Boards.

The first child widget attached to ScrolledWindow3 becomes the child
of the top left Board. The second child widget becomes the CCW, the
third the RCW, and the fourth the CW.

The CCW is typically a Label widget with a tablist to provide column
headers, and only scrolls horizontally. The CW is typically a
single column MultiList widget with a tablist, and scrolls boths
horizontally and vertically.

The ScrolledWindow3 provides a callback, but most application will not
need it, since the ScrolledWindow3 already moves the CW. The callback
is invoked AFTER the CW is moved.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfScrolledWindow3
Name	Class	Type	Default
XtNspacing	XtCSpacing	Dimension 	4 
XtNscrollbarWidth	XtCScrollbarWidth	Dimension 	22 
XtNcolHdrHeight	XtCColHdrHeight	Dimension 	22 
XtNrowHdrWidth	XtCRowHdrWidth	Dimension 	22 
XtNshadowWidth	XtCShadowWidth	Dimension 	2 
XtNhideHScrollbar	XtCHideHScrollbar	Boolean 	False 
XtNhideVScrollbar	XtCHideVScrollbar	Boolean 	False 
XtNvScrollAmount	XtCVScrollAmount	int 	20 
XtNhScrollAmount	XtCHScrollAmount	int 	copy_vScrollAmount 
XtNinitialX	XtCInitialX	Position 	0 
XtNinitialY	XtCInitialY	Position 	0 
XtNscrollCallback	XtCScrollCallback	Callback	NULL 
XtNscrollResponse	XtCScrollResponse	XtCallbackProc 	scroll_response 

.TE
.ps +2

.TP
.I "XtNspacing"
By default, the Board widget, Frame widget and the Scrollbars are
placed 4 pixels from each other and from the edges of the ScrolledWindow3
itself.

	

.TP
.I "XtNscrollbarWidth"
The width of the scrollbars can be set with the \fIscrollbarWidth\fP
resource. The default is 22 pixels.

	

.TP
.I "XtNcolHdrHeight"
The height of the Board widget to contain the CCW can be set with
the \fIcolHdrHeight\fP resource. The default is 22 pixels. The width of
the Board to contain the RCW is \fIrowHdrWidth\fP, by default also 22
pixels.

	

.TP
.I "XtNrowHdrWidth"

.TP
.I "XtNshadowWidth"
The scrollbars and the frame have the same shadow frame. (The board
has no border or frame.) The width of both is set with a single
resource: \fIshadowWidth\fP. The style of the shadow cannot be changed. It
will always be \fIXfwfSunken\fP.

	

.TP
.I "XtNhideHScrollbar"
It is possible to switch off the display of the scrollbars, with the
following two resources: \fIhideHScrollbar\fP is by default \fIFalse\fP.

	

.TP
.I "XtNhideVScrollbar"
\fIhideVScrollbar\fP is also by default \fIFalse\fP.

	

.TP
.I "XtNvScrollAmount"
When the arrows of the scrollbars are clicked, the controlled widgets
will be moved a fixed number of pixels in the indicated direction. The
distance can be set separately for horizontal and vertical movement.
E.g., if the controlled widget displays text, it is a good idea to set
the vertical scroll distance to the height of one line of text.

	

.TP
.I "XtNhScrollAmount"
The horizontal amount is by default copied from the vertical amount.

	

.TP
.I "XtNinitialX"
The initial position of the CCW and CW can be set with the resources
\fIinitialX\fP and \fIinitialY\fP. Both are given in pixels and must be zero
or negative.

	

.TP
.I "XtNinitialY"
\fIinitialY\fP is for the vertical position.

	

.TP
.I "XtNscrollCallback"
The callback is passed a pointer to an \fIXfwfScrollInfo\fP structure,
which is defined as \fIstruct { XfwfSReason reason; XfwfSFlags flags;
float vpos, vsize, hpos, hsize; }\fP The \fIreason\fP can be:

* \fIXfwfSUp\fP: if the user clicked (or holds) the up arrow.

* \fIXfwfSLeft\fP: ditto left arrow.

* \fIXfwfSDown\fP: ditto down arrow.

* \fIXfwfSRight\fP: ditto right arrow.

* \fIXfwfSPageUp\fP: ditto area above thumb.

* \fIXfwfSPageDown\fP: ditto area below thumb.

* \fIXfwfSPageLeft\fP: ditto area left of thumb.

* \fIXfwfSPageRight\fP: ditto area right of thumb.

* \fIXfwfSDrag\fP: if the user drags one of the thumbs.

* \fIXfwfSMove\fP: if the user stops dragging the thumb.

* \fIXfwfSTop\fP: if the user requests to scroll all the way up.

* \fIXfwfSBottom\fP: same all the way down.

* \fIXfwfSLeftSide\fP: same to the left side.

* \fIXfwfSRightSide\fP: same to the right side.

Note that when the callback is called, the controlled window has
already been moved.

	

.TP
.I "XtNscrollResponse"
To set the scrolled window to a particular position, the
scrollResponse function must be used. The function has the type of a
callback function and it must be retrieved with a call to
\fIXtGetValues\fP.

	

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNusePrivateColormap	XtCUsePrivateColormap	Boolean 	FALSE 
XtNuseStandardColormaps	XtCUseStandardColormaps	Boolean 	TRUE 
XtNstandardColormap	XtCStandardColormap	Atom 	0 
XtNuserData	XtCUserData	Pointer	NULL 
XtNxcc	XtCXCc	XCC 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Exports"

To set the position of a scrolling widget from an application, one
could use \fIXtGetValues\fP to get the \fIscrollResponse\fP resource and then
call the returned function. The \fIXfwfScrollTo\fP function is a utility
function that makes this more convenient. Its arguments are a widget,
and \fIx\fP and \fIy\fP values (both must be between 0.0 and 1.0). It will
scroll the widget and all other connected scrolling widgets to the
indicated offset.

Note that this function is not tied to the ScrolledWindow3 widget: it
works with every widget that implements the FWF SWIP (Scrolling Widget
Interface Policy).

.nf
XfwfScrollTo( $, double  x, double  y)
.fi

