'\" t
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfPrompt
.SH DESCRIPTION
The Prompt widget is used for short (no more than a few lines) text
entry. It can be used in two modes: either with or without a template.
If there is a template, input will be checked against it and only
accepted if it matches. A template must be accompanied by a pattern,
that gives the acceptable character classes for each position in the
template. A template can include literal characters, e.g., \fI"Enter
date: __-__-__ (DD-MM-YY)"\fP with pattern \fI"99-99-99"\fP means that the
user may enter only digits on the `\fI_\fP' positions.

If the pattern and template do not provide enough validation, or if
there is no template, there is also the possibility of using a
callback after each character is entered. The callback can accept or
reject the new text.

The \fIrvStart\fP resource is used as cursor position.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfPrompt
Name	Class	Type	Default
XtNtext	XtCText	String 	NULL 
XtNtemplate	XtCTemplate	String 	NULL 
XtNpattern	XtCPattern	String 	NULL 
XtNvalidate	XtCValidate	Callback	NULL 
XtNleave	XtCLeave	Callback	NULL 
XtNactivate	XtCActivate	Callback	NULL 
XtNcomplete	XtCComplete	Boolean 	True 
XtNplaceholder	XtCPlaceholder	char 	'_'

.TE
.ps +2

.TP
.I "XtNtext"
The \fItext\fP resource is what is modified by the user. If there is a
template defined, the text will be the portion of the template from
the first `\fI_\fP' to the last.

	

.TP
.I "XtNtemplate"
The \fItemplate\fP consists of text with at least one `\fI_\fP' (or, to be
precise, the value of \fIplaceholder\fP). If there is no template, input
of any length is accepted (but see the \fIvalidate\fP callback below).

Note that the \fIlabel\fP resource that is inherited from \fIXfwfLabel\fP is
used to hold the combination of \fItemplate\fP and \fItext\fP. Setting \fIlabel\fP
has no effect, and, indeed, will cause a warning message to be
printed.

	

.TP
.I "XtNpattern"
The \fIpattern\fP is only used if there is a \fItemplate\fP. The length of
the \fIpattern\fP must be the length from the first `\fI_\fP' in \fItemplate\fP to
the last. Where the \fItemplate\fP has a `\fI_\fP', the \fIpattern\fP must have
one of:

* `9' only digits are allowed.

* `a' digits, upper- and lowercase letters and spaces.

* `A' digits, uppercase letters and spaces.

* `F' only `safe' file name characters.

* 'f' file name character plus `*' `[', `]' and `?'

* `X' any character.

* `z' digits, upper- and lowercase letters (no spaces)

* `Z' digits, uppercase letters (no spaces).

If the pattern is empty or too short, it will be extended with X's.

	

.TP
.I "XtNvalidate"
The \fIvalidate\fP callbacks are called when the text changes, because a
letter is added or removed. The callback get a pointer to an
\fIXfwfPromptInfo\fP structure as \fIcall_data\fP. The structure includes a
field \fIreply\fP, which should be set to \fIXfwfReject\fP, \fIXfwfAccept\fP or
\fIXfwfComplete\fP. The first causes the new text to be rejected with a
`beep'; the second sets the \fIcomplete\fP resource to \fIFalse\fP, to
indicate that the text is valid, but not yet complete; the third sets
the \fIcomplete\fP resource to \fITrue\fP.

	

.TP
.I "XtNleave"
The \fIleave\fP callback is called when the focus leaves the prompt
widget. This is usually a sign that the user is ready entering the
text. The final text is passed in the \fIcall_data\fP argument.

	

.TP
.I "XtNactivate"
The \fIactivate\fP callback is invoked from the \fIactivate\fP action, which
is normally bound to the Return key. The \fIcall_data\fP argument of the
callbacks routines is filled with a pointer to the event that
triggered the action. This callback can be used in a dialog box, for
example, to activate the default button.

	

.TP
.I "XtNcomplete"
The resource \fIcomplete\fP is always \fITrue\fP, unless the most recent
call to the \fIvalidate\fP callback returned \fIXfwfAccept\fP.

	

.TP
.I "XtNplaceholder"
The character thatis used as the placeholder can be changed from the
default `\fI_\fP' by setting the \fIplaceholder\fP resource. Note that this
character will also be used in the \fItext\fP string to indicate open
places.

	

.TP
.I "XtNcursor"
The cursor is by default a vertical bar, called the `xterm' cursor.

	

.TP
.I "XtNtraversalOn"
Since prompts, in contrast to labels, should receive keyboard
events, the \fItraversalOn\fP resource is by default \fITrue\fP.

	

.TP
.I "XtNframeWidth"
The default frame width is also given a different value.

	

.TP
.I "XtNframeType"
As is the frame type

	

.TP
.I "XtNalignment"
The default alignment of text is changed to center-left.

	

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfLabel
Name	Class	Type	Default
XtNlabel	XtCLabel	String 	NULL 
XtNtablist	XtCTablist	String 	NULL 
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNforeground	XtCForeground	Pixel 	XtDefaultForeground 
XtNhlForeground	XtCHlForeground	Pixel 	XtDefaultForeground 
XtNalignment	XtCAlignment	Alignment 	0 
XtNtopMargin	XtCTopMargin	Dimension 	2 
XtNbottomMargin	XtCBottomMargin	Dimension 	2 
XtNleftMargin	XtCLeftMargin	Dimension 	2 
XtNrightMargin	XtCRightMargin	Dimension 	2 
XtNshrinkToFit	XtCShrinkToFit	Boolean 	False 
XtNrvStart	XtCRvStart	Int 	0 
XtNrvLength	XtCRvLength	Int 	0 
XtNhlStart	XtCHlStart	Int 	0 
XtNhlLength	XtCHlLength	Int 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNusePrivateColormap	XtCUsePrivateColormap	Boolean 	FALSE 
XtNuseStandardColormaps	XtCUseStandardColormaps	Boolean 	TRUE 
XtNstandardColormap	XtCStandardColormap	Atom 	0 
XtNuserData	XtCUserData	Pointer	NULL 
XtNxcc	XtCXCc	XCC 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Exports"

The \fIXfwfPromptInfo\fP is what is passed to the \fIvalidate\fP callback
after the text has changed. It contains pointers to the old and the
new text and a boolean field \fIresult\fP that is initially set to
\fIXfwfComplete\fP, but that may be changed by the callback routine, when
the new text is unacceptable, or acceptable but not complete.

	

.nf

.B type
 XfwfPromptInfoResult = enum {
                XfwfReject, XfwfAccept, XfwfComplete
        }
.fi

.nf

.B type
 XfwfPromptInfo = struct {
                String oldstring;
                String newstring;
                Boolean result;
        }
.fi

.SS "Translations"

The traversal code is added, except for \fI<Key>Left: traverseLeft()\fP
and \fI<Key>Right: traverseRight()\fP, which are used for other purposes.

.nf
<FocusIn>: focusIn() 
.fi

.nf
<FocusOut>: leave() focusOut() 
.fi

removed: trans	<Visible>:		visibility()

removed: trans	<Unmap>:		unmap()

.nf
<Key>Up: traverseUp() 
.fi

.nf
<Key>Down: traverseDown() 
.fi

.nf
<Key>Next: traverseNext() 
.fi

.nf
~Shift<Key>Tab: traverseNext() 
.fi

.nf
<Key>Prior: traversePrev() 
.fi

.nf
Shift<Key>Tab: traversePrev() 
.fi

.nf
<Key>KP_Enter: traverseNextTop() 
.fi

.nf
<Key>Home: traverseHome() 
.fi

.nf
Shift<Btn1Down>: extend_select() 
.fi

.nf
<Btn1Down>: traverseCurrent() start_select() 
.fi

.nf
<Btn1Motion>: extend_select() 
.fi

.nf
<Btn1Up>: end_select() 
.fi

.nf
<Btn2Down>,<Btn2Up>: paste() 
.fi

.nf
<Key>BackSpace: cut() backspace() 
.fi

.nf
Ctrl<Key>d: cut() delete() 
.fi

.nf
<Key>Right: unselect() right() 
.fi

.nf
<Key>Left: unselect() left() 
.fi

.nf
Ctrl<Key>a: unselect() bol() 
.fi

.nf
Ctrl<Key>e: unselect() eol() 
.fi

.nf
<Key>Return: activate() 
.fi

.nf
<Key>: cut() self_insert() 
.fi

.SS "Actions"

.TP
.I "activate

The \fIactivate\fP action just calls the \fIactivate\fP callback functions,
passing the \fIXEvent\fP pointer in the \fIcall_data\fP argument.

.TP
.I "leave

The \fIleave\fP action calls the \fIleave\fP callbacks with the current
\fItext\fP as \fIcall_data\fP.

.TP
.I "start_select

The \fIstart_select\fP action sets the cursor position as close as
possible to the mouse position, but only if the mouse actually points
at some text. It also removes any previous selection, preparing for a
new one.

.TP
.I "extend_select

The \fIextend_select\fP action extends the selection to the current
cursor position.

.TP
.I "end_select

The \fIend_select\fP action copies the selected text to the clipboard.

.TP
.I "paste

The \fIpaste\fP action requests the contents of the clipboard in
string-format and tries to insert it into the text.

.TP
.I "unselect

The \fIunselect\fP action restores the text that was shown in reverse to
normal.

.TP
.I "cut

The \fIcut\fP action deletes the highlighted portion from the text.

.TP
.I "self_insert

The \fIself_insert\fP function inserts the key that was pressed into the
text. If the key is not a printable key, it does nothing. If the key
doesn't match the pattern, it does nothing. If the callback \fIvalidate\fP
returns \fIXfwfReject\fP, it does nothing.

.TP
.I "bol

The \fIbol\fP action moves the cursor to the leftmost placeholder.

.TP
.I "eol

The \fIeol\fP action moves the cursor to the end of the label, if it
isn't there already.

.TP
.I "left

The \fIleft\fP action moves the cursor one position to the left, unless
there are no more placeholders in that direction.

.TP
.I "right

The \fIright\fP action moves the cursor one position to the right,
unless it is already at the end of the template.

.TP
.I "delete

The \fIdelete\fP action removes the character to the right of the
cursor, if there is any. The rest of the characters in the same run
will shift to the left.

.TP
.I "backspace

The \fIbackspace\fP action removes the character to the left of the
cursor, if there is any. The cursor moves left and all characters in
the same run move left.

