/*
** tetris.c for Mtds in .
** 
** Made by MaxTheDogSays (dubray_f@epita.fr && rancur_v@epita.fr
** Login   <mtds@epita.fr>
** 
** Started on  Tue May  3 23:29:35 1994 mtds
** Last update Mon Nov 21 12:45:10 1994 hydrix
*/

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <std/Xstd.h>
#include <Xmtds/Tetris.h>
#include <Xmtds/ElecDisp.h>
#include "xtetris.h"

static void		test_callback()
{
   printf("test\n");
}

static void		score_callback();
static void		start_callback();
static void		handicap_callback();

static XtResource	appl_resources[] =
{
{"two",		"Two",		XtRBoolean,	sizeof(Boolean),
    XtOffset(appl_ptr,two),		XtRString,	"False"}
};

static XrmOptionDescRec	options[] =
{
{"-two",	"*two",		XrmoptionNoArg,		"True"}
};

static label_callback_t	options_commands[] =
{
{"test",		test_callback},
{"test",		test_callback},
{NULL,			NULL}
};

static label_callback_t	about_commands[] =
{
{"test",		test_callback},
{"test",		test_callback},
{NULL,			NULL}
};

static label_lc_t	menu_commands[] =
{
{"options",		options_commands},
{"about...",		about_commands}
};

int			main(argc,argv)
int			argc;
char			**argv;
{
   appl			app;
   Widget		form;
   Widget		paned;
   Widget		menubar_box;
   Widget		tmp_mbw;
   Widget		tmp_smw;
   Widget		tmp_w;
   label_lc_t		*mc;
   int			n_mc;
   int			i;
   label_callback_t	*lc;
 
   
   app.toplevel = XtVaAppInitialize(&(app.app_context),
				    "XTetris",
				    options,
				    XtNumber(options),
				    &argc,
				    argv,
				    NULL,
				    NULL);
   XtGetApplicationResources(app.toplevel,
                             &app,
                             appl_resources,
                             XtNumber(appl_resources),
                             NULL,
                             0);
   paned =
      XtVaCreateWidget("paned",
                       panedWidgetClass,
                       app.toplevel,
                       NULL);
   menubar_box =
      XtVaCreateWidget("menubar_box",
                       boxWidgetClass,
                       paned,
                       XtNorientation,	(XtPointer)XtorientHorizontal,
                       NULL);
   mc = menu_commands;
   n_mc = XtNumber(menu_commands);
   i = 0;
   while (i < n_mc)
   {
      tmp_mbw =
         XtVaCreateManagedWidget(mc[i].label,
                                 menuButtonWidgetClass,
                                 menubar_box,
                                 NULL);
      tmp_smw =
         XtVaCreatePopupShell("menu",
                              simpleMenuWidgetClass,
                              tmp_mbw,
                              NULL);
      lc = mc[i].lc;
      while (lc->label)
      {
         tmp_w =
            XtVaCreateManagedWidget(lc->label,
                                    smeBSBObjectClass,
                                    tmp_smw,
                                    NULL);
	 XtAddCallback(tmp_w,
                       XtNcallback,
                       lc->callback,
                       &app);
         lc++;
      }
      i++;
   }
   XtManageChild(menubar_box);
   app.info = XtVaCreateManagedWidget("info",
				      xmtdsElecDispWidgetClass,
				      paned,
				      XtNinterval,		0,
				      XtNpixHeight,		1,
				      XtNpixWidth,		1,
				      XtNrasterWidth,		135,
				      XtNrasterHeight,		18,
				      XtNprogram,		"speed(500)message(10,2,XTETRIS\\(C\\)1994\\ mtds)speed(10)scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()scroll-up()speed(500)message(2,2,*Press\\ start\\ to\\ begin*)clear()message(2,2,*Press\\ start\\ to\\ begin*)clear()message(2,2,*Press\\ start\\ to\\ begin*)clear()",
				      NULL);
   form = XtVaCreateWidget("form",
			   formWidgetClass,
			   paned,
			   NULL);
   app.tetris = XtVaCreateManagedWidget("tetris",
					xmtdsTetrisWidgetClass,
					form,
					NULL);
   app.next_shape = XtVaCreateManagedWidget("next_shape",
					    xmtdsTetrisWidgetClass,
					    form,
					    XtNgameWidth,	4,
					    XtNgameHeight,	4,
					    XtNblockWidth,	20,
					    XtNblockHeight,	20,
					    XtNfromHoriz,	app.tetris,
					    NULL);
   app.start = XtVaCreateManagedWidget("Start!",
				       commandWidgetClass,
				       form,
				       XtNfromVert,		app.next_shape,
				       XtNfromHoriz,		app.tetris,
				       NULL);
   app.handicap = XtVaCreateManagedWidget("Handicap!",
					  commandWidgetClass,
					  form,
					  XtNfromVert,	app.start,
					  XtNfromHoriz,	app.tetris,
					  NULL);
   XtAddCallback(app.handicap,
		 XtNcallback,
		 handicap_callback,
		 (XtPointer)&app);
   XtManageChild(form);
   XtManageChild(paned);
   XtAddCallback(app.tetris,
		 XtNscoreCallback,
		 score_callback,
		 (XtPointer)&app);
   XtAddCallback(app.start,
		 XtNcallback,
		 start_callback,
		 (XtPointer)&app);
   app.end = TRUE;
   XtRealizeWidget(app.toplevel);
   XtAppMainLoop(app.app_context);
}

static void			score_callback(w,app,cbs)
Widget				w;
appl				*app;
xmtdsscoreCallbackStruct	*cbs;
{
   char				buf[BUFSIZ];
   char				*args[3];
   static Boolean		display_score = FALSE;
   
   switch (cbs->reason)
   {
   case SCORE_NORMAL:
      XmtdsTetrisClear(app->next_shape);
      XmtdsTetrisDrawShape(app->next_shape,0,0,cbs->detail);
      app->score += TETRIS_NORMAL_SCORE;
      if (display_score)
      {
	 args[0] = "0";
	 args[1] = "0";
	 sprintf(buf,"%d",app->score);
	 args[2] = buf;
	 XmtdsEDMessageFunc(app->info,args,3);
      }
      else
      {
	 display_score = TRUE;
	 XmtdsEDClearFunc(app->info,NULL,0);
      }
      break ;
   case SCORE_LINE:
      display_score = FALSE;
      if (cbs->detail == 4)
      {
	 app->score += TETRIS_FOUR_LINES_BONUS;
	 args[0] = "0";
	 args[1] = "0";
	 args[2] = "*You made TETRIS!*";
	 XmtdsEDSprayFunc(app->info,args,3); 
      }
      else
      {
	 app->score += TETRIS_LINE_BONUS*cbs->detail;
	 args[0] = "0";
	 args[1] = "0";
	 args[2] = "*You made a line!*";
	 XmtdsEDMessageFunc(app->info,args,3); 
      }
      break ;
   case SCORE_END:
      args[0] = "0";
      args[1] = "0";
      args[2] = "LOST!!! press start!";
      XmtdsEDMessageFunc(app->info,args,3); 
      app->end = TRUE;
      break ;
   default:
      XtWarning("scoreCallback error");
   }
   if ((app->score % 1000) == 0)
   {
      int	interval;
      
      XtVaGetValues(app->tetris,
		    XtNinterval,	&interval,
		    NULL);
      if (interval > 10)
	 interval -= 10;
      XtVaSetValues(app->tetris,
		    XtNinterval,	interval,
		    NULL);
   }
}

static void		start_callback(w,app,cbs)
Widget			w;
appl			*app;
XtPointer		cbs;
{
   if (app->end)
   {
      XmtdsEDStopFunc(app->info,NULL,0);
      XmtdsEDClearFunc(app->info,NULL,0);
      app->score = 0;
      XtVaSetValues(app->tetris,
		    XtNinterval,	200,
		    NULL);
      XmtdsTetrisClear(app->tetris);
      XmtdsTetrisStart(app->tetris);
      app->end = FALSE;
   }
}

static void		handicap_callback(w,app,cbs)
Widget			w;
appl			*app;
XtPointer		cbs;
{
   int			width;
   int			height;
   int			i;
   
   XtVaGetValues(app->tetris,
		 XtNgameWidth,	&width,
		 XtNgameHeight,	&height,
		 NULL);
   i = 0;
   while (i < 10)
   {
      XmtdsTetrisSet(app->tetris,RAND(width),2*(height/3)+RAND(height/3));
      i++;
   }
}
