/*
** text_panel.c
**	This file simply exists to save maintenance problems. It is just
**	included into demo programs that require easy access to text
**	resources.
*/

static UI_ElementDef text_list[] =
    {
	UI_PANE(panel_name, " "),
	UI_TOGGLE(toggle_name, "wrap lines",		True, NULL),
	UI_LOAD(XtNformat),
	UI_TOGGLE(toggle_name, "proportional spacing", True, NULL),
	UI_LOAD(XtNproportional),
	UI_INPUT(input_name, "line spacing:", UI_AcceptPanel),
	UI_LOAD(XtNlineSpacing),
	UI_INPUT(input_name, "indentation:", UI_AcceptPanel),
	UI_LOAD(XtNindentation),
	UI_INPUT(input_name, "first line offset:", UI_AcceptPanel),
	UI_LOAD(XtNfirstLineOffset),
	UI_INPUT(input_name, "itemization:", UI_AcceptPanel),
	UI_LOAD(XtNitemization),
	UI_INPUT(input_name, "line layout table:", UI_AcceptPanel),
	UI_LOAD(XtNlineLayoutTable),
	UI_INPUT(input_name, "columns:", UI_AcceptPanel),
	UI_LOAD(XtNcolumns),
	UI_INPUT(input_name, "column width:", UI_AcceptPanel),
	UI_LOAD(XtNcolumnWidth),
	UI_INPUT(input_name, "column height:", UI_AcceptPanel),
	UI_LOAD(XtNcolumnHeight),
	UI_INPUT(input_name, "column separation:", UI_AcceptPanel),
	UI_LOAD(XtNcolumnSeparation),
	UI_INPUT(input_name, "page separation:", UI_AcceptPanel),
	UI_LOAD(XtNpageSeparation),
	UI_PANE(panel_name, "Default Alignment:"),
	UI_TOGGLE(toggle_name, "start (ragged right)",XeAlignment_START, NULL),
	UI_RADIO(toggle_name, "end (ragged left)",XeAlignment_END, NULL),
	UI_RADIO(toggle_name, "centered",	XeAlignment_CENTER, NULL),
	UI_RADIO(toggle_name, "justified",	XeAlignment_JUSTIFIED, NULL),
	UI_LOAD(XtNalignment),

	UI_LABEL(label_name, "Framed rendition:"),
	UI_INPUT(input_name, "left: ", UI_AcceptPanel),
	UI_LOAD(XtNframeLeftRendition),
	UI_INPUT(input_name, "right: ", UI_AcceptPanel),
	UI_LOAD(XtNframeRightRendition),
	UI_INPUT(input_name, "top: ", UI_AcceptPanel),
	UI_LOAD(XtNframeTopRendition),
	UI_INPUT(input_name, "bottom: ", UI_AcceptPanel),
	UI_LOAD(XtNframeBottomRendition),

	UI_TOGGLE(toggle_name, "invert shadow",	True, NULL),
	UI_LOAD(XtNframeInvertShadow),
	UI_INPUT(input_name, "Foreground: ", UI_AcceptPanel),
	UI_LOAD(XtNforeground),
	UI_INPUT(input_name, "Background: ", UI_AcceptPanel),
	UI_LOAD(XtNbackground),


	UI_PANE(panel_name, "Export format:"),
	UI_TOGGLE(toggle_name, "string",	XeTextExport_STRING, NULL),
	UI_RADIO(toggle_name, "string (F)",	XeTextExport_STRING_F, NULL),
	UI_RADIO(toggle_name, "character odif",	XeTextExport_ODIF, NULL),
	UI_RADIO(toggle_name, "character odif (F)",XeTextExport_ODIF_F, NULL),
	UI_RADIO(toggle_name, "character odif (FP)",XeTextExport_ODIF_FP,NULL),
	UI_LOAD(XtNexportFormat),
	UI_END(),
    };

extern UI_PanelDef text_resources;

static UI_ActionDef text_actions[] =
    {
	{"set",	UI_AcceptPanel,	(XtPointer)&text_resources},
	{"close"},
	{"print", PrintToDisplay, (XtPointer)&text_resources.shell},
	{NULL,},
    };


UI_PanelDef text_resources =
    {
	"Paragraph settings",
	text_list,
	text_actions,
    };
