/*
** frame_panel.c
**	This file simply exists to save maintenance problems. It is just
**	included into demo programs that require easy access to XeFrame
**	resources.
*/

UI_ElementDef frame_list[] =
    {
	UI_PANE(panel_name, "Frame Position"),
	UI_INPUT(input_name, "positioning:", UI_AcceptPanel),
	UI_LOAD(XtNframePosition),
	UI_INPUT(input_name, "alignemnt:", UI_AcceptPanel),
	UI_LOAD(XtNframeAlignment),

	UI_LABEL(label_name, "Frame Dimension"),
	UI_INPUT(input_name, "Horizontal: ", UI_AcceptPanel),
	UI_LOAD(XtNhorizontal),
	UI_INPUT(input_name, "Vertical: ", UI_AcceptPanel),
	UI_LOAD(XtNvertical),

	UI_PANE(panel_name, "Frame Offsets"),
	UI_INPUT(input_name, "left:", UI_AcceptPanel),
	UI_LOAD(XtNleftOffset),
	UI_INPUT(input_name, "right:", UI_AcceptPanel),
	UI_LOAD(XtNrightOffset),
	UI_INPUT(input_name, "trailing:", UI_AcceptPanel),
	UI_LOAD(XtNtrailingOffset),
	UI_INPUT(input_name, "leading:", UI_AcceptPanel),
	UI_LOAD(XtNleadingOffset),

	UI_LABEL(label_name, "Frame separation"),
	UI_INPUT(input_name, "trailing:", UI_AcceptPanel),
	UI_LOAD(XtNtrailingSeparation),
	UI_INPUT(input_name, "leading:", UI_AcceptPanel),
	UI_LOAD(XtNleadingSeparation),
	UI_INPUT(input_name, "center:", UI_AcceptPanel),
	UI_LOAD(XtNcenterSeparation),

	UI_PANE(panel_name, "Frame borders"),
	UI_INPUT(input_name, "left: ", UI_AcceptPanel),
	UI_LOAD(XtNleftBorder),
	UI_INPUT(input_name, "right: ", UI_AcceptPanel),
	UI_LOAD(XtNrightBorder),
	UI_INPUT(input_name, "trailing: ", UI_AcceptPanel),
	UI_LOAD(XtNtrailingBorder),
	UI_INPUT(input_name, "leading: ", UI_AcceptPanel),
	UI_LOAD(XtNleadingBorder),
	UI_END(),
    };

extern UI_PanelDef frame_resources;

static UI_ActionDef frame_actions[] =
    {
	{"set", UI_AcceptPanel, (XtPointer)&frame_resources},
	{"close"},
	{"print", PrintToDisplay, (XtPointer)&frame_resources.shell},
	{NULL},	    
    };


UI_PanelDef frame_resources = 
    {
	"resources",
	frame_list,
	frame_actions,
    };

