/*
** Very Simple EuroBridge Widget Demonstration Program
**
** WARNING!
**	This is very a simple program. It just opens the widget into
**	a window and this may result a window much larger than the
**	screen. With some window managers this may be difficult
**	situation to handle... --msa
*/

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xew/Basic.h>
#include <X11/Xew/Frame.h>
#include <X11/Xew/Raster.h>
#include <X11/Xew/TextEd.h>
#include <X11/Xew/Audio.h>
#include <X11/Xew/Video.h>
#include <X11/Xew/Support.h>
#include "ui_tools.h"
#include "printing.h"

static Widget main_window;

static char command_name[] = "commandButton";
static char panel_name[] = "menuPanel";
static char toggle_name[] = "toggleBox";
static char input_name[] = "inputBox";
static char label_name[] = "labelBox";

#include "frame_panel.c"

/*
** Notify_MENU
**	Popup a menu panel associated with the widget
*/
static void Notify_MENU(w, data)
Widget w;
XtPointer data;
    {
	frame_resources.target = w;
	UI_SetToggles(&frame_resources);
	UI_PopupPanel(w, (XtPointer)&frame_resources, data);
    }

static void Notify(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeNotifyCallbackData *notify = (XeNotifyCallbackData *)call_data;
	int i;

	switch (notify->reason)
	    {
	    case XeCR_NOTIFY:
		for (i = 0; i < notify->num_params; i++)
		    {
			if (strcmp("MENU", notify->params[i]) == 0)
				Notify_MENU(w, client_data);
			else
				printf("%s%s", i==0?"":",", notify->params[i]);
		    }
		break;
	    default:
		printf("UNKNOWN: XeRC=%d\n", notify->reason);
		break;
	    }
    }

/*
** CtStringDone
**	A common return function for all String converters.
**
**	The string parameter 's' must really be a pointer to static
**	storage!!!
*/
static Boolean CvtStringDone(s, to)
char *s;
XrmValue *to;
    {
	int n = strlen(s) + 1;

	if (to->addr != NULL)
	    {
		if (to->size < n)
		    {
			to->size = n;
			return False;
		    }
		memcpy((char *)to->addr, s, n);
	    }
	else
		to->addr = s;
	to->size = n;
	return True;
    }


static void WarningHandler(message)
String message;
    {
	static UI_PanelDef warning = {"Warning"};

	warning.heading = message;
	UI_PopupPanel(main_window, (XtPointer)&warning, (XtPointer)NULL);
    }

#include "fallback.c"


main(argc, argv)
int argc; char *argv[];
    {
	XtAppContext demo_application;
	Widget root_widget,  frame[10], widget;
	int frame_level;
	Arg args[10];
	int n, i;
	char *imagefile, buf[100];
	XeContentFormat imagetype;

	root_widget = XtAppInitialize(&demo_application, "XewFrame",
				      NULL,0, &argc, argv,
				      fallback_resources,
				      NULL, 0);
	if (argc < 2)
	    {
		printf("usage: frame files(s)\n");
		exit(0);
	    }
	UI_Initialize(demo_application);
	main_window = frame[0] = root_widget;
	XtAppSetWarningHandler(demo_application, WarningHandler);
	frame_level = 0;
	for (i = 0; ++i < argc;)
	    {
		imagefile = argv[i];
		if (*imagefile == '-')
		    {
			int path;

			if (strcmp(imagefile+1, "view") == 0)
				path = -1;
			else if (strcmp(imagefile+1, "d0") == 0)
				path = 0;
			else if (strcmp(imagefile+1, "d90") == 0)
				path = 90;
			else if (strcmp(imagefile+1, "d180") == 0)
				path = 180;
			else if (strcmp(imagefile+1, "d270") == 0)
				path = 270;
			else if (strcmp(imagefile+1, "end") == 0)
			    {
				if (frame_level == 0)
					printf("Too many '-end's\n");
				else
					frame_level -= 1;
				continue;
			    }
			else
			    {
				printf("Unrecogined option '%s' ignored\n",
				       imagefile);
				continue;
			    }
			if (frame_level == XtNumber(frame)-1)
			    {
				printf("Too many (%d) frame levels\n",
				       frame_level);
				continue;
			    }
			frame_level += 1;
			n = 0;
			if (path < 0)
			    {
				XtSetArg(args[n], XtNallowHoriz, True); ++n;
				XtSetArg(args[n], XtNallowVert, True); ++n;
				frame[frame_level] = XtCreateManagedWidget
					("SubView", viewportWidgetClass,
					 frame[frame_level-1], args, n);
			    }
			else
			    {
				XtSetArg(args[n], XtNlayoutPath, path); ++n;
				frame[frame_level] = XtCreateManagedWidget
					("SubFrame", xeFrameWidgetClass,
					 frame[frame_level-1], args, n);
			    }
			continue;
		    }
		imagetype = XeFindContentFormat(imagefile);
		n = 0;
		XtSetArg(args[n], XtNcontentFile, imagefile); ++n;
		XtSetArg(args[n], XtNcontentFormat, imagetype); ++n;
		switch (XeFindContentClass(imagetype))
		    {
		    default:
			printf("Assuming Text content type\n");
			/*
			** Request proportional spacing, because we are not
			** specifying the lineSpacing.
			*/
			XtSetArg(args[n], XtNproportional, True); ++n;
			widget = XtCreateManagedWidget
				("DemoText", xeTextEdWidgetClass,
				 frame[frame_level], args, n);
			break;
		    case XeContentClass_VIDEO:
			widget = XtCreateManagedWidget
				("DemoVideo",xeVideoWidgetClass,
				 frame[frame_level], args, n);
			break;
		    case XeContentClass_RASTER:
			widget = XtCreateManagedWidget
				("DemoRaster",xeRasterWidgetClass,
				 frame[frame_level],args,n);
			break;
		    case XeContentClass_AUDIO:
			widget = XtCreateManagedWidget
				("DemoAudio", xeAudioWidgetClass,
				 frame[frame_level],args,n);
			break;
		    }
		XtAddCallback(widget,XtNnotifyCallback,Notify,(XtPointer)NULL);
	    }
	XtRealizeWidget(root_widget);
	XtAppMainLoop(demo_application);
	return 0;
    }

