#ifndef _XewRasterP_h
#define _XewRasterP_h
/*
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/BasicP.h>
#include <X11/Xew/Raster.h>
#include "ImageTools.h"

typedef struct _XeRasterClass
    {
	int makes_compiler_happy;	/* not used */
    } XeRasterClassPart;

typedef struct _XeRasterClassRec
    {
	CoreClassPart	core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
#ifdef USING_MOTIF_122
        XmManagerClassPart manager_class;
#endif
        XeBasicClassPart basic_class;
	XeRasterClassPart raster_class;
    } XeRasterClassRec;

typedef struct
    {
	/* resources */

	unsigned int clip_x, clip_y;
	unsigned int clip_width, clip_height;
	unsigned int raster_width, raster_height;
	Dimension offset_x, offset_y;

	/* private state */

	/* The Current display version of the Image */

	GC mygc;		/* Graphic Context */
	XeImage *dsp_image;	/* Display Image */
	XeRawImage *raw_image;	/* Raw image data descriptor */
	unsigned int done:1;	/* TRUE, when XeRasterLayout done */
    } XeRasterPart;

typedef struct _XeRasterRec
    {
	CorePart	core;
	CompositePart	composite;
	ConstraintPart	constraint;
#ifdef USING_MOTIF_122
        XmManagerPart	manager;
#endif
	XeBasicPart	basic;
	XeRasterPart	raster;
    } XeRasterRec;

/* Class pointer */
extern XeRasterClassRec xeRasterClassRec;

#endif




