#ifndef _XewRaster_h
#define _XewRaster_h
/*
** Copyright 1992-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/Basic.h>

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	0
 clipX               ClipX              long            0
 clipY               ClipY              long            0
 clipWidth           ClipWidth          long            -1
 clipHeight          ClipHeight         long            -1
 colormapUse         ColormapUse        XeColormapUse   XeColormapUse_SHARED
 colormapInstall     ColormapInstall    Boolean         False
 colorQuantize       ColorQuantize      XeColorQuantize XeColorQuantize_FAST
 contentFile         ContentFile        String          NULL
 contentLength       ContentLength      long            -1
 contentOffset       ContentOffset      long            0
 contentStream       ContentStream      FILE *          NULL
 contentString       ContentString      Pointer         NULL
 cursor              Cursor             Cursor          None
 destroyCallback     Callback	        Pointer		NULL
 dither              Dither             XeDither        XeDither_FS4
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 maxColors           MaxColors          int             MAXINT
 rasterWidth         RasterWidth        long            from interchange format
 rasterHeight        RasterHeight       long            from interchange format
 visual              Visual             Visual *        NULL
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/


/* New fields */

#define XtNclipX "clipX"
#define XtCClipX "ClipX"
#define XtNclipY "clipY"
#define XtCClipY "ClipY"
#define XtNclipWidth "clipWidth"
#define XtCClipWidth "ClipWidth"
#define XtNclipHeight "clipHeight"
#define XtCClipHeight "ClipHeight"
#define XtNrasterWidth "rasterWidth"
#define XtCRasterWidth "RasterWidth"
#define XtNrasterHeight "rasterHeight"
#define XtCRasterHeight "RasterHeight"

/* Class record constants */

extern WidgetClass xeRasterWidgetClass;

typedef struct _XeRasterClassRec *XeRasterWidgetClass;
typedef struct _XeRasterRec      *XeRasterWidget;

/*
** ********************************************
** XeRaster Programmatic Interface declarations
** ********************************************
*/
typedef enum
    {
	XeImageClass_UNKNOWN,	/* Unspecified type, error */
	XeImageClass_BILEVEL,	/* bi-level (black and white) image */
	XeImageClass_GRAYSCALE,	/* Grayscale image */
	XeImageClass_PALETTE,	/* Palette colour image */
	XeImageClass_FULLCOLOR	/* Full color image */
    } XeImageClass;

typedef enum
    {
	XeImageUnit_NONE,	/* Bare numbers */
	XeImageUnit_INCH,	/* Inch */
	XeImageUnit_CM    	/* Centimeters */
    } XeImageUnit;

typedef enum
    {
	XeImageSpace_NONE,	/* Plain samples (intensity) */
	XeImageSpace_RGB,	/* RGB color space */
	XeImageSpace_YCbCr	/* YCbCr color space */
    } XeImageSpace;

/*
** XeImageChannel
**	is the access "pointer structure" to the real image data. The
**	internal XeRaster Raw -> XImage conversion accesses the actual
**	image data through this pointer.
*/
typedef struct XeImageChannel
    {
	unsigned char *addr;	/* Starting address */
	int w, h;		/* Width and Height of data (pixels) */
	int line;		/* increment to get to next scan line */
	int inc;		/* increment to get to next pixel in line */
    } XeImageChannel;

/*
** XeRawImage
**	describes the format and parameters of the internal raw image
*/
typedef struct XeRawImage
    {
	int references;			/* Reference counter */
	XeImageClass image_class;	/* Raster Image class */
	XeImageSpace color_space;	/* Image color space */
	XeImageUnit resolution_unit;	/* Unit of the resolution attributes */
	float x_resolution;		/* Horizontal scaling */	
	float y_resolution;		/* Vertical scaling */
	unsigned int width;		/* Number of columns in raster image */
	unsigned int height;		/* Number of rows in raster image */
	/*
	** The following parameters describe the structure of the
	** raw image data:
	**
	** samples_per_pixel	Number of components in pixel value.
	** bits_per_sample	Number of significant bits in each
	**			component sample.
	** bits_per_component	Number of actual bits allocated for
	**			each component (e.g. samples may be
	**			only in range 0-15, but each component
	**			might be allocated one byte).
	** bytes_per_line	Total number of bytes in single pixel
	**			row (this includes all necessary padding).
	*/
	unsigned short samples_per_pixel;
	unsigned short bits_per_sample;
	unsigned short bits_per_component;
	int bytes_per_line;
	unsigned int invert_image:1;	/* Implemented for BILEVEL only */
	unsigned int lsbit_first:1;	/* Only for BILEVEL images */
	unsigned int alloc_data:1;	/* TRUE, if data malloc'ed */
	unsigned int alloc_map:1;	/* TRUE, if color_map XtMalloc'ed */
	unsigned char *data;		/* Raw pixel data buffer */
	unsigned char *color_map;	/* 3 * (1<<bits_per_sample) bytes */
	/*
	** 'channel' is an array of structures that can be used to acces
	** individual channels. The space is allocated as needed, there
	** might be one or more of the structures (num_channels).
	**
	** THE FIELD "channel" MUST BE THE LAST FIELD IN THE STRUCTURE!!!
	*/
	unsigned short num_channels;	/* Number of channels */
	XeImageChannel channel[1];	/* Image Channels (struct hack!) */
    } XeRawImage;

_XFUNCPROTOBEGIN

/*
** XeRasterGetRawImage
**	return a reference to the XeRawImage currently set for the XeRaster.
**	This reference must be released by a call to XeDestroyRawImage.
**
**	Returns NULL, if raster has no raw image.
*/
XeRawImage *XeRasterGetRawImage
	(
#if NeedFunctionPrototypes
	 Widget		/* XeRaster Widget pointer */
#endif
	 );

/*
** XeRasterSetRawImage
**	replaces the current Raw Image in the widget with a new one
**	(old raw image is destroyed if any existed).
*/
void XeRasterSetRawImage
	(
#if NeedFunctionPrototypes
	 Widget,	/* XeRaster Widget pointer */
	 XeRawImage *	/* New image for for widget */
#endif
	 );

/*
** XeCreateRawImage
**	Create empty raw image structure which has room for the
**	specified number of channels. The new structure has reference
**	count initialized to one.
*/
XeRawImage *XeCreateRawImage
	(
#if NeedFunctionPrototypes
	 int		/* Number of channel structures */
#endif
	 );

/*
** XeDestroyRawImage
**	Decrement the reference count, and if it reaches ZERO, then
**	release all resources allocated to a raw image, including the
**	descriptor structure itself (do not call this for staticly
**	allocated descriptor!)
*/
void XeDestroyRawImage
	(
#if NeedFunctionPrototypes
	 XeRawImage *		/* Raw Image Descriptor */
#endif
	 );

_XFUNCPROTOEND

#endif
