#ifndef _XewPrint_h
#define _XewPrint_h
/*
** Copyright 1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/Basic.h>

/*
** XePrinter
**	is the application side control structure for the printing process
*/
typedef struct XePrinter
    {
	Display *printer;	/* Printer connection */
	Drawable page;		/* Printer page */
	/*
	** page_width, page_height define the tiling of the widget
	** being printed (using screen/src units, pixels). Each tile
	** is printed as a separate page.
	*/
	int page_width;
	int page_height;
	/*
	** Set background 'True' if you want the widget background
	** color reproduced. When 'False', the widget background
	** color is set to 'white' and 'foreground' (in Xew)
	** is black (this is most significant for XeText widget, which
	** on some applications use white on dark text).
	*/
	Boolean background;
	/*
	** Printer imaging controls (this mostly intended to be used
	** if you want to "downgrade" the features).
	*/
	XeImaging imaging;
    } XePrinter;

/*
** XePrintProcess
**	Opaque type (really defined in Print.c)
*/
typedef struct XePrintProcessRec *XePrintProcess;

#if NeedFunctionPrototypes
typedef void (*XePrintPageProc)(Widget, XePrintProcess, int, XtPointer);
#else
typedef void (*XePrintPageProc)();
#endif

_XFUNCPROTOBEGIN
XePrintProcess XePrint
	(
#if NeedFunctionPrototypes
	 Widget,		/* Widget (root) to print */
	 XePrinter *,		/* Printer destination */
	 XePrintPageProc,	/* Page start/done callback */
	 XtPointer		/* client_data for the callback */
#endif
	 );

void XePrintCancel
	(
#if NeedFunctionPrototypes
	 XePrintProcess		/* Printing context */
#endif
	 );

void XePrintPause
	(
#if NeedFunctionPrototypes
	 XePrintProcess		/* Printing context */
#endif
	 );

void XePrintResume
	(
#if NeedFunctionPrototypes
	 XePrintProcess		/* Printing context */
#endif
	 );

_XFUNCPROTOEND
#endif



