#ifndef BasicColor_h
#define BasicColor_h
/*
** Copyright 1992-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/BasicP.h>
#include "ImageTools.h"

_XFUNCPROTOBEGIN
void _XeFreeColors
	(
#if NeedFunctionPrototypes
	 XeImage *
#endif
	 );
Colormap _XeResetColormap
	(
#if NeedFunctionPrototypes
	 XeImage *,
	 int
#endif
	 );
/*
** _XeAllocColors
**	Remap and allocate colors for a map.
**	This function is only designed to be called with PseudoColor
**	and GrayScale visuals. Calling with others may produce incorrect
**	results.
**
**	Return the number of exact colors actually allocated (do not
**	count "close colors")
*/
int _XeAllocColors
	(
#if NeedFunctionPrototypes
	 XeImage *,		/* Imaging context */
	 int,			/* Size of the input RGB color maps */
	 unsigned char *,	/* Red map */
	 unsigned char *,	/* Green map */
	 unsigned char *,	/* Blue map */
	 unsigned char *,	/* Image data base address */
	 int,			/* Image width */
	 int,			/* Image height */
	 int,			/* Image scanline length (bytes) */
	 int			/* True = request sorting of colors */
#endif
	 );
_XFUNCPROTOEND
#endif


