#ifndef _XewAnimationP_h
#define _XewAnimationP_h
/*
** Copyright 1992, 1993 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <X11/Xew/BasicP.h>
#include <X11/Xew/Animation.h>

typedef struct _XeAnimationClass
    {
	int makes_compiler_happy;	/* not used */
    } XeAnimationClassPart;

typedef struct _XeAnimationClassRec
    {
	CoreClassPart core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
#ifdef USING_MOTIF_122
        XmManagerClassPart manager_class;
#endif
        XeBasicClassPart basic_class;
	XeAnimationClassPart animation_class;
    } XeAnimationClassRec;

typedef struct
    {
	/* resources */
	unsigned long	first_frame, last_frame, current_frame;
	XePlay		play;
	long		rate;
	Boolean		loop;
	XtCallbackList	done_callbacks;
	XtCallbackList	frame_callbacks;
	/* private state */
	unsigned long frame_num;/* Current Frame Shown, 0 = None */
    } XeAnimationPart;

typedef struct _XeAnimationRec
    {
	CorePart	core;
	CompositePart	composite;
	ConstraintPart	constraint;
#ifdef USING_MOTIF_122
        XmManagerPart	manager;
#endif
        XeBasicPart	basic;
	XeAnimationPart	animation;
    } XeAnimationRec;

/* Class pointer */
extern XeAnimationClassRec xeAnimationClassRec;

#endif



