#ifndef _XewAnimation_h
#define _XewAnimation_h
/*
** Copyright 1992-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/Basic.h>

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 contentFile         ContentFile        String          NULL
 contentLength       ContentLength      long            -1
 contentOffset       ContentOffset      long            0
 contentStream       ContentStream      FILE *          NULL
 contentString       ContentString      Pointer         NULL
 currentFrame        CurrentFrame       long            1
 cursor              Cursor             Cursor          None
 destroyCallback     Callback		Pointer		NULL
 doneCallback        DoneCallback       Pointer         NULL
 frameCallback       FrameCallback      Pointer         NULL
 firstFrame          FirstFrame         long            1
 height		     Height		Dimension	0
 lastFrame           LastFrame          long            -1
 loop                Loop               Boolean         False
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 play                Play               XePlay          XePlay_FORWARD
 rate                Rate               long            1
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/


typedef enum
    {
	XePlay_FORWARD,
	XePlay_REVERSE,
	XePlay_FREEZE
    } XePlay;


/*
** XeAnimationDoneCallbackData
**	is the data supplied for callbacks generated by the end of
**	the animation sequence (audio, video). This callback is made
**	via XtNdoneCallback.
*/
typedef struct XeAnimationDoneCallbackData
    {
	int reason;		/* == XeCR_ANIMATION_DONE == */
	unsigned long frame;	/* The last frame shown, 0 = none */
    } XeAnimationDoneCallbackData;

/*
** XeAnimationFrameCallbackData
**	is the data supplied for callbacks generated frames being
**	shown. The callback is made vid XtNframeCallback just before
**	the real frame that equals current_frame is being played.
*/
typedef struct XeAnimationFrameCallbackData
    {
	int reason;		/* == XeCR_ANIMATION_FRAME == */
	unsigned long frame;	/* The frame to be shown, > 0 */
    } XeAnimationFrameCallbackData;

/* New fields */
#define XtNfirstFrame "firstFrame"
#define XtCFirstFrame "FirstFrame"
#define XtNlastFrame "lastFrame"
#define XtCLastFrame "LastFrame"
#define XtNcurrentFrame "currentFrame"
#define XtCCurrentFrame "CurrentFrame"
#define XtNplay "play"
#define XtCPlay "Play"
#define XtRXePlay "XePlay"
#define XtNrate "rate"
#define XtCRate "Rate"
#define XtNloop "loop"
#define XtCLoop "Loop"
#define XtNdoneCallback "doneCallback"
#define XtCDoneCallback "DoneCallback"
#define XtNframeCallback "frameCallback"
#define XtCFrameCallback "FrameCallback"

/* Class record constants */

extern WidgetClass xeAnimationWidgetClass;

typedef struct _XeAnimationClassRec *XeAnimationWidgetClass;
typedef struct _XeAnimationRec *XeAnimationWidget;


#endif
