
typedef struct TransferBlock
    {
	Widget w;	/* Transfer content top level widget */
	Widget log;	/* Transfer log information */
	FILE *f;	/* Command output, in progress */
	XtInputId id;	/* Id of the Input proc or None */
	char *data;	/* Name of the temporary Data File */
	char *cmd;	/* Name of the temporary Command File */
	char *text;	/* Log text string (output from command) */
	int length;	/* Current length of the log text */
	Widget content;	/* Widget to contain the retrieved content */
	Message msg;	/* Associated message structure */
	MsgBody body;	/* Body message/external-body */
    } TransferBlock;

static void CloseWindow(Widget w, XtPointer client_data, XtPointer call_data)
    {
	TransferBlock *tb = (TransferBlock *)client_data;

	tb->w = 0;
	while (!XtIsShell(w))
		w = XtParent(w);
	XtDestroyWidget(w);
    }


static void ReleaseTransfer(Widget w,XtPointer client_data,XtPointer call_data)
    {
	TransferBlock *tb = (TransferBlock *)client_data;

	if (tb->data)
	    {
		unlink(tb->data);
		free(tb->data);
	    }
	if (tb->cmd)
	    {
		unlink(tb->cmd);
		free(tb->cmd);
	    }
	if (tb->text)
		free(tb->text);
	if (tb->f)
		pclose(tb->f);
	if (tb->id != None)
		XtRemoveInput(tb->id);
	free((void *)tb);
    }

static void TransferMonitor(XtPointer client_data, int *fid, XtInputId *id)
    {
	TransferBlock *tb = (TransferBlock *)client_data;
	char buf[1000];
	int n;
	Arg args[30];

	if (tb->w == 0)
	    {
		/* Transfer seems to have been cancelled or something .. */
		XtRemoveInput(*id);
		tb->id = None;
		pclose(tb->f);
		tb->f = NULL;
	    }
	else if ((n = read(*fid, buf, sizeof(buf))) <= 0)
	    {
		/* Transfer completed */
		XtRemoveInput(*id);
		tb->id = None;
		if (tb->f)
			pclose(tb->f);
		tb->f = NULL;
		if (tb->length == 0)
		    {
			n = 0;
			XtSetArg(args[n], XtNcontentString, "Retrieved"); ++n;
			XtSetArg(args[n], XtNcontentLength, 9); ++n;
			XtSetArg(args[n], XtNcontentLoaded, False); ++n;
			XtSetValues(tb->log, args, n);
		    }
		/* Create Actual content */
		if (tb->content)
			XtDestroyWidget(tb->content);
		n = 0;
		XtSetArg(args[n], XtNcontentFile, tb->data); ++n;
		tb->content = MakeContentWidget
			(tb->w, tb->body->child, args, n, (char *)NULL, 0L);
	    }
	else
	    {
		if (tb->length)
			tb->text = (char *)realloc(tb->text, tb->length+n);
		else
			tb->text = (char *)malloc(n);
		memcpy(&tb->text[tb->length], buf, n);
		tb->length += n;
		/* Replace data in transfer log */
		n = 0;
		XtSetArg(args[n], XtNcontentString, tb->text); ++n;
		XtSetArg(args[n], XtNcontentLength, tb->length); ++n;
		XtSetArg(args[n], XtNcontentLoaded, False); ++n;
		XtSetValues(tb->log, args, n);
	    }
    }


static void Retrieve(Widget w, XtPointer client_data, XtPointer call_data)
    {
	static char log_text[] = "Retrieving External Body";

	TransferBlock *tb = (TransferBlock *)client_data;
	char *scheme, *site, *path, *name;
	FILE *f;
	char buf[1000];
	char **params = tb->body->params;

	if (tb->w == 0)
	    {
		Widget popup, panel, top, button;
		char *label;
		label = "External Body";
		XtVaGetValues(w, XtNlabel, &label, (XtPointer)NULL);
		popup = XtVaCreatePopupShell
			("externalBody", transientShellWidgetClass,w,
			 XtNwidth, 500,
			 XtNheight, 500,
			 (XtPointer)NULL);
		panel = XtVaCreateManagedWidget
			("panel", xeFrameWidgetClass, popup,
			 (XtPointer)NULL);
		top = XtVaCreateManagedWidget
			("menuPanel", xeFrameWidgetClass, panel,
			 (XtPointer)NULL);
		button = XtVaCreateManagedWidget
			("menuButton", commandWidgetClass, top,
			 XtNlabel, "close",
			 (XtPointer)NULL);
		XtAddCallback(button, XtNcallback, CloseWindow, (XtPointer)tb);
		tb->log = XtVaCreateManagedWidget
			("log", xeTextWidgetClass, top,
			 (XtPointer)NULL);
		tb->w = XtVaCreateManagedWidget
			("workArea", viewportWidgetClass, panel,
			 XtNallowHoriz, True,
			 XtNallowVert, True,
			 XtNforceBars, True,
			 (XtPointer)NULL);
		tb->content = XtVaCreateManagedWidget
			("content", xeTextWidgetClass, tb->w,
			 (XtPointer)NULL);
		XtPopup(popup, XtGrabNone);
	    }
	XtVaSetValues(tb->log,
		      XtNcontentString, log_text,
		      XtNcontentLength, sizeof(log_text)-1,
		      XtNcontentLoaded, False,
		      (XtPointer)NULL);
	if (tb->text)
		free(tb->text);
	tb->text = NULL;
	tb->length = 0;
	scheme = GetParamValue(params, string_Params[Param_AccessType]);
	if (strcmp("anon-ftp", scheme) == 0)
	    {
		site = GetParamValue(params, string_Params[Param_SiteAddress]);
		path = GetParamValue(params, string_Params[Param_DirName]);
		name = GetParamValue(params, string_Params[Param_FileName]);
		if (tb->cmd == NULL)
			tb->cmd = tempnam("./", "tbcmd");
		if (tb->data == NULL)
			tb->data = tempnam("./", "tbdat");
		f = fopen(tb->cmd, "w");
		fprintf(f, "open %s\n", site);
		fprintf(f, "user anonymous %s@%s\n",
			getenv("USER"), getenv("HOST"));
		fprintf(f, "cd %s\n", path);
		fprintf(f, "get %s %s\n", name, tb->data);
		fprintf(f, "quit\n");
		fclose(f);
		sprintf(buf, "ftp -n < %s", tb->cmd);
		tb->f = f = popen(buf, "r");
		tb->id = XtAppAddInput
			(XtWidgetToApplicationContext(w), fileno(f),
			 (XtPointer)XtInputReadMask, TransferMonitor,
			 (XtPointer)tb);
	    }
	else
		printf("Only anon-ftp external body supported now\n");
    }



static Widget PresentExternalBody
	(Widget root, Widget w, Message msg, MsgBody body,
	 XtCallbackProc callback, XtPointer data)
    {
	char *scheme = NULL, *site= NULL, *path = NULL, *name = NULL;

	char **params = body->params;
	char buf[1000];
	Arg args[10];
	int n;
	TransferBlock *tb;

	/*
	** Construct something like URL (very ad hoc)
	*/
	scheme = GetParamValue(params, string_Params[Param_AccessType]);
	site = GetParamValue(params, string_Params[Param_SiteAddress]);
	if (site == NULL)
		site = GetParamValue(params, "server");
	path = GetParamValue(params, string_Params[Param_DirName]);
	name = GetParamValue(params, string_Params[Param_FileName]);
	buf[sizeof(buf)-1] = 0;
	strcpy(buf, scheme ? scheme : "unknown");
	strcat(buf, ":");
	if (site)
	    {
		strcat(buf, "//");
		strcat(buf, site);
		strcat(buf, "/");
	    }
	if (path)
	    {
		strcat(buf, path);
		strcat(buf, "/");
	    }
	if (name)
		strcat(buf, name);
	if (buf[sizeof(buf)-1])
	    {
		printf("Fatal:Overflowed buf in PresentExternalBody\n");
		exit(1);
	    }
	tb = (TransferBlock *)calloc(1, sizeof(TransferBlock));
	tb->body = body;
	tb->msg = msg;
	n = 0;
	w = XtCreateManagedWidget(buf, commandWidgetClass, root, args,n);
	XtAddCallback(w, XtNcallback, Retrieve, (XtPointer)tb);
	XtAddCallback(w, XtNdestroyCallback, ReleaseTransfer, (XtPointer)tb);
	return w;
    }

