/*
** MIME Viewer
**
** Copyright 1995 by Markku Savela and
**	Technical Research Centre of Finland
**
** *WARNING*
**	This program is not "clean". It contains several "quick short
**	cuts", ugly code and maybe even hard to maintain solutions.
**	The program is memory hungry, not much consideration is put
**	into conserving memory (messages are loaded into memory). The
**	purpose of this program is to
**
** 1)	put the Xew widgets through some stress tests, in interesting
**	way. Find out what functionality Xew still needs and experiment
**	with the new features,
**
** 2)	test user interaction possibilities for MIME, experiment with
**	ideas, to be later perhaps included in the EuroBridge Mail UA
**	(EMMA).
*/

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/stat.h>
#include <assert.h>

#if SYSV_INCLUDES
#include <malloc.h>
#if NeedFunctionPrototypes
extern void qsort(void *, int, int, int (*)(void *, void *));
#else
extern void qsort();
#endif
#endif
#if ANSI_INCLUDES
#	include <stdlib.h>
#endif

/*
** May need to access the sys_errlst for error strings...
*/
extern int sys_nerr;
extern char *sys_errlist[];

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Toggle.h>

#include <X11/Xew/TextEd.h>
#include <X11/Xew/Frame.h>
#include <X11/Xew/Video.h>
#include <X11/Xew/Raster.h>
#include <X11/Xew/Audio.h>
#include <X11/Xew/Support.h>

#include "Mfm.h"
#include "Mam.h"
#include "HeaderExt.h"
#include "ui_tools.h"

#include "display.h"
#include "message.h"
#include "mailcap.h"

#undef tables_h
#define ENUM_TABLE_GENERATION
#include "tables.h"

typedef enum
    {
	ListShow_UNDEFINED,
	ListShow_LIST,		/* Show only directory/folder list */ 
	ListShow_MESSAGE,	/* Show only file/message content */
	ListShow_BOTH		/* Show both (split work area) */
    } ListShow;
	
typedef struct ListStack
    {
	struct ListStack *next;	/* Next in stack */
	dev_t st_dev;		/* Device Number of the directory */
	ino_t st_ino;		/* Inode Number of the directory */
    } ListStack;


/*
** ListData
**	is associated with the list window
*/
typedef struct ListData
    {
	char *name;	/* name of the folder/directory */
	char *item_name;/* item part in the name (if non-null) */
	int name_size;	/* total memory allocation for the name */
	int count;	/* number used items on the list */
	int changed;	/* number of changed items (only for mail folders) */
	int size;	/* number allocated slots on the list */
	ListStack stack;/* Current dir and trace of ..'s from the home level */
	int region;	/* text region corresponding the chosen item */
	int choice;	/* index of the item currently selected */
	unsigned int main_window:1;	/* True, if application main window */
	unsigned int view_only:1;	/* View Only, no controls */
	unsigned int show:2;		/* 'ListShow' selection */
	unsigned int cache:2;		/* MamCache access mode */
	unsigned int directory:1;	/* List is ordinary directory */
	union
	    {
		char **file;	/* item list is a directory */
		MamCache mail;	/* item list is a mail folder */
	    } list;
	Widget root;	/* Instance root widget (shell) */
	Widget self;	/* widget containing the list self */
	Widget content;	/* widget containing the content */
	Message message;/* Current message (if any) */
	MsgBody body;	/* Currently active body part (if any) */
	Widget body_w;	/* Widget containing the current body part (if any) */
	Widget list_w;	/* Ancestor of the list window */
	Widget content_w;/* Ancestor of the content window */
	Widget title;	/* widget containing the title text (item name) */
	/*
	** Main Control panel
	*/
	UI_ElementDef *panel;
	Widget panel_w;
	/*
	** Body Part Control panel
	*/
	UI_ElementDef *bodypart;	/* Control panel elements */
	Widget bodypart_w;		/* Control panel widget */
	char *body_file;		/* Pending External viewer temp file */
	/*
	** A bit nasty kludge: the initial size constraints of the
	** list and content are stored here. These constraints are loaded
	** ininitally and in split window mode, otherwise max used.
	*/
	XeFrameDimension list_vertical, content_vertical;
	XeFrameDimension list_horizontal, content_horizontal;
    } ListData;

/*
** MiewResource
**	application resources structure
*/
typedef struct 
    {
	char *library_path;	/* Look files from these directories */
	char *cache_format;	/* cached info definition */
	char *cache_name;	/* name of the cache file within folders */
	char *header_format;	/* how to present header information */
	char *collaps_format;	/* how to present collapsed body part */
	char *warning_format;	/* how to present warning messages */
	char *raw_format;	/* how to present raw message content */
	char *title_format;	/* how to present title field */
	
	/* label texts */
	char *label_quit;	/* text for the QUIT button(s) */
	char *label_close;	/* text for the CLOSE button(s) */
	char *label_clone;	/* text for the CLONE button(s) */
	char *label_show_both;	/* text for the SHOW BOTH toggle */
	char *label_show_message;/* text for the SHOW MESSAGE toggle */
	char *label_show_list;	/* text for the SHOW LIST toggle */
	char *label_show_body;	/* text for the SHOW BODY toggle */
	char *label_parent;	/* text for the PARENT button(s) */
	char *label_previous;	/* text for the PREVIOUS ITEM button(s) */
	char *label_next;	/* text for the NEXT ITEM button(s) */
	char *label_rescan;	/* text for the RESCAN button */
	char *label_access;	/* text for the CACHE ACCESS toggle */
	char *label_scan;	/* text for the CACHE SCAN toggle */
	char *label_update;	/* text for the CACHE UPDATE toggle */
	char *label_logo;	/* text for the LOGO */

	char *label_body_file;	/* text for the bodypart FILE prompt */
	char *label_body_mailcap;/* text for the bodypart MAILCAP prompt */
	char *label_body_next;	/* text for the NEXT bodypart button */
	char *label_body_previous; /* text for the PREVIOUS bodypart button */
	char *label_body_collaps; /* text for the COLLAPS bodypart button */
	char *label_body_expand; /* text for the EXPAND bodypart button */
	char *label_body_decode;/* text for the DECODED RAW bodypart button */
	char *label_body_raw;	/* text for the RAW bodypart button */

	char *label_viewer_close; /* text for the VIEWER panel close button */
    } MiewResourceRec;

#define offset(field) XtOffsetOf(MiewResourceRec, field)

/*
** NOTE:
**	the fact that I have to define the label strings for the buttons
**	and other things here instead of as resources directly to the
**	widgets shows that there is something to be fixed in the Xew.
**	(one could use 'contentString', but then one would have to specify
**	the contentLength for each also). --msa
*/
static XtResource resources[] =
    {
	{"libraryPath", "LibraryFormat", XtRString, sizeof(String),
	  offset(library_path), XtRString, NULL},
	{"cacheFormat", "CacheFormat", XtRString, sizeof(String),
	  offset(cache_format), XtRString, "%S <%F>"},
	{"cacheName", "CacheName", XtRString, sizeof(String),
	  offset(cache_name), XtRString, ".miew_cache"},
	{"headerFormat", "HeaderFormat", XtRString, sizeof(String),
	  offset(header_format),
	  XtRString, "Subject: %S\nFrom: %F\nTo: %T\nDate: %D\n"},
	{"collapsFormat", "CollapsFormat", XtRString, sizeof(String),
	  offset(collaps_format), XtRString, "\n%D (%S/%T)\n"},
	{"warningFormat", "WarningFormat", XtRString, sizeof(String),
	  offset(warning_format),  XtRString, "\033[31m%M"},
	{"rawFormat", "RawFormat", XtRString, sizeof(String),
	  offset(raw_format),  XtRString, "\033[19;1m"},
	{"titleFormat", "TitleFormat", XtRString, sizeof(String),
	  offset(title_format),  XtRString, "%N(%M) %T"},

	/*
	** Label texts for the user interface buttons
	*/
	{"labelQuit", "LabelQuit", XtRString, sizeof(String),
	  offset(label_quit), XtRString, "Quit"},
	{"labelClose", "LabelClose", XtRString, sizeof(String),
	  offset(label_close), XtRString, "Close"},
	{"labelClone", "LabelClone", XtRString, sizeof(String),
	  offset(label_clone), XtRString, "Clone Window"},
	{"labelParent", "LabelParent", XtRString, sizeof(String),
	  offset(label_parent), XtRString, "Go Up"},
	{"labelShowBoth", "LabelShowBoth", XtRString, sizeof(String),
	  offset(label_show_both), XtRString, "show both"},
	{"labelShowMessage", "LabelShowMessage", XtRString, sizeof(String),
	  offset(label_show_message), XtRString, "show message"},
	{"labelShowList", "LabelShowList", XtRString, sizeof(String),
	  offset(label_show_list), XtRString, "show list"},
	{"labelShowBody", "LabelShowBody", XtRString, sizeof(String),
	  offset(label_show_body), XtRString, "show bodyparts"},
	{"labelPrevious", "LabelPrevious", XtRString, sizeof(String),
	  offset(label_previous), XtRString, "Previous item"},
	{"labelNext", "LabelNext", XtRString, sizeof(String),
	  offset(label_next), XtRString, "Next item"},
	{"labelRescan", "LabelRescan", XtRString, sizeof(String),
	  offset(label_rescan), XtRString, "Rescan list"},
	{"labelAccess", "LabelAccess", XtRString, sizeof(String),
	  offset(label_access), XtRString, "use only cache"},
	{"labelScan", "LabelScan", XtRString, sizeof(String),
	  offset(label_scan), XtRString, "scan list"},
	{"labelUpdate", "LabelUpdate", XtRString, sizeof(String),
	  offset(label_update), XtRString, "scan & update"},
	{"labelLogo", "LabelLogo", XtRString, sizeof(String),
	  offset(label_logo), XtRString, "\1eb.gif"},

	{"labelBodyFile", "LabelBodyFile", XtRString, sizeof(String),
	  offset(label_body_file), XtRString, "Save as: "},
	{"labelBodyMailcap", "LabelBodyMailcap", XtRString, sizeof(String),
	  offset(label_body_mailcap), XtRString, "View with: "},
	{"labelBodyNext", "LabelNext", XtRString, sizeof(String),
	  offset(label_body_next), XtRString, "next part"},
	{"labelBodyPrevious", "LabelPrevious", XtRString, sizeof(String),
	  offset(label_body_previous), XtRString, "previous part"},
	{"labelBodyCollaps", "LabelCollaps", XtRString, sizeof(String),
	  offset(label_body_collaps), XtRString, "collaps"},
	{"labelBodyDecode", "LabelDecode", XtRString, sizeof(String),
	  offset(label_body_decode), XtRString, "show decoded"},
	{"labelBodyRaw", "LabelRaw", XtRString, sizeof(String),
	  offset(label_body_raw), XtRString, "show raw"},
	{"labelBodyExpand", "LabelExpand", XtRString, sizeof(String),
	  offset(label_body_expand), XtRString, "expand"},

	{"labelViewerClose", "LabelClose", XtRString, sizeof(String),
	  offset(label_viewer_close), XtRString, "Close"},
    };
#undef offset

static MiewResourceRec application;
static char application_class[] = "Miew";

/*
** Command Panel Description (a template). Each window will have an own
** private modified copy of this.
*/
static void
	Quit(), CloneViewerInstance(),
	ToggleShow(), ToggleCache(), ToggleBodyPanel(),
	ParentDirectory(), SelectPrevious(), SelectNext(), RescanList();

static char command_name[] = "commandButton";
static char panel_name[] = "menuPanel";
static char toggle_name[] = "toggleBox";
static char logo_name[] = "logoBox";
static char input_name[] = "inputBox";
static char label_name[] = "labelBox";

static UI_ElementDef menu_panel[] =
    {
	/*  0 */ UI_PANE(panel_name,	NULL),
	/*  1 */ UI_BUTTON(command_name,NULL,	Quit),
	/*  2 */ UI_BUTTON(command_name,NULL,	CloneViewerInstance),
	/*  3 */ UI_PANE(panel_name,	NULL),
	/*  4 */ UI_TOGGLE(toggle_name,	NULL,	ListShow_BOTH, ToggleShow),
	/*  5 */ UI_RADIO(toggle_name,	NULL,	ListShow_MESSAGE, ToggleShow),
	/*  6 */ UI_RADIO(toggle_name,	NULL,	ListShow_LIST, ToggleShow),
	/*  7 */ UI_TOGGLE(toggle_name, NULL,	0, ToggleBodyPanel), 
	/*  8 */ UI_PANE(panel_name,	NULL),
	/*  9 */ UI_BUTTON(command_name,NULL,	ParentDirectory),
	/* 10 */ UI_BUTTON(command_name,NULL,	SelectPrevious),
	/* 11 */ UI_BUTTON(command_name,NULL,	SelectNext),
	/* 12 */ UI_PANE(panel_name,	NULL),
	/* 13 */ UI_BUTTON(command_name,NULL,	RescanList),	 
	/* 14 */ UI_TOGGLE(toggle_name,	NULL,	MamCache_ACCESS, ToggleCache),
	/* 15 */ UI_RADIO(toggle_name,	NULL,	MamCache_SCAN, ToggleCache),
	/* 16 */ UI_RADIO(toggle_name,	NULL,	MamCache_UPDATE, ToggleCache),
	/* 17 */ UI_PANE(logo_name, 	NULL),		
	UI_END(),
    };
/*
** KEEP THESE IN SYNC WITH ABOVE!!!
*/
typedef enum
    {
	Panel_CLOSE	= 1,
	Panel_CLONE	= 2,
	Panel_BOTH	= 4,
	Panel_MESSAGE	= 5,
	Panel_LIST	= 6,
	Panel_BODY	= 7,
	Panel_PARENT	= 9,
	Panel_PREVIOUS	= 10,
	Panel_NEXT	= 11,
	Panel_RESCAN	= 13,
	Panel_ACCESS	= 14,
	Panel_SCAN	= 15,
	Panel_UPDATE	= 16,
	Panel_LOGO	= 17
    } MenuPanelElement;

static void
	BodyPartAction(), PreviousBodyPart(), NextBodyPart(),
	SaveBodyPart(), ViewByMailcap(), ExpandBodyPart(), CollapsBodyPart(),
	DecodeBodyPart(), RawBodyPart();

static UI_ElementDef body_panel[] =
    {
	/*  0 */ UI_PANE(panel_name,	NULL),
	/*  1 */ UI_LABEL(label_name,	""), /* bodypart type widget */
	/*  2 */ UI_LABEL(label_name,	""), /* bodypart description widget */
	/*  3 */ UI_INPUT(input_name,	NULL, SaveBodyPart),
	/*  4 */ UI_INPUT(input_name,	NULL, ViewByMailcap),
	/*  5 */ UI_PANE(panel_name,	NULL),
	/*  6 */ UI_BUTTON(command_name,NULL, CollapsBodyPart),
	/*  7 */ UI_BUTTON(command_name,NULL, ExpandBodyPart),
	/*  8 */ UI_BUTTON(command_name,NULL, DecodeBodyPart),
	/*  9 */ UI_BUTTON(command_name,NULL, RawBodyPart),
	/* 10 */ UI_PANE(panel_name,	NULL),
	/* 11 */ UI_BUTTON(command_name,NULL, PreviousBodyPart),
	/* 12 */ UI_BUTTON(command_name,NULL, NextBodyPart),	 
	UI_END(),
    };

/*
** KEEP THESE IN SYNC WITH ABOVE!!!
*/
typedef enum
    {
	BodyPart_TYPE		= 1,
	BodyPart_DESCRIPTION 	= 2,
	BodyPart_FILE		= 3,
	BodyPart_MAILCAP	= 4,
	BodyPart_COLLAPS	= 6,
	BodyPart_EXPAND		= 7,
	BodyPart_DECODE		= 8,
	BodyPart_RAW		= 9,
	BodyPart_PREVIOUS 	= 11,
	BodyPart_NEXT		= 12,
    } BodyPanelElement;

static void
	CloseViewerPanel();

/*
** Popup control panel template for active external viewer
*/
static UI_ElementDef viewer_panel[] =
    {
	/*  0 */ UI_PANE(panel_name,	NULL),
	/*  1 */ UI_BUTTON(command_name,NULL, CloseViewerPanel),
	/*  2 */ UI_PANE(logo_name,	""),	/* executing ... */
		 UI_END(),
    };

typedef enum
    {
	Viewer_CLOSE = 1,
	Viewer_EXECUTING = 2
    } ViewerPanelElement;

/*
** ExternalViewer
**	is a control block for active external viewer
*/
typedef struct ExternalViewer
    {
	Widget shell;		/* Popup shell */
	Widget w;		/* Widget to receive stdout of the viewer */
	char *name;		/* Temp filename being used */
	XtInputId id;		/* XtAppAddInput return value (if any) */
	FILE *fp;		/* Attached popen() stream */
	UI_ElementDef panel[XtNumber(viewer_panel)];
    } ExternalViewer;

/*
** Format
**	interpret a Mail formatting string and release the text output
**	via a sequence of text feed calls.
*/
typedef int (*FeedText)(void *, char *, int);

static void Format(MsgBody body, char *format, FeedText feed, void *context)
    {
	static struct _MsgHeader no_hdr;
	
	char *r, *mark, **list, *item[2];
	MsgHeader hdr;

	if (format == NULL || body == NULL)
		return;
	hdr = body->header ? body->header : &no_hdr;
	item[1] = NULL;
	for (r = mark = format; (r = strchr(r, '%')) != NULL; )
	    {
		int code, maxlength;

		feed(context, mark, r - mark);
		list = item;
		maxlength = 0;
		code = *++r;
		while (isdigit(code))
		    {
			maxlength += maxlength * 10 + (code - '0');
			code = *++r;
		    }
		if (maxlength == 0)
			maxlength = 10000; /* should be large enough! --msa */
		if (code != 0) /* Watch out for NUL byte! */
			mark = ++r;
		else
			mark = r;
		switch (code)
		    {
		    case 'F':	/* Message From */
			item[0] = hdr->from;
			break;
		    case 'S':	/* Message Subject */
			item[0] = hdr->subject;
			break;
		    case 'T':	/* Message To */
			list = hdr->to;
			break;
		    case 'C':	/* Message Cc */
			list = hdr->cc;
			break;
		    case 'D':	/* Message Date */
			item[0] = hdr->date;
			break;
		    default:	/* Take following char as is */
			--mark;
			list = NULL;
			break;
		    }
		if (list && *list)
			while (1)
			    {
				char *tmp = ConvertHeaderExtension(*list);
				int length = strlen(tmp);

				if (length > maxlength)
					length = maxlength;
				maxlength -= length;
				feed(context, tmp, length);
				if (*++list == NULL)
					break;
				if (maxlength < 2)
					break;
				feed(context, ", ", 2);
			    }
	    }
	feed(context, mark, strlen(mark));
    }


/*
** FormatStrings
**	A simple string formatting routine (directly into Widget)
*/
typedef struct FormatMap
    {
	int code;	/* Format code letter, ( %<letter> ) */
	int string;	/* Index to the string data table */
    } FormatMap;

static void FormatStrings(Widget w, char *f, FormatMap *map, char **str)
    {
	char *mark;
	int i;
	
	for (mark = f; (f = strchr(f,'%')) != NULL;)
	    {
		int code;

		XeTextInsert(w, mark, f - mark);
		mark = (code = *++f) ? ++f : f;
		for (i = 0;; ++i)
			if (map[i].code == 0)
			    {
				--mark;
				break;
			    }
			else if (code == map[i].code)
			    {
				char *s = str[map[i].string];

				if (s != NULL)
					XeTextInsert(w, s, strlen(s));
				break;
			    }
	    }
	XeTextInsert(w, mark, strlen(mark));
    }


typedef struct
    {
	char buf[1000];
	int length;
    } CacheLineBuf;

static int FeedCacheLine(void *context, char *s, int n)
    {
	CacheLineBuf *line = (CacheLineBuf *)context;

	if (n > sizeof(line->buf) - line->length)
		n = sizeof(line->buf) - line->length;
	if (n > 0)
	    {
		memcpy(&line->buf[line->length], s, n);
		line->length += n;
	    }
	return n;
    }

static char *MakeCacheData(Message msg, int *length)
    {
	CacheLineBuf line;
	char *s;

        *length = line.length = 0;
        if (msg == NULL)
                return NULL;
	Format(msg->body, application.cache_format, FeedCacheLine, &line );
        *length = line.length;
	s = (char *)XtMalloc(line.length + 1);
	memcpy(s, line.buf, line.length);
	s[line.length] = 0;
        return s;
    }


/*
** Exit, Quit
**	Exit and Quit will handle clean exit from application and
**	guarantee that all destroy callbacks get properly called before
**	the application dies (this is required because some widgets may
**	have external data associated, such as temporary files).
**	(coded after instructions from Xt.FAQ)
*/
static Boolean Exit(client_data)
XtPointer client_data;
    {
	exit(0);
    }

static void Quit(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	while (XtParent(w))
		w = XtParent(w);
	XtUnmapWidget(w);
	XtDestroyWidget(w);
	XtAppAddWorkProc
		(XtWidgetToApplicationContext(w), Exit, (XtPointer)NULL);
    }


static Position AdjustCoord(x, y, a, b)
int x, y, a, b;
    {
	if (x < a)
		a = x;
	else if (x + y >= a + b)
		a = x + y - b;
	return a;
    }
/*
** WindowScroll
**	can be bound to XeCR_NOTIFY_AREA in XtNnotifyCallaback
*/
static void WindowScroll(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeNotifyAreaCallbackData *area = (XeNotifyAreaCallbackData *)call_data;
	Position x, y;

	if (area == NULL || area->reason != XeCR_NOTIFY_AREA)
		return;
	/*
	** This works only works if the parent is X11R5 viewport
	*/
#if X11R5
	x = AdjustCoord(area->area.x, area->area.width,
			area->visible.x, area->visible.width);
	y = AdjustCoord(area->area.y, area->area.height,
			area->visible.y, area->visible.height);
	if (x != area->visible.x || y != area->visible.y)
		XawViewportSetCoordinates(XtParent(w), x, y);
#endif
    }

static void DisplayError(w, t1, t2, t3)
Widget w;
char *t1, *t2, *t3;
    {
	char *mark, *r;
	
	XtVaSetValues(w, XtNcontentLoaded, False,(XtPointer)NULL);
	for (mark = r = application.warning_format; (r=strchr(r,'%')) != NULL;)
	    {
		int code;

		XeTextInsert(w, mark, r - mark);
		mark = (code = *++r) ? ++r : r;
		if (code == 'M')
		    {
			if (t1)
				XeTextInsert(w, t1, strlen(t1));
			if (t2)
				XeTextInsert(w, t2, strlen(t2));
			if (t3)
				XeTextInsert(w, t3, strlen(t3));
		    }
		else
			--mark;
	    }
	XeTextInsert(w, mark, strlen(mark));
    }


static int HeaderFeed(void *context, char *s, int n)
    {
	XeTextInsert((Widget)context, s, n);
	return n;
    }

void DisplayMessageHeader(w, body)
Widget w;	/* XeTextEd to receive the header presentation */
MsgBody body;	/* MsgBody to extract the header information */
    {
	Format(body, application.header_format, HeaderFeed, (void *)w);
    }


/*
** SetToggleConfiguration
*/
static void SetToggleConfiguration(group, n, id)
UI_ElementDef *group;
int n;
XtArgVal id;
    {
	UI_ElementDef *set;

	/*
	** Make toggles to match the current selection (id). This is
	** something that should be done within ui_tools, because assumptions
	** are made here about internal structure of the toggle element
	** (assuming that athena Toggle is used and that XtNradioData is
	** actually a pointer to the UI_ElementDef).. ugly! --msa
	*/
	set = (UI_ElementDef *)XawToggleGetCurrent(group->widget);
	if (set == NULL || set->data != id)
	    {
		for (set = group; n > 0; --n, set++)
			if (id == set->data)
			    {
				XawToggleSetCurrent(set->widget,
						    (XtPointer)set);
				break;
			    }
	    }
    }


/*
** ShuffleWindows
**	shuffles the display windows so that at least the first is visible
**
**	This is not very generic: first and second must have a common parent.
*/
static void ShuffleWindows(list, configuration)
ListData *list;
ListShow configuration;
    {
	static XeFrameDimension maximize;

	Widget manage[2], unmanage = None, first, second;
	int n = 0;

	if (list->show == ListShow_BOTH)
		configuration = ListShow_BOTH;

	if (configuration == ListShow_MESSAGE)
	    {
		first = list->content_w;
		second = list->list_w;
	    }
	else
	    {
		first = list->list_w;
		second = list->content_w;
	    }
	if (list->show != configuration)
		SetToggleConfiguration(&list->panel[Panel_BOTH], 3,
				       (XtArgVal)configuration);
	list->show = configuration;
	manage[0] = second;
	if (configuration == ListShow_BOTH)
	    {
		n = !XtIsManaged(manage[0]);
		/*
		** Showing both, restore the original constraints to the list
		*/
		XtVaSetValues(list->list_w,
			      XtNhorizontal, &list->list_horizontal,
			      XtNvertical, &list->list_vertical,
			      (XtPointer)NULL);
		/*
		** If already realized, let the users sizing of the window
		** to control the size of the content window
		*/
		if (XtIsRealized(list->content_w))
			XtVaSetValues(list->content_w,
				      XtNhorizontal, &maximize,
				      XtNvertical, &maximize,
				      (XtPointer)NULL);
	    }
	else
	    {
		if (XtIsManaged(manage[0]))
			/* unmanage = manage[0]; */
			XtUnmanageChild(manage[0]);
		/*
		** Showing only one, remove constraint from first (unless
		** it is still not realized (this will let the resources
		** to take effect at initialize, but later leave the control
		** to the user sizing the window...
		*/
		if (XtIsRealized(first))
			XtVaSetValues
				(first,
				 XtNhorizontal, &maximize,
				 XtNvertical, &maximize,
				 (XtPointer)NULL);
	    }
	manage[n] = first;
	if (!XtIsManaged(manage[n]))
		++n;
	/* .. it should not make any difference, but order manage/unmanage
	   such that parent will always have at least one managed child..
	   */
	if (n > 0)
		XtManageChildren(manage, n);
	if (unmanage)
		XtUnmanageChild(unmanage);
    }

/*
** UpdateButtons
**	sensitivity (make some buttons sensitive/unsensitive depending
**	on the current state of the display
*/
static void UpdateButtons(list)
ListData *list;
    {
	XtVaSetValues(list->panel[Panel_PREVIOUS].widget,
		      XtNsensitive, (list->choice > 0 && list->count > 0),
		      (XtPointer)NULL);
	XtVaSetValues(list->panel[Panel_NEXT].widget,
		      XtNsensitive, (list->choice < list->count - 1),
		      (XtPointer)NULL);
    }

static void HighlightTagged(w, start, tag, old)
Widget w;
long start;
XeTextTag tag;
Widget old;
    {
	long end;
	/*
	** Remove old highlights
	*/
	if (old)
	    {
		int i = 0;

		while ((i = XeTextUnsetRegion(old, i)) > 0)
			/* Nothing */;
	    }
	if (start < 0)
		return;
	/*
	** Set new highlight area
	*/
	end = XeTextLocateTag(w, start, tag, 0);
	if (end >= 0)
		XeTextSetRegion(w, start, end, XeTextHighlight_FRAME);
    }

static long UndisplayBodyPart(Widget w, MsgBody body)
    {
	long start, end;

	start = XeTextLocateTag(w, 0L, (XeTextTag)body, 1);
	if (start >= 0)
	    {
		end = XeTextLocateTag(w, start, (XeTextTag)body, 0);
		XeTextReplaceTagged(w, start, end, "", 0L, (XeTextTag)body);
	    }
	return start;
    }

static void XeTextSetString(w, str)
Widget w;
char *str;
    {
	Arg args[3];

	XtSetArg(args[0], XtNcontentString, str);
	XtSetArg(args[1], XtNcontentLength, str ? strlen(str) : 0);
	XtSetArg(args[2], XtNcontentLoaded, False);
	XtSetValues(w, args, 3);
	XtSetArg(args[0], XtNcontentString, NULL);
	XtSetValues(w, args, 1);
    }

static char *Pick(char **list, char *def, char *name)
    {
	char *s, *v;

	if (list != NULL) 
		while ((s = *list++) && (v = *list++))
			if (strcmp(s, name) == 0)
				return v;
	return def;
    }

/*
** ShowBodyInfo
*/
static void ShowBodyInfo(ListData *list, MsgBody body, Widget w)
    {
	long start;

	if (list == NULL || list->message == NULL)
		return;
	if (list->body != body)
	    {
		char *type, *subtype, *cmd;
		Widget txt, old;
		int copious;
		
		list->body = body;
		old = list->body_w;
		list->body_w = w;

		type = string_ContType[(int)list->body->type];
		if (list->body->type == CT_unknown)
			type = Pick(list->body->params, type, "x-eb-type");
		subtype = string_SubType[(int)list->body->subtype];
		if (list->body->subtype == ST_unknown)
			subtype = Pick
				(list->body->params, subtype, "x-eb-subtype");
		txt = list->bodypart[BodyPart_TYPE].widget;
		XeTextDisableDisplay(txt);
		XeTextSetString(txt, "");
		XeTextInsert(txt, type, strlen(type));
		XeTextInsert(txt, "/", 1);
		XeTextInsert(txt, subtype, strlen(subtype));
		if (list->body->id)
		    {
			XeTextInsert(txt, " id=", 4);
			XeTextInsert(txt, list->body->id,
				     strlen(list->body->id));
		    }
		XeTextEnableDisplay(txt);
		XeTextSetString(list->bodypart[BodyPart_DESCRIPTION].widget,
				list->body->description);
		XeTextSetString(list->bodypart[BodyPart_FILE].widget,
				Pick(list->body->params, "", "name"));
		if (list->body_file)
		    {
			free(list->body_file);
			list->body_file = NULL;
		    }
		cmd = MailcapView(list->message, list->body,
				  &list->body_file, &copious);
		XeTextSetString(list->bodypart[BodyPart_MAILCAP].widget, cmd);
		free(cmd);
		start = XeTextLocateTag(w, 0L, (XeTextTag)list->body, 1);
		HighlightTagged(w, start, (XeTextTag)list->body, old);
	    }
	if (!XtIsManaged(list->bodypart_w))
		XtManageChild(list->bodypart_w);
    }

/*
** ToggleBodyPanel
*/
static void ToggleBodyPanel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
       	Boolean state = call_data != NULL;
	UI_ElementDef *set;

	if (list == NULL)
		return;
	XtVaSetValues(w, XtNinvertShadow, state, (XtPointer)NULL);

	set = (UI_ElementDef *)
		XawToggleGetCurrent(list->panel[Panel_BODY].widget);
	if (set == NULL)
	    {
		HighlightTagged(list->content, -1L, (XeTextTag)0,list->body_w);
		if (XtIsManaged(list->bodypart_w))
			XtUnmanageChild(list->bodypart_w);
	    }
	else
	    {
		if (list->body == NULL)
			NextBodyPart(w, client_data, call_data);
		else
		    {
			MsgBody body = list->body;

			list->body = NULL; /* This forces refresh below */
			ShowBodyInfo(list, body, list->body_w);
		    }
	    }
    }


/*
** CloseViewerPanel
**	bound the "close" button on the external viewer panel. If input is
**	still active, then just popdown the panel. Otherwise, destroy the
**	panel.
*/
static void CloseViewerPanel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ExternalViewer *view = (ExternalViewer *)client_data;

	if (view == NULL)
		return;
	if (view->fp != NULL)
		XtPopdown(view->shell); /* Viewer running, just pop down */
	else
	    {
		XtDestroyWidget(view->shell); /* Viewer not running, kill */
		free((char *)view);
	    }
    }

/*
** ReadFromExternalViewer
**	is called when there is more input from the stdout of a
**	running external viewer process.
*/
static void ReadFromExternalViewer(client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
    {
	ExternalViewer *view = (ExternalViewer *)client_data;
	char buf[1000];
	long count;

	if (view == 0)
		return;
	/*
	** Cannot use loop to read until pipe is empty. This is
	** blocking read and it would be impossible to detect the case
	** where pipe had exactly sizeof(buf) bytes available, trying to
	** read next chunk would block...
	*/
	count = read(*source, buf, sizeof(buf));
	if (count <= 0)
	    {
		/* EOF or an error reached */
		if (view->name)
		    {
			unlink(view->name);
			free(view->name);
		    }
		if (view->fp)
			pclose(view->fp);
		view->fp = NULL;
		if (view->id)
			XtRemoveInput(view->id);
		view->id = 0;
		XeTextSetInsertionPosition(view->w, 0L);
		if (XtIsRealized(view->shell))
		    {
			DisplayError(view->panel[Viewer_EXECUTING].widget,
				     "Completed", (char *)NULL, (char *)NULL);
			XtPopup(view->shell, XtGrabNone);
		    }
		else
		    {
			XtDestroyWidget(view->shell);
			free((char *)view);
		    }
	    }
	else if (view->w)
	    {
		XeTextInsert(view->w, buf, count);
		if (!XtIsRealized(view->shell))
		    {
			XtRealizeWidget(view->shell);
			XtPopup(view->shell, XtGrabNone);
		    }
	    }
    }

/*
** ViewByMailcap
**	user wants to activate an external viewer for the body part
*/
static void ViewByMailcap(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	char *cmd = NULL, *content = NULL;
	long length;
	FILE *fp;
	ExternalViewer *view;
	char *n1 = NULL, *n2 = NULL, *n3 = NULL;
	MsgBody body;
	Widget pane, work;

	for (;list&&list->bodypart && list->bodypart[BodyPart_MAILCAP].widget;)
	    {
		if (list->message == NULL)
		    {
			n1 = "No message selected";
			break;
		    }
		if (list->body == NULL)
		    {
			n1 = "No bodypart selected";
			break;
		    }
		cmd = XeTextGetString
			(list->bodypart[BodyPart_MAILCAP].widget, &length);
		if (cmd == NULL)
		    {
			n1 = "No view command specified";
			break;
		    }
		content = MamGetContent(list->message, list->body, &length);
		if (content == NULL)
		    {
			n1 = "No real content to save (empty bodypart)";
			break;
		    }
		if (list->body_file == NULL)
		    {
			/*
			** Assume the command takes body from the stdin
			*/
			char *tmp = tmpnam((char *)NULL);
			int n = strlen(tmp);

			list->body_file = strcpy((char *)malloc(n + 1), tmp);
			tmp = (char *)malloc(strlen(cmd) + n + 8);
			sprintf(tmp, "cat %s | %s", list->body_file, cmd);
			free(cmd);
			cmd = tmp;
		    }
		fp = fopen(list->body_file, "wb");
		if (fp == NULL)
		    {

			n1 = "Cannot create temp file: ";
			n2 = list->body_file;
			break;
		    }
		(void)fwrite(content, 1, (int)length, fp);
		fclose(fp);

		/*
		** Build independent viewer instance
		*/
		view = (ExternalViewer *)malloc(sizeof(ExternalViewer));
		if (view == NULL)
		    {
			n1 = "Memory allocation error";
			break;
		    }
		view->name = list->body_file;
		list->body_file = NULL;

		view->shell = XtCreatePopupShell
			(application_class,
			 transientShellWidgetClass,
			 list->root,
			 (ArgList)NULL, (Cardinal)0);
		pane = XtVaCreateManagedWidget
			("mainWindow", xeFrameWidgetClass, view->shell,
			 (XtPointer)NULL);
		memcpy((char *)view->panel, (char *)viewer_panel,
		       sizeof(view->panel));
		(void)UI_CreateElementPanel
			(pane, panel_name, view->panel, (XtPointer)view);
		work = XtVaCreateManagedWidget
			("workArea", xeFrameWidgetClass, pane,
			 (XtPointer)NULL);
		work = XtVaCreateManagedWidget
			("messageView", viewportWidgetClass, work,
			 XtNallowHoriz, True,
			 XtNallowVert, True,
			 (XtPointer)NULL);
		view->w = XtVaCreateManagedWidget
			("messageContent", xeTextEdWidgetClass, work,
			 XtNallowEdit, False,
			 XtNdisplayCaret, False,
			 (XtPointer)NULL);
		XtAddCallback(view->w, XtNnotifyCallback, WindowScroll,
			      (XtPointer)NULL);
		view->fp = popen(cmd, "r");
		view->id = XtAppAddInput
			(XtWidgetToApplicationContext(list->body_w),
			 fileno(view->fp),
			 (XtPointer)XtInputReadMask,
			 ReadFromExternalViewer,
			 (XtPointer)view);
		n1 = "Executing: ";
		n2 = cmd;
		DisplayError(view->panel[Viewer_EXECUTING].widget, n1, n2, n3);
		/*
		** Regenerate Body Information panel and hightlight
		*/
		body = list->body;
		list->body = NULL;
		ShowBodyInfo(list, body, list->body_w);
		break;
	    }
	if (n1)
		DisplayError(list->bodypart[BodyPart_DESCRIPTION].widget,
			     n1, n2, n3);
	if (cmd)
		XtFree(cmd);
	if (content)
		free(content);
    }

static void SaveBodyPart(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	char *name = NULL;
	char *content = NULL;
	char *n1 = NULL, *n2 = NULL, *n3 = NULL;
	FILE *fp = NULL;
	long length, count;

	list = (ListData *)client_data;
	for (;list && list->bodypart && list->bodypart[BodyPart_FILE].widget;)
	    {
		if (list->message == NULL)
		    {
			n1 = "No message selected";
			break;
		    }
		if (list->body == NULL)
		    {
			n1 = "No bodypart selected";
			break;
		    }
		name = XeTextGetString
			(list->bodypart[BodyPart_FILE].widget, &length);
		if (name == NULL)
		    {
			n1 = "No filename specified";
			break;
		    }
		content = MamGetContent(list->message, list->body, &length);
		if (content == NULL)
		    {
			n1 = "No real content to view (empty bodypart)";
			break;
		    }
		fp = fopen(name, "wb");
		if (fp == NULL)
		    {

			n1 = "Cannot create output file: ";
			n2 = name;
			break;
		    }
		count = fwrite(content, 1, (int)length, fp);
		n2 = name;
		if (count != length)
			n1 = "Write error on ";
		else
			n1 = "Wrote ";
		break;
	    }
	if (n1)
		DisplayError(list->bodypart[BodyPart_DESCRIPTION].widget,
			     n1, n2, n3);
	if (name)
		XtFree(name);
	if (content)
		free(content);
	if (fp)
		fclose(fp);
    }

static void ExpandBodyPart(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	long start;
	
	if (list == NULL || list->body == NULL || list->message == NULL)
		return;

	XeTextDisableDisplay(list->body_w);
	start = UndisplayBodyPart(list->body_w, list->body);
	DisplayContentPart(list->body_w, list->message, list->body,
			   BodyPartAction, (XtPointer)list,
			   DisplayMessageHeader);
	HighlightTagged(list->body_w,start,(XeTextTag)list->body,list->body_w);
	XeTextEnableDisplay(list->body_w);
	XeTextSetInsertionPosition(list->body_w, start);
    }

static void DisplayRawBody(ListData *list, int decode)
    {
	char *content;
	
	long start, length;
	
	if (list == NULL || list->body == NULL || list->message == NULL)
		return;

	XeTextDisableDisplay(list->body_w);
	start = UndisplayBodyPart(list->body_w, list->body);
	if (decode)
		content = MamGetContent(list->message, list->body, &length);
	else
		content = MamGetRawContent(list->message, list->body, &length);
	if (content)
	    {
		XeTextInsert(list->body_w, application.raw_format,
			     strlen(application.raw_format));
		XeTextInsert(list->body_w, content, length);
		free(content);
	    }
	HighlightTagged(list->body_w,start,(XeTextTag)list->body,list->body_w);
	XeTextEnableDisplay(list->body_w);
	XeTextSetInsertionPosition(list->body_w, start);
    }

static void RawBodyPart(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	DisplayRawBody((ListData *)client_data, 0);
    }

static void DecodeBodyPart(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	DisplayRawBody((ListData *)client_data, 1);
    }

static void CollapsBodyPart(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	long start;

	typedef enum
	    {
		DESCRIPTION,
		TYPE,
		SUBTYPE,
		MAXINDEX
	    } MapIndexes;
	
	static FormatMap collaps_map[] = 
	    {
		{'D', DESCRIPTION},	/* body part description field */
		{'T', TYPE},		/* body part type field */
		{'S', SUBTYPE},		/* body part subtype field */
		{ 0,  0},		/* Terminator */
	    };
	char *collaps_str[(int)MAXINDEX];
	
	if (list == NULL || list->body == NULL || list->message == NULL)
		return;

	XeTextDisableDisplay(list->body_w);
	start = UndisplayBodyPart(list->body_w, list->body);
	collaps_str[DESCRIPTION] = list->body->description;
	collaps_str[TYPE] = string_ContType[(int)list->body->type];
	if (list->body->type == CT_unknown)
		collaps_str[TYPE] = Pick(list->body->params,
					 collaps_str[TYPE], "x-eb-type");
	collaps_str[SUBTYPE] = string_SubType[(int)list->body->subtype];
	if (list->body->subtype == ST_unknown)
		collaps_str[SUBTYPE] = Pick(list->body->params,
					    collaps_str[SUBTYPE],
					    "x-eb-subtype");
	FormatStrings(list->body_w, application.collaps_format,
		      collaps_map, collaps_str);
	HighlightTagged(list->body_w,start,(XeTextTag)list->body,list->body_w);
	XeTextEnableDisplay(list->body_w);
	XeTextSetInsertionPosition(list->body_w, start);
    }

static void NextBodyPart(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	long start = 0;
	MsgBody body;

	if (list == NULL || list->message == NULL)
		return;
	/*
	** If no previous body part, then search first first body that has
	** Non-NULL tag. If there is current body part, then search for
	** next different tag value
	*/
	if (list->body)
	    {
		start = XeTextLocateTag
			(list->body_w, start, (XeTextTag)list->body, 1);
	    }
	else
		list->body_w = list->content;
	start = XeTextLocateTag
			(list->body_w, start, (XeTextTag)list->body, 0);
	if (start < 0)
		return;
	XeTextSetInsertionPosition(list->body_w, start);
	body = (MsgBody)XeTextGetInsertionTag(list->body_w);
	if (body != NULL)
		ShowBodyInfo(list, body, list->body_w);
    }

static void PreviousBodyPart(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	long end;
	MsgBody body;

	if (list == NULL || list->message == NULL || list->body == NULL)
		return;
	/*
	** Find the beginning of the current body part
	*/
	end = XeTextLocateTag(list->body_w, 0L, (XeTextTag)list->body, 1);
	if (end <= 0)
		return;
	XeTextSetInsertionPosition(list->body_w, --end);
	body = (MsgBody)XeTextGetInsertionTag(list->body_w);
	if (body != NULL)
		ShowBodyInfo(list, body, list->body_w);
    }

/*
** BodyPartAction
*/
static void BodyPartAction(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	XeActivateCallbackData *activate = (XeActivateCallbackData *)call_data;
	MsgBody body;
	Widget originate = w;
	
	if (list == NULL || list->message == NULL ||
	    activate == NULL || activate->reason != XeCR_ACTIVATE)
		return;
	/*
	** If bodypart control panel is not visible, there is no action
	*/
	if (!XtIsManaged(list->bodypart_w))
		return;
	/*
	** Locate the "wrapping" XeText widget, a bit ad hoc method...
	** ...fix later...
	*/
	while (strcmp("messageContent", XtName(w)) &&
	       strcmp("messageMessage", XtName(w)))
		if (!(w = XtParent(w)))
			return; /* Not found! */
	if (w != originate && activate->event &&
	    (activate->event->type == ButtonPress ||
	     activate->event->type == ButtonRelease))
	    {
		/*
		** Need to relocate the (x,y) in the event... sigh..
		** (Deal with Button events only for now..)
		*/
		Position target_x, target_y, source_x, source_y;
		source_x = activate->event->xbutton.x;
		source_y = activate->event->xbutton.y;
		XtTranslateCoords(originate, source_x, source_y,
				  &source_x, &source_y);
		XtTranslateCoords(w, 0, 0, &target_x, &target_y);
		activate->event->xbutton.x = source_x - target_x;
		activate->event->xbutton.y = source_y - target_y;
	    }
	/*
	** On content, move the current position as close to
	** pointer as possible.
	*/
	XtCallActionProc
		(w, "pointer", activate->event, (String *)NULL, (Cardinal)0);
	/*
	** Get the bodypart associated with this point (if any)
	*/
	body = (MsgBody)XeTextGetInsertionTag(w);
	if (body != NULL)
		ShowBodyInfo(list, body, w);
    }

/*
** DisplayObject
**	Display the object pointed by list as a content. Path is a full
**	path (not relative to the list any more).
*/
static void DisplayObject(list)
ListData *list;
    {
	WidgetClass class = NULL;
	XeContentFormat fmt;

	XeTextDisableDisplay(list->content);
	ShuffleWindows(list, ListShow_MESSAGE);
	UpdateButtons(list);
	if (list->message)
	    {
		FreeMessage(list->message);
		list->message = NULL;
		list->body = NULL;
	    }
	XtVaSetValues(list->content,XtNcontentLoaded, False,(XtPointer)NULL);
	if (list->directory)
	    {
		/*
		** If the file is obviously of some known format, then
		** do not try to load it with MamLoad
		*/
		fmt = XeFindContentFormat(list->name);
		switch (XeFindContentClass(fmt))
		    {
		    case XeContentClass_RASTER:
			class = xeRasterWidgetClass;
			break;
		    case XeContentClass_AUDIO:
			class = xeAudioWidgetClass;
			break;
		    case XeContentClass_VIDEO:
			class = xeVideoWidgetClass;
			break;
		    default:
			break;
		    }
	    }
	if (class)
		XtVaCreateManagedWidget
			("contentFile", class, list->content,
			 XtNcontentFile, list->name,
			 XtNcontentFormat, fmt,
			 (XtPointer)NULL);
	else if ((list->message = MamLoadMessage(list->name)) == NULL)
		DisplayError(list->content, "Cannot load: ",
			     list->name, (char *)NULL);
	else
	    {
		DisplayMessageHeader(list->content, list->message->body);
		DisplayContent(list->content, list->message,
			       BodyPartAction, (XtPointer)list,
			       DisplayMessageHeader);
		/*
		** If bodypart window is visible, put information about
		** the first part in there.
		*/
		if (XtIsManaged(list->bodypart_w))
			NextBodyPart(list->content, (XtPointer)list, 0);
	    }
	XeTextEnableDisplay(list->content);
    }

static void CloneViewerInstance(Widget, XtPointer, XtPointer);
static void DisplayListItem(ListData *, char *);
static void SelectListItem(ListData *, int);

/*
** GetEventPosition
**	returns the (x,y) coordinates from the event structure
*/
static void GetEventPosition(e, x, y)
XEvent *e;
int *x, *y;
    {
	switch (e->type)
	    {
	    case ButtonPress:
	    case ButtonRelease:
		*x = e->xbutton.x;
		*y = e->xbutton.y;
		break;
	    case KeyPress:
	    case KeyRelease:
		*x = e->xkey.x;
		*y = e->xkey.y;
		break;
	    case MotionNotify:
		*x = e->xmotion.x;
		*y = e->xmotion.y;
		break;
	    case EnterNotify:
	    case LeaveNotify:
		*x = e->xcrossing.x;
		*y = e->xcrossing.y;
		break;
	    default:
		*x = -1;
		*y = -1;
		break;
	    }
    }

/*
** ListSelect
**	is bound to folder list widgets Activate callback. The parameter
**	of the notify() action will determine what this function will
**	do as follows:
**
**	activate(SELECT)- select current message,
**	activate(SET)	- mark the message under pointer as selected
**	activate(UNSET)	- unmark any marked message
**
**	client_data is a pointer to the ListData structure.
*/
static void ListSelect(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XeActivateCallbackData *activate = (XeActivateCallbackData *)call_data;
	ListData *list = (ListData *)client_data;
	enum { UNSET, SET, SELECT } action;
	int i, x, y;
	long start, end;

	if (activate->reason != XeCR_ACTIVATE ||
	    activate->num_params == 0 || list == NULL)
		return;
	GetEventPosition(activate->event, &x, &y);
	if (x < 0 || y < 0)
		action = UNSET;
	else if (strcmp("SET", activate->params[0]) == 0)
		action = SET;
	else if (list->choice < list->count &&
		 strcmp("SELECT", activate->params[0]) == 0)
		action = SELECT;
	else
		action = UNSET;
	if (action == SET)
	    {
		/*
		** Make current choice visible
		*/
		i = (int)XeTextGetInsertionTag(w);
		if (i == list->choice && list->region > 0)
			return; /* already highlighted */
		list->choice = i;
		/* Remove all previous highlights, if any */
		for (i = 0; (i = XeTextUnsetRegion(w, i)) != 0; )
			/* Nothing */;
		start = XeTextScan(w, XeTextUnit_LINE_BEGIN, 0);
		end = XeTextScan(w, XeTextUnit_LINE_END, 0);
		list->region =
			XeTextSetRegion(w, start,end,XeTextHighlight_REVERSE);
		return;
	    }
	else if (action == UNSET)
	    {
		/*
		** Remove all choices if any
		*/
		for (i = 0; (i = XeTextUnsetRegion(w, i)) != 0; )
			/* Nothing */;
		list->region = 0;
		list->choice = 0;
		return;
	    }
	/*
	** "SELECT" and pointer is within the list window. This is the
	** command to display the currently selected item.
	*/
	XFlush(XtDisplay(w));
	XeTextGetRegionPosition(w, list->region, &start, &end);
	if (start == end)
		return;
	SelectListItem(list, list->choice);
    }

/*
** HighlightChoice
**	Highlight the current choice. This function is used when the
**	current choice is changed from the command buttons.
**	This is a bit dubious implementation, way too shaky and complex,
**	perhaps XeTextEd would need some extra functionality to make
**	this kind of operations easier.
**
**	Assume the following strategy works:
**	- set current position to the beginning,
**	- skip 'choice' number of distinct tags. This should give the
**	  virtual position at the beginning of the line that needs to
**	  be highlighted.
*/
static void HighlightChoice(list)
ListData *list;
    {
	long start, end;
	int i;

	XeTextDisableDisplay(list->self);
	for (i = 0; (i = XeTextUnsetRegion(list->self, i)) != 0; )
		/* Nothing */;
	XtVaSetValues(list->self, XtNcursorPosition, 0, (XtPointer)NULL);
	start = XeTextScan(list->self, XeTextUnit_TAG, list->choice);
	XeTextEnableDisplay(list->self); /* to get scrolling below */
	XtVaSetValues(list->self, XtNcursorPosition, start, (XtPointer)NULL);
	end = XeTextScan(list->self, XeTextUnit_LINE_END, 0);
	list->region =
		XeTextSetRegion(list->self,start,end,XeTextHighlight_REVERSE);
    }

/*
** CompareCache
**	the order is now directly determined by the name field.
*/
static int CompareCache(a, b)
void *a, *b;
    {
	return strcmp(((MamCache)a)->name, ((MamCache)b)->name);
    }
/*
** ReleaseListInformation
**	release list information structure from the ListData. If 'keep_file'
**	is True and list is currently showing a directory, the pointer
**	array for a file is not released (this is used to avoid unnecessary
**	free/alloc for the file list when wandering through directories).
**
**	(After call the ListData will be in "empty directory" state)
*/
static void ReleaseListInformation(list, keep_file)
ListData *list;
int keep_file;
    {
	int i;

	if (list->directory)
	    {
		for (i = 0; i < list->count; ++i)
			free((char *)list->list.file[i]);
		if (!keep_file)
		    {
			free((char *)list->list.file);
			list->list.file = NULL;
			list->size = 0;
		    }
	    }
	else
	    {
		if (list->list.mail)
			MamCacheFree(list->list.mail);
		list->size = 0;
		list->list.file = NULL;
		list->directory = True;
	    }
	list->count = 0;
	list->choice = -1;
    }

static void DisplayFolder(list)
ListData *list;
    {
	int n;
	/*
	** Release old list information
	*/
	ReleaseListInformation(list, False);
	list->directory = False;
	list->list.mail =
		MamCacheAccess(list->name, application.cache_name,
			       MakeCacheData, (MamCacheMode)list->cache);
	if (list->list.mail == NULL)
	    {
		DisplayError(list->content, "Failed opening folder: ",
			     list->name, (char *)NULL);
		ShuffleWindows(list, ListShow_MESSAGE);
		return;
	    }
	/* Find out how many, changed and first changed, if any */
	for (list->changed = n = 0; list->list.mail[n].name; ++n)
		if (list->list.mail[n].changed)
			list->changed += 1;
	list->count = n;
	qsort((void *)list->list.mail,n,sizeof(*list->list.mail),CompareCache);
	XeTextDisableDisplay(list->self);
	ShuffleWindows(list, ListShow_LIST);
	UpdateButtons(list);
	XtVaSetValues(list->self ,XtNcontentLoaded, False, (XtPointer)NULL);
	for (n = 0; list->list.mail[n].name; ++n)
	    {
		XeTextSetInsertionTag(list->self, (XeTextTag)n);
		XeTextInsert(list->self, list->list.mail[n].data,
			     list->list.mail[n].length);
		XeTextInsert(list->self, "\n", 1);
	    }
	XeTextEnableDisplay(list->self);
	/*
	** Display one message implicitly if there is only one message, or
	** display the first changed message, unless all messages were
	** changed (with file folders, every change in folder makes all
	** messages "changed"... not good..).
	*/
	n = 0;
	if (list->changed > 0 && list->changed < list->count)
		for (n = 0; !list->list.mail[n].changed; ++n)
			/* nothing */;
	else if (list->count != 1)
		return;	/* More than one message, leave it to user select */
	SelectListItem(list, n);
    }

/*
** Filter
**	choose files to display. Collect the list alredy here.
*/
static int Filter(name, context)
char *name;
void *context;
    {
	ListData *list = (ListData *)context;

	/* Collect all except "dot-files", with exception of ".." */

	if (name && *name && (*name != '.' || (name[1] == '.' && !name[2])))
	    {
		if (list->count == list->size)
		    {
			list->size += 500;
			if (list->list.file)
				list->list.file = (char **)XtRealloc
					((char *)list->list.file,
					 list->size * sizeof(char *));
			else
				list->list.file = (char **)XtMalloc
					(list->size * sizeof(char *));
		    }
		list->list.file[list->count] = strdup(name);
		list->count += 1;
	    }
	return 0;	/* Don't "accept" anything */
    }

static int ListCompare(s1, s2)
void *s1, *s2;
    {
	return strcmp(*(char **)s1, *(char **)s2);
    }

static void DisplayDirectory(list)
ListData *list;
    {
	MfmDirectory dir;
	int i;

	/*
	** Release for old list information, if any. If old list is
	** a plain directory, then just release the file names and
	** reuse the list
	*/
	ReleaseListInformation(list, True);
	dir = MfmOpenDirectory(list->name, Filter, (void *)list);
	while (MfmNextFile(dir) != NULL)
		/* Nothing here, just collect in Filter */;
	MfmCloseDirectory(dir);

	XeTextDisableDisplay(list->self);
	ShuffleWindows(list, ListShow_LIST);
	UpdateButtons(list);
	XtVaSetValues(list->self, XtNcontentLoaded, False, (XtPointer)NULL);
	if (list->count > 0)
	    {
		qsort((void *)list->list.file, list->count,
		      sizeof(char *), ListCompare);
		for (i = 0; i < list->count; ++i)
		    {
			XeTextSetInsertionTag(list->self, (XeTextTag)i);
			XeTextInsert(list->self, list->list.file[i],
				     strlen(list->list.file[i]));
			XeTextInsert(list->self, "\n", 1);
		    }
	    }
	XeTextEnableDisplay(list->self);
    }
/*
** DisplayListItem
**	display item from the list by name (e.g combine list and name into
**	path and display it).
**
**	The juggling with the list->name, name is very ugly and add hoc.
**	It is not very clean and nor complete (works for simple cases)
**	--msa
*/
static void DisplayListItem(list, name)
ListData *list;
char *name;
    {
	int n, m;
	char *s, *type;
	int dir;
	struct stat info;

	typedef enum
	    {
		CHOICE_NUMBER,
		TOTAL_MESSAGES,
		MESSAGE_ID,
		MAXINDEX
	    } MapIndexes;
	
	static FormatMap title_map[] =
	    {
		{'N', CHOICE_NUMBER},	/* Current index to the list */
		{'M', TOTAL_MESSAGES},	/* Total number of messages in list */
		{'T', MESSAGE_ID},	/* Currently chosen message */
		{ 0,  0},		/* Terminator */
	    };
	char *title_str[(int)MAXINDEX];
	char choice_str[10];
	char total_str[10];

	list->item_name = NULL;
	/*
	** Cleanup the the input name a bit
	*/
	for (n = strlen(name); n > 0; --n)
		if (name[n-1] == '/' && n > 1)
			continue;
		else if (name[n-1] == '.' && (n == 1 || name[n-2] == '/'))
			continue;
		else
			break;

	if (list->name == NULL || (n > 0 && *name == '/'))
		m = 0;
	else if (n == 2 && name[0] == '.' && name[1] == '.')
	    {
		/*
		** Going up to the parent directory
		*/
		m = strlen(list->name);
		if (m == 0 || (m == 1 && list->name[0] == '.') ||
		    (m > 1 &&
		     list->name[m-1] == '.' &&
		     list->name[m-2] == '.' &&
		     (m == 2 || list->name[m-3] == '/')))
		    {
			/*
			** Adding a new "/.." component to the path
			*/
			ListStack *tmp = (ListStack *)XtMalloc(sizeof(*tmp));
			*tmp = list->stack;
			list->stack.next = tmp;
		    }
		else
		    {
			/*
			** Removing one name component from the path
			*/
			while (--m > 0 && list->name[m] != '/');
			for ( ; m > 0; --m)
				if (list->name[m-1] == '/' && m > 1)
					continue;
				else if (list->name[m-1] == '.' &&
					 (m == 1 || name[m-2] == '/'))
					continue;
				else
					break;
			if (m == 0 && list->name[0] == '/')
				++m;	/* ..keep the root! */
			n = 0;
			name = "";
		    }
	    }
	else
		m = strlen(list->name);
	if (list->name_size < n + m + 3)
	    {
		list->name_size = n + m + 3;
		if (list->name == NULL)
			list->name = (char *)malloc(list->name_size);
		else
			list->name=(char *)realloc(list->name,list->name_size);
		if (list->name == NULL)
		    {
			list->name_size = 0;
			return; /* OUT OF MEMORY! */
		    }
	    }
	if (m > 0 && list->name[m-1] != '/')
		list->name[m++] = '/';
	if (n > 0)
		memcpy(&list->name[m], name, n);
	else if (m == 0)
		list->name[n++] = '.';
	list->name[m+n] = 0;
	if (stat(list->name, &info))
	    {
		/*
		** Cannot stat, assume non-directory (the item might be a
		** special construct identifying a section of a file.
		** Just let DisplayObject deal with it.
		*/
		dir = 0;
	    }
	else
		dir = (info.st_mode & S_IFMT) == S_IFDIR;
	/*
	** Going down back on some previous ".." ?
	*/
	if (dir &&
	    list->stack.next &&
	    list->stack.next->st_dev == info.st_dev &&
	    list->stack.next->st_ino == info.st_ino)
	    {
		ListStack *tmp = list->stack.next;
		
		list->stack = *tmp;
		XtFree((char *)tmp);

		assert(m > 2);
		assert(list->name[m-1] == '/');
		assert(list->name[m-2] == '.');
		assert(list->name[m-3] == '.');
		m -= 3;
		list->name[m] = 0;
		n = 0;
		name = "";
	    }
	type = MfmGetContentType(list->name);
	if (type == NULL)
		if (dir)
			DisplayDirectory(list);
		else
			DisplayObject(list);
	else
		if (strcmp(type, string_EBFileType[EB_folder]) == 0)
		    {
			DisplayFolder(list);
			dir = True;
		    }
		else if (strcmp(type, string_EBFileType[EB_message]) == 0)
		    {
			DisplayObject(list);
			dir = False;
		    }
		else if (dir)
			DisplayDirectory(list);
		else
			DisplayObject(list);
	/*
	** Build the title information
	*/
	title_str[CHOICE_NUMBER] = choice_str;
	title_str[TOTAL_MESSAGES] = total_str;
	title_str[MESSAGE_ID] = list->name;
	sprintf(choice_str, "%d", list->choice + 1);
	sprintf(total_str, "%d", list->count);

	XeTextDisableDisplay(list->title);
	XtVaSetValues(list->title, XtNcontentLoaded, False, (XtPointer)NULL);
	FormatStrings(list->title, application.title_format,
		      title_map, title_str);
	XeTextEnableDisplay(list->title);

	/*
	** Change the list->name to point current directory/folder
	*/
	s = &list->name[n + m];
	if (dir)
	    {
		list->stack.st_ino = info.st_ino;
		list->stack.st_dev = info.st_dev;
		while (s > list->name && s[-1] == '/')
			--s;
	    }
	else
	    {
		char *r = &list->name[list->name_size];

		for (*--r = 0; s > list->name; *--r = *s)
			if (*--s == '/')
				break;
		list->item_name = r;
	    }
	if (s == list->name && *s == '/')
		s++;	/* ..keep the root! */
	*s = 0;
	/*
	** Home dir is presented as empty name
	*/
	if (list->name[0] == '.' && list->name[1] == 0)
		list->name[0] = 0;
    }

/*
** ParentDirectory
**	a callback to move the 'list' up to the parent directory
*/
static void ParentDirectory(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;

	if (list == NULL)
		return;
	DisplayListItem(list, "..");
    }

/*
** SelectListItem
**	Make a specific item from the currently shown list as the
**	selected item.
*/
static void SelectListItem(ListData *list, int choice)
    {
	char *s;

	if (choice < 0 || choice >= list->count)
		return;
	if (list->choice != choice || !list->region)
	    {
		list->choice = choice;
		HighlightChoice(list);
	    }
	if (list->directory)
		s = list->list.file[list->choice];
	else
		s = list->list.mail[choice].name;
	DisplayListItem(list, s);
    }

/*
** SelectPrevious
**	item from the current list
*/
static void SelectPrevious(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	if (list != NULL)
		SelectListItem(list, list->choice - 1);
    }

/*
** SelectNext
**	item from the current list
*/
static void SelectNext(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	if (list != NULL)
		SelectListItem(list, list->choice + 1);
    }	
/*
** RescanList
**	reread the current directory list
*/
static void RescanList(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	if (list != NULL)
		DisplayListItem(list, "");
    }

/*
** ToggleCache
**	is called when the toggles change state in MamCache access panel.
**
**	call_data	should be the toggle state (on/off).
*/
static void ToggleCache(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	Boolean state = call_data != NULL;

	if (list == NULL)
		return;
	XtVaSetValues(w, XtNinvertShadow, state, (XtPointer)NULL);
	if (state)
	    {
		UI_ElementDef *toggle;
		
		XtVaGetValues(w, XtNradioData, &client_data, (XtPointer)NULL);
		toggle = (UI_ElementDef *)client_data;
		if (toggle)
			list->cache = (MamCacheMode)toggle->data;
	    }
    }

/*
** ToggleShow
**	is called when the toggles change state in the window configuration
**	panel.
**
**	call_data	should be the toggle state (on/off) (at least this
**			is true for X11R6.
*/
static void ToggleShow(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
       	Boolean state = call_data != NULL;
	UI_ElementDef *toggle;

	if (list == NULL)
		return;
	XtVaSetValues(w, XtNinvertShadow, state, (XtPointer)NULL);
	XtVaGetValues(w, XtNradioData, &client_data, (XtPointer)NULL);
	toggle = (UI_ElementDef *)client_data;
	if (!toggle)
		return;
	/*
	** Change Window configuration only on 'SET' event
	*/
	if (state)
	    {
		list->show = (ListShow)toggle->data;
		/*
		** If no list has yet been generated, then generate
		** it here (happens with cloning), otherwise just
		** shuffle windows. (The test is slightly bad, if
		** if list is just empty and keeps being empty...)
		*/
		if (list->count == 0 &&
		    (list->show == ListShow_LIST ||
		     list->show == ListShow_BOTH))
			DisplayListItem(list, "");
		else
			ShuffleWindows(list, list->show);
		UpdateButtons(list);
	    }
    }

/*
** TogglePanel
**	Manage and unmanage the control panel
*/
static void TogglePanel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	XeActivateCallbackData *data = (XeActivateCallbackData *)call_data;

	if (list == NULL || data == NULL || data->reason != XeCR_ACTIVATE)
		return;
	if (XtIsManaged(list->panel_w))
		XtUnmanageChild(list->panel_w);
	else
		XtManageChild(list->panel_w);
    }

/*
** CloseViewerInstance
**	closes a cloned display window and releases associated resources
*/
static void CloseViewerInstance(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	ListData *list = (ListData *)client_data;
	
	if (list == NULL)
		return;
	ReleaseListInformation(list, False);
	if (list->name)
	    {
		free((char *)list->name);
		list->name = NULL;
	    }
	if (list->message)
	    {
		FreeMessage(list->message);
		list->message = NULL;
		list->body = NULL;
	    }
	if (list->body_file)
	    {
		free(list->body_file);
		list->body_file = NULL;
	    }
	XtDestroyWidget(list->root);
	if (list->panel)
		XtFree((char *)list->panel);
	if (list->bodypart)
		XtFree((char *)list->bodypart);
	if (!list->main_window)
		free((char *)list);
    }

/*
** BuildViewerInstance
*/
static void BuildViewerInstance(root, list, name)
Widget root;
ListData *list;
char *name;
    {
	Widget pane, frame;

	list->root = root;
	list->directory = True;
	pane = XtVaCreateManagedWidget
		("mainWindow", xeFrameWidgetClass, root,
		 (XtPointer)NULL);
	/*
	** Create a widget for holding the current title. Make it from
	** from XeTextEd so that one can select the name too. Also,
	** make so that it toggles the menupanel on and off.
	*/
	list->title = XtVaCreateManagedWidget
		("listTitle", xeTextEdWidgetClass, pane,
		 XtNallowEdit, False,
		 (XtPointer)NULL);
	XtAddCallback
		(list->title, XtNactivateCallback,TogglePanel,(XtPointer)list);
	/*
	** Create the control menu panel
	*/
	list->panel = (UI_ElementDef *)XtMalloc(sizeof(menu_panel));
	memcpy((char *)list->panel,(char *)menu_panel, sizeof(menu_panel));
	if (!list->main_window)
	    {
		list->panel[Panel_CLOSE].label = application.label_close;
		list->panel[Panel_CLOSE].callback = CloseViewerInstance;
	    }
	list->panel_w = UI_CreateElementPanel
		(pane, panel_name, list->panel, (XtPointer)list);
	/*
	** Set MamCache_SCAN as a default
	*/
	SetToggleConfiguration(&list->panel[Panel_ACCESS], 3,
			       (XtArgVal)MamCache_SCAN);
	frame = XtVaCreateManagedWidget
		("workArea", xeFrameWidgetClass, pane, (XtPointer)NULL);
	list->list_w = XtVaCreateManagedWidget
		("listView", viewportWidgetClass, frame,
		 XtNallowHoriz, True,
		 XtNallowVert, True,
		 (XtPointer)NULL);
	XtVaGetValues(list->list_w,
		      XtNhorizontal, &list->list_horizontal,
		      XtNvertical, &list->list_vertical,
		      (XtPointer)NULL);
	list->self = XtVaCreateManagedWidget
		("listContent",xeTextEdWidgetClass, list->list_w,
		 XtNallowEdit, False,
		 XtNdisplayCaret, False,
		 (XtPointer)NULL);
	XtAddCallback
		(list->self, XtNnotifyCallback, WindowScroll, (XtPointer)list);
	XtAddCallback
		(list->self, XtNactivateCallback, ListSelect, (XtPointer)list);
	/*
	** Create body part control panel (unmanaged)
	*/
	list->bodypart = (UI_ElementDef *)XtMalloc(sizeof(body_panel));
	memcpy((char *)list->bodypart,(char *)body_panel, sizeof(body_panel));
	list->bodypart_w = UI_CreateElementPanel
		(frame, panel_name, list->bodypart, (XtPointer)list);
	XtUnmanageChild(list->bodypart_w);

	list->content_w = XtVaCreateManagedWidget
		("messageView", viewportWidgetClass, frame,
		 XtNallowHoriz, True,
		 XtNallowVert, True,
		 (XtPointer)NULL);
	XtVaGetValues(list->content_w,
		      XtNhorizontal, &list->content_horizontal,
		      XtNvertical, &list->content_vertical,
		      (XtPointer)NULL);
	list->content = XtVaCreateManagedWidget
		("messageContent", xeTextEdWidgetClass, list->content_w,
		 (XtPointer)NULL);
	XtAddCallback(list->content, XtNnotifyCallback,
		      WindowScroll, (XtPointer)list);
	XtAddCallback(list->content, XtNactivateCallback,
		      BodyPartAction, (XtPointer)list);
	DisplayListItem(list, name);
    }

/*
** CloneViewerInstance
**	build another viewer instance that is a copy of the current.
**	(client_data must be a poiner to the ListData identifying the
**	instance to be cloned.
*/
static void CloneViewerInstance(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	static ListData init_ListData;

	ListData *list = (ListData *)client_data, *clone;
	Widget root;
	char buf[500], *s;
	int n;

	if (list == NULL || !list->root)
		return;
	clone = (ListData *)malloc(sizeof(*clone));
	if (clone == NULL)
		return;
	*clone = init_ListData;
	root = XtAppCreateShell
		((char *)NULL,	/* application name */
		 application_class,
		 applicationShellWidgetClass,
		 XtDisplay(list->root),
		 (ArgList)NULL, (Cardinal)0);
	n = 0;
	if ((s = list->name) != NULL)
		while (*s && n < sizeof(buf)-1)
			buf[n++] = *s++;
	clone->choice = -1;
	clone->view_only = list->view_only;
	if ((s = list->item_name) != NULL)
	    {
		if (n > 0 && n < sizeof(buf)-1)
			buf[n++] = '/';
		while (*s && n < sizeof(buf)-1)
			buf[n++] = *s++;
	    }
	buf[n] = 0;
	BuildViewerInstance(root, clone, buf);
	XtRealizeWidget(root);
    }

/*
** ExtraViewerInstance
**	build another viewer instance parallel to the main.
*/
static void ExtraViewerInstance(list, path)
ListData *list;
char *path;
    {
	static ListData init_ListData;

	ListData *clone;
	Widget root;

	if (list == NULL || !list->root)
		return;
	clone = (ListData *)malloc(sizeof(*clone));
	if (clone == NULL)
		return;
	*clone = init_ListData;
	root = XtAppCreateShell
		((char *)NULL,	/* application name */
		 application_class,
		 applicationShellWidgetClass,
		 XtDisplay(list->root),
		 (ArgList)NULL, (Cardinal)0);
	clone->choice = -1;
	clone->view_only = list->view_only;
	BuildViewerInstance(root, clone, path);
	XtRealizeWidget(root);
    }

#include "fallback.c"

int main(argc, argv)
int argc; char *argv[];
    {
	static ListData init_ListData;

	XtAppContext demo_application;
	Widget root_widget;
	ListData list;
	int i;

	list = init_ListData;
	root_widget = XtAppInitialize
		(&demo_application,	/* appl context */
		 application_class,
		 NULL, 0,		/* cmdline options, num_options */
		 &argc, argv,		/* argc_in_out, argv_in_out */
		 fallback_resources,	/* fall back res. */
		 NULL, 0);
	XtGetApplicationResources
		(root_widget, (XtPointer)&application,
		 resources, XtNumber(resources),
		 NULL, 0);
	menu_panel[Panel_CLOSE].label = application.label_quit;
	menu_panel[Panel_CLONE].label = application.label_clone;
	menu_panel[Panel_BOTH].label = application.label_show_both;
	menu_panel[Panel_MESSAGE].label = application.label_show_message;
	menu_panel[Panel_LIST].label = application.label_show_list;
	menu_panel[Panel_BODY].label = application.label_show_body;
	menu_panel[Panel_PARENT].label = application.label_parent;
	menu_panel[Panel_PREVIOUS].label = application.label_previous;
	menu_panel[Panel_NEXT].label = application.label_next;
	menu_panel[Panel_RESCAN].label = application.label_rescan;
	menu_panel[Panel_ACCESS].label = application.label_access;
	menu_panel[Panel_SCAN].label = application.label_scan;
	menu_panel[Panel_UPDATE].label = application.label_update;
	menu_panel[Panel_LOGO].label = application.label_logo;

	body_panel[BodyPart_FILE].label = application.label_body_file;
	body_panel[BodyPart_MAILCAP].label = application.label_body_mailcap;
	body_panel[BodyPart_PREVIOUS].label = application.label_body_previous;
	body_panel[BodyPart_NEXT].label = application.label_body_next;
	body_panel[BodyPart_COLLAPS].label = application.label_body_collaps;
	body_panel[BodyPart_EXPAND].label = application.label_body_expand;
	body_panel[BodyPart_DECODE].label = application.label_body_decode;
	body_panel[BodyPart_RAW].label = application.label_body_raw;

	viewer_panel[Viewer_CLOSE].label = application.label_viewer_close;

	UI_library_search_path = application.library_path;

	UI_Initialize(demo_application);

	list.main_window = True;
	list.choice = -1;
	BuildViewerInstance(root_widget, &list, argc > 1 ? argv[1] : ".");
	XtRealizeWidget(root_widget);
	for (i = 2; i < argc; ++i)
		ExtraViewerInstance(&list, argv[i]);
	XtAppMainLoop(demo_application);
	return 0;
    }
