/*
** mfmtest.c
**	Simple test program for Mfm.
*/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "Mfm.h"

extern int sys_nerr;
extern char *sys_errlist[];

int main(int argc, char *argv[])
    {
	int n = 0, put = 0, result;
	char *t, *type = NULL;

	if (argc < 2)
	    {
		printf("Usage: mfmtest [(-set | -put) newtype] filename(s)\n");
		exit(1);
	    }
	while (++n < argc)
	    {
		if (strcmp(argv[n], "-set") == 0)
		    {
			if (++n == argc)
				break;
			put = 0;
			type = argv[n];
			continue;
		    }
		if (strcmp(argv[n], "-put") == 0)
		    {
			if (++n == argc)
				break;
			put = 1;
			type = argv[n];
			continue;
		    }
		if (type)
		    {
			result =
				(*(put?MfmPutContentType:MfmSetContentType))
					(argv[n], type);
			if (result < 0 || result >= sys_nerr)
				printf("MfmError=%d\n", result);
			else if (result > 0)
				printf("MfmError: %s\n", sys_errlist[result]);
		    }
		t = MfmGetContentType(argv[n]);
		printf("%s %s\n", argv[n], t ? t : "-untyped-");
	    }
	exit(0);
    }

