#ifndef typedefs_h
#define typedefs_h
/*
        typedefs.h --- Steven Hand [created 1/11/92]
*/

/* First of all have the 'simple' typedefs and defines... */

#define Msg_No_State		0x0000
#define Msg_New				0x0001
#define Msg_Read			0x0002
#define Msg_Draft			0x0004
#define Msg_Modified		0x0008
#define Msg_Tagged			0x0010
#define Msg_Awaiting_Reply  0x0020
#define Msg_Sent			0x0040
#define Msg_Received	    0x0080
#define Msg_Forwarded	    0x0100
#define Msg_Replied_To	    0x0200
#define Msg_To_Be_Deleted   0x0400
#define Msg_To_Be_Moved	    0x0800
#define Msg_To_Be_Copied	0x1000
#define Msg_Is_Archived	    0x2000
#define Msg_Is_Template	    0x4000

typedef unsigned MsgState;

typedef char *MsgTag;
typedef char *MsgID;
typedef char *BodyPartID;
typedef char *ORName;
typedef ORName Recipient;
typedef ORName Originator;
typedef unsigned char Byte;


/* Now have enumerated typedefs....  */

#include "tables.h"

typedef enum {
	Comp_New,
	Comp_Forward,
	Comp_Reply,
	Comp_Use
} CompType;

typedef enum {
	Bdry_Error,
	Bdry_None,
	Bdry_End_Of_File,
	Bdry_End_Of_BodyPart,
	Bdry_End_Of_BodyPart_List
} BdryVal;


/* And finally, the data structures */

#define MessageSize sizeof(struct _Message)
typedef struct _Message {
	char *name;
	char *folder;
	MsgState state;
	MsgTag tag;
	struct _MsgBody *body;
} MessageRec, *Message;

#define MsgHeaderSize sizeof(struct _MsgHeader)
typedef struct _MsgHeader {
	char *date;
	MsgID id;
	Originator from;
	Originator sender;
	Recipient *to;
	char *subject;
	char *comments;
	char *keywords;
	Recipient *cc;
	Recipient *bcc;
	MsgID in_reply_to;
	MsgID *obsoletes;
	MsgID *related_to;
	Recipient *reply_to;
	struct tm *expires_at;
	struct tm *reply_by;
	Importance importance;
	Sensitivity sensitivity;
	char **unknownfields;
} *MsgHeader;

#define MsgBodySize sizeof(struct _MsgBody)
typedef struct _MsgBody {
	struct _MsgBody *next;
	struct _MsgBody *parent;
	struct _MsgBody *child;
	struct _MsgHeader *header;
	BodyPartID id;
	ContType type;		 /* e.g. CT_image */
	SubType subtype;	 /* e.g. ST_unknown (but mfm says its 'x-IslandPaint') */
	ContType transfer_type;	 /* e.g. CT_image */
	SubType transfer_subtype; /* e.g. ST_tiff (so emmasend will convert to tiff during build */
	Encoding encoding;
	Charset charset;
	char *description;
	char **params;
	struct _BodyContent *content;
} *MsgBody;


#define BodyContentSize sizeof(struct _BodyContent)
typedef struct _BodyContent {
	long start_offset;
	long length;
	char *filename;
} *BodyContent;


#define MsgListSize sizeof(struct _MsgList)
typedef struct _MsgList {
	struct _MsgListEntry *first;
	struct _MsgListEntry *current;
} MsgList;


#define MsgListEntrySize sizeof(struct _MsgListEntry)
typedef struct _MsgListEntry {
	Message msg;
	int selected;
	struct _MsgListEntry *previous;
	struct _MsgListEntry *next;
} MsgListEntry;

#endif
