#ifndef COMMON_H
#define COMMON_H
/*
** common.h
**	This file collects the inclusion of the system headers used.
**	This is private to the implementation and should never be
**	included to the applications using Mam/Mfm.
**
** Copyright 1995 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <errno.h>
#include <setjmp.h>

#if SYSV_INCLUDES
#	include <memory.h>
#	include <malloc.h>
#	include <sys/time.h>
extern long atol();
extern int atoi();
extern char *getenv();
#else
#if ANSI_INCLUDES
#	include <stdlib.h>
#	include <stddef.h>
#	include <time.h>
#else
/*
** Neither ANSI nor SYSV defined, just throw in some guesses
*/
#	include <sys/time.h>
extern long atol();
extern int atoi();
extern char *malloc();
extern void free();
extern char *getenv();
#endif
#endif

#include <sys/stat.h>
#include <pwd.h>

#define ElementsOf(x)	(sizeof(x)/sizeof(x[0]))

#ifndef offsetof
#	define offsetof(t,m) ((char *)(&((t *)0)->m) - (char *)0)
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#endif
