." $Id: Frame.man,v 1.2 1998/12/16 03:21:49 falk Exp $
." view with "tbl | nroff -man"
."
.TH "Frame" 3 "December 1998" "Version 1.0" ""
.SH NAME
Frame
.SH DESCRIPTION
The Frame widget manages one child widget, placing a decorative border
around it.  An optional title may also be specified, which appears along
the top of the frame.

.SH CLASS
Core => Compound => Frame

Frame does not require any specific widget set, and may be combined with
any other widget set.

.SH RESOURCES

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Frame
Name	Class	Type	Default
=
shadowType	ShadowType	ShadowType	solid
shadowWidth	ShadowWidth	Dimension	2
foreground	Foreground	Pixel	XtDefaultForeground
title	Title	Widget	NULL
justify	Justify	XtJustify	left
marginWidth	Margin	Dimension	0
marginHeight	Margin	Dimension	0
allowResize	AllowResize	Boolean	True

beNiceToColormap	BeNiceToColormap	Boolean	False
topShadowContrast	TopShadowContrast	int	20
bottomShadowContrast	BottomShadowContrast	int	40
.TE
.ps +2

.LP
See the \fBCore\fP and \fBComposite\fP widgets for more resources.

.SS Descriptions.

.TP
.I ShadowType

.ps -2
.TS
box;
cBs
cB|cB
l|c.
Shadow Types
Type	Best width
=
Blank
Raised	1 or 2
Lowered	1 or 2
Ridge	2 or 4
Groove	2 or 4
Plateau	6
Trough	6
.TE
.ps +2

.IP
For Motif compatibility, alternate names for ShadowType may specified.

.ps -2
.TS
box;
cBs
cB|cB
l|l.
Shadow Types
Alternate	Type
=
none	blank
shadow_out	raised
shadow_in	lowered
shadow_etched_out	ridge
shadow_etched_in	groove
.TE
.ps +2

.TP
.I ShadowWidth
Width of decorative border.  For
.B Raised
and
.B Groove
types, this should be an even number.  For 
.B Trough
and
.B Plateau
types, this should be six or more.

.TP
.I Foreground
Specifies the color used for the border (if solid.)

.TP
.I Title
Specifies the widget to be used as the frame title.  This must be
one of the Frame's child widgets.  Typically, some sort of label
widget is used here.

.TP
.I Justify
Controls justification of the title.  One of
.B left, right, centered.

.TP
.I marginWidth, marginHeight
Specifies the margins around the frame's child.

.TP
.I AllowResize
If True, the frame widget will honor all child resize requests to
the extent possible.  If False, the frame widget will refuse all child
resize requests.

.TP
.I BeNiceToColormap
Boolean.  When true, Frame widget allocates fewer colors for itself.

.TP
.I TopShadowContrast
The contrast used for computing the shade of the top shadow color.  0-100.

.TP
.I BottomShadowContrast
The contrast used for computing the shade of the bottom shadow color.  0-100.

.SH EXAMPLES
.LP
Adding decorative borders around other widgets which may not have
such options.
.IP
.nf
*frame.shadowType: ridge
*frame.shadowWidth: 2
*frame.Margin: 2
.fi

.LP
By setting the shadow type to blank, the Frame widget may be used to
create a margin around another widget.
.IP
.nf
*frame.shadowType: blank
*frame.shadowWidth: 0
*frame.Margin: 4
.fi
.LP
By setting the margin to 4, the shadow width to 1, and the shadow type
to Lowered, a command widget may be designated as the "default" choice.
This may be toggled on or off by changing the shadow type to blank.
.IP
.nf
*applyframe.shadowType: raised
*applyframe.shadowWidth: 1
*applyframe.Margin: 4
*applyframe.Command.label: apply

*cancelframe.shadowType: blank
*cancelframe.shadowWidth: 1
*cancelframe.Margin: 4
*cancelframe.Command.label: cancel
.fi

.LP
By setting the Title resource and using the Frame widget to enclose
another compound widget, the Frame widget may be used to label and
group together other widgets.  For best results, set the shadowWidth
to 2 and the shadowType to solid or groove.
.IP
.nf
*mainFrame.shadowType: groove
*mainFrame.shadowWidth: 2
*mainFrame.maintitle.label: Preferences

.LP
Frames may be nested for more complex effects.
.IP
.nf
*frame1.shadowType: ridge
*frame2.shadowType: ridge
*frame3.shadowType: ridge
*frame1.shadowWidth: 2
*frame2.shadowWidth: 2
*frame3.shadowWidth: 2


.SH AUTHOR
Edward Falk <falk@falconer.vip.best.com>

.SH COPYRIGHT
Copyright 1998 by Edward A. Falk.  This widget may be used freely in any
free software.  Source code is freely distributable provided that my name
is not removed from it.
