/***************************** Example **************************/
/*
 *  Test  scrollbar
 */

#include "EZ.h" 
static void hscroll_callback();
static char *label= "Scrollbar can also be used as a slider. However, it can
only be used to edit an integer variable, Current slider value is:\n ";

EZ_Widget *flabel;

main(int argc, char **argv)
{
  EZ_Widget *tt, *hscroll;

  EZ_Initialize(argc,argv,0);       /* initialize EZWGL    */

  tt = EZ_CreateFrame(NULL, NULL);
  EZ_ConfigureWidget(tt,  EZ_ORIENTATION, EZ_VERTICAL, 0);

  flabel = EZ_CreateLabel(tt, label);
  EZ_ConfigureWidget(flabel,  EZ_TEXT_LINE_LENGTH, 80,
		     EZ_LABEL_POSITION, EZ_CENTER, EZ_JUSTIFICATION, EZ_CENTER,
		     EZ_FONT_NAME, "-Adobe-Helvetica-Medium-R-Normal--*-180-*-*-*-*-*-*",
		     EZ_PROPAGATE, 0, EZ_FOREGROUND, "red", 0);
  hscroll = EZ_CreateScrollbar(tt, EZ_WIDGET_HORIZONTAL_SCROLLBAR);
  EZ_ConfigureWidget(hscroll, EZ_CALL_BACK, hscroll_callback, 0);
  EZ_UpdateScrollbar(hscroll, 210, 10, 0);  /* range = maxsize - pagesize: 0-200 */
  EZ_DisplayWidget(tt); 

  EZ_EventMainLoop();
}

static void hscroll_callback(widget) EZ_Widget *widget;
{
  int start, maxsize, pagesize;
  char str[1024];

  EZ_GetScrollbarState(widget, &maxsize, &pagesize, &start);
  sprintf(str, "%s %d", label, -start);  /* !!!! */
    
  EZ_ConfigureWidget(flabel, EZ_LABEL_STRING, str, 0);
}
/***************************** Example **************************/
