/***************************** Example **************************/
/*
 *  Test  scrollbar
 */

#include "EZ.h" 
static void motion_callback();
static void vscroll_callback();
static void hscroll_callback();
static void label_callback(EZ_Widget *button);
static char *label= "I'm a free label. My position is not assigned\
by my parent. Move me by using Button 1 press-drag-release.\
 Double click on me to make me bounce";

EZ_Widget *flabel, *frame, *hscroll, *vscroll;
main(int argc, char **argv)
{
  EZ_Widget *tmp, *tt, *tf, *bf;
  int i, j, k,m,n;

  EZ_Initialize(argc,argv,0);       /* initialize EZWGL    */
  srand(getpid());

  tt = EZ_CreateFrame(NULL, NULL);
  EZ_ConfigureWidget(tt,  EZ_ORIENTATION, EZ_VERTICAL,
		     EZ_WIDTH,400, EZ_HEIGHT, 400,
		     EZ_BACKGROUND, "bisque",
		     EZ_FILL_MODE, EZ_FILL_BOTH, 0);
  tf = EZ_CreateFrame(tt, NULL);
  EZ_ConfigureWidget(tf, EZ_EXPAND, 1,
		     EZ_PADX, 0, EZ_PADY, 0,
		     EZ_FILL_MODE, EZ_FILL_BOTH, 0);
  bf =  EZ_CreateFrame(tf, NULL);
  EZ_ConfigureWidget(bf, EZ_FILL_MODE, EZ_FILL_BOTH,
		     EZ_PADX, 0, EZ_PADY, 0,
		     EZ_BORDER_TYPE, EZ_BORDER_SUNKEN, EZ_BORDER_WIDTH, 2, 0);
  frame = EZ_CreateFrame(bf, NULL);
  vscroll = EZ_CreateScrollbar(tf, EZ_WIDGET_VERTICAL_SCROLLBAR);
  hscroll = EZ_CreateScrollbar(tt, EZ_WIDGET_HORIZONTAL_SCROLLBAR);
  EZ_ConfigureWidget(vscroll, EZ_CALL_BACK, vscroll_callback, NULL,0);
  EZ_ConfigureWidget(hscroll, EZ_CALL_BACK, hscroll_callback, NULL, 0);

  EZ_DisableImageDithering();
  flabel = tmp = EZ_CreateFreeLabel(frame, label);
  EZ_ConfigureWidget(flabel, EZ_PADX, 0, EZ_PADY, 0,
		     EZ_WIDTH_HINT, 500, EZ_HEIGHT_HINT, 500,
		     EZ_IMAGE_FILE, "greatwall.gif",0);
  EZ_ConfigureWidget(tmp, 
		     EZ_CALL_BACK, label_callback, NULL,
		     EZ_BORDER_TYPE, EZ_BORDER_RIDGE, EZ_BORDER_WIDTH, 2,
		     EZ_TEXT_LINE_LENGTH, 40,
		     EZ_FOREGROUND, "red",
		     EZ_BACKGROUND,"gray",
		     EZ_FONT_NAME,
		     "-Adobe-Times-Bold-R-Normal--*-180-*-*-*-*-*-*",
		     EZ_JUSTIFICATION, EZ_CENTER, 0);
  EZ_AddWidgetCallBack(flabel, EZ_MOTION_CALLBACK, motion_callback, NULL, 0);
  
  EZ_DisplayWidget(tt); 
  motion_callback(flabel);

  EZ_EventMainLoop();
}

static void motion_callback(widget)
     EZ_Widget *widget;
{
  int fx,fy,fw,fh,w,h, reconfig = 0;

  EZ_GetWidgetDimension(frame, &w, &h);
  EZ_GetWidgetGeometry(flabel, &fx, &fy, &fw,&fh);
  if(fx < w - fw) { reconfig = 1; fx = w-fw;}
  if(fx > 0) {reconfig = 1; fx = 0; }

  if(fy < h - fh) { reconfig = 1; fy = h-fh;}
  if(fy > 0) {fy = 0; reconfig = 1; }

  EZ_UpdateScrollbar(hscroll, fw, w, fx);
  EZ_UpdateScrollbar(vscroll, fh, h, fy);
  if(reconfig && widget) EZ_ConfigureWidget(widget, EZ_X, fx, EZ_Y, fy, 0);
}
static void vscroll_callback(widget) EZ_Widget *widget;
{
  int start, maxsize, pagesize;
  int w,h;
  
  EZ_GetWidgetDimension(frame, &w, &h);
  EZ_GetScrollbarState(widget, &maxsize, &pagesize, &start);
  if(pagesize != h)
    {
      int fx,fy,fw,fh,reconfig = 0;
      EZ_GetWidgetGeometry(flabel, &fx, &fy, &fw,&fh);
      EZ_UpdateScrollbar(vscroll, fh, h, 0);
      EZ_ConfigureWidget(flabel, EZ_Y, 0, 0);
      EZ_GetScrollbarState(widget, &maxsize, &pagesize, &start);
    }
  EZ_ConfigureWidget(flabel, EZ_Y, start, 0);
}
static void hscroll_callback(widget) EZ_Widget *widget;
{
  int start, maxsize, pagesize;
  int w,h;

  EZ_GetWidgetDimension(frame, &w, &h);
  EZ_GetScrollbarState(widget, &maxsize, &pagesize, &start);
  if(pagesize != w)
    {
      int fx,fy,fw,fh,reconfig = 0;
      EZ_GetWidgetGeometry(flabel, &fx, &fy, &fw,&fh);
      EZ_UpdateScrollbar(hscroll, fw, w, 0);
      EZ_ConfigureWidget(flabel, EZ_X, 0, 0);
      EZ_GetScrollbarState(widget, &maxsize, &pagesize, &start);
    }
  EZ_ConfigureWidget(flabel, EZ_X, start, 0);
}
static void label_callback(EZ_Widget *widget)
{
  int i, x, y, h, H, speed = 0;

  EZ_GetWidgetPosition(widget, &x,&y);
  h = EZ_GetWidgetHeight(widget);
  H = EZ_GetWidgetHeight(frame) -2;

  for(i = y; i <= H - h; i += speed, speed++)
    EZ_ConfigureWidget(widget, EZ_X,x, EZ_Y, i, 0);
  speed++;
  for(; i > y; i -= speed, speed--)
    EZ_ConfigureWidget(widget, EZ_X,x, EZ_Y, i, 0);
}
/***************************** Example **************************/
