/****************************************************************
 ***                                                          ***
 ***     notebook.c                                           ***
 ***          NoteBook widget demo                            ***
 ***                                                          ***
 ***************************************************************/
#include "EZ.h"
#include <X11/bitmaps/flagup>
#include "dog3.xpm"

void my_exit();
/*************************************************************************/
static void make_button_box();
static void make_check_button_box();
static void make_a_text_widget();
static void make_author_info_widget();
static void tswap();
/*************************************************************************/
EZ_Widget *notebook, *page[4];
main(ac, av)
     int ac; char **av;
{
  EZ_Widget *frame, *tmp;
  int       i;
  char      str[160];

  EZ_Initialize(ac,av,1);
  
  /* create a toplevel frame */
  frame = EZ_CreateFrame(NULL, NULL);
  EZ_ConfigureWidget(frame, EZ_FILL_MODE, EZ_FILL_BOTH, 0);

  /* create a notebook widget */
  /* and create 4 pages in it */
  notebook = EZ_CreateNoteBook(frame);
  EZ_ConfigureWidget(notebook, EZ_FILL_MODE, EZ_FILL_BOTH,
		     EZ_BORDER_TYPE, EZ_BORDER_UP,
		     EZ_BORDER_WIDTH, 2,
		     EZ_PADX, 10, EZ_PADY, 20,
		     EZ_IPADX, 10, EZ_IPADY, 10, 0);
  page[0] = EZ_CreateNoteBookPage(notebook, "Buttons", 0);
  EZ_ConfigureWidget(page[0], EZ_EXPAND, 1, EZ_BORDER_WIDTH, 2, 0);
  page[1] = EZ_CreateNoteBookPage(notebook, NULL,-1);
  {
    EZ_Widget *tmp = EZ_GetNoteBookPageTab(page[1]);
    if(tmp)
      {
	EZ_Widget *a = EZ_CreateNWLabel(tmp,NULL);
	EZ_ConfigureWidget(a,EZ_BITMAP_FILE, "earth.xpm",0);
	a = EZ_CreateNWLabel(tmp,"This is a test");
      }
  }
    
  EZ_ConfigureWidget(page[1], EZ_EXPAND, 1, EZ_BORDER_WIDTH, 4,
		     EZ_FOREGROUND, "Red", EZ_BACKGROUND, "#007f6f",
		     EZ_FONT_NAME,  "-Adobe-Times-Bold-R-Normal--*-120-*-*-*-*-*-*",
		     0);
  page[2] = EZ_CreateNoteBookPage(notebook, "TextWidget",3);
  EZ_ConfigureWidget(page[2],EZ_BACKGROUND, "bisque2",
		     EZ_FILL_MODE, EZ_FILL_BOTH,
		     EZ_PIXMAP_DATA, dog_xpm, 0); /* a pixmap label */
  page[3] = EZ_CreateNoteBookPage(notebook, "Author", 5);
  
  /* now create a few things in page[1-4] */

  make_button_box(page[0]);
  make_check_button_box(page[1]);
  make_a_text_widget(page[2]);
  make_author_info_widget(page[3]);

  EZ_DisplayWidget(frame);
  EZ_EventMainLoop();
}
/**********************************************************************
 *
 *  Make a button box.
 */
static void get_out();

static void make_button_box(parent)
     EZ_Widget *parent;
{
  EZ_Widget *frame, *tmp;

  frame = EZ_CreateFrame(parent,"buttons");     /* a frame to hold five widgets    */
  EZ_ConfigureWidget(frame, 
		     EZ_STACKING, EZ_VERTICAL,  /* children are stacked vertically */
		     0);
  tmp = EZ_CreateButton(frame, "A Normal Button",0);              /* two buttons */
  tmp = EZ_CreateButton(frame, "Colored Button",0);
  EZ_ConfigureWidget(tmp, EZ_FOREGROUND, "#ffff00",    /* bg and fg colors       */
		     EZ_CALLBACK, tswap, NULL,
		     EZ_BACKGROUND, "#008f8f", 0);
  tmp = EZ_CreateButton(frame, "Quit",0);              /* a real quit button     */
  EZ_SetWidgetCallBack(tmp,get_out, NULL);

  frame = EZ_CreateFrame(parent,NULL);         /* another frame to hold a bitmap*/
  EZ_ConfigureWidget(frame,                    /* button and an image button    */
		     EZ_STACKING, EZ_VERTICAL, 
		     0);
  tmp = EZ_CreateLabel(frame,"Bitmap and Image labeled buttons");  /* label first       */
  EZ_ConfigureWidget(tmp,EZ_TEXT_LINE_LENGTH, 20, 0);
  tmp = EZ_CreateButton(frame, "Bitmap Button",-1);           
  EZ_ConfigureWidget(tmp, EZ_BITMAP_FILE, "xterm-sun.xpm",
		     EZ_EXPAND,True, 0);   /* let it expands to fit it parent'W */
  tmp = EZ_CreateButton(frame, "Image Button",1);
  EZ_ConfigureWidget(tmp, EZ_IMAGE_FILE,"cat.ppm",
		     EZ_PADX,0, EZ_PADY,0, /* for images, this setup looks nice */
		     EZ_BORDER_WIDTH,4,0);
}		     
static EZ_Widget *dialogue = (EZ_Widget *)NULL;
static void hide_dialogue();

static void get_out(widget, dd)
     EZ_Widget *widget; void *dd;
{
  if(dialogue == (EZ_Widget *)NULL)
    {
      EZ_Widget *tmp, *a;
      dialogue = EZ_CreateFrame(NULL, "Quit ?");
      EZ_ConfigureWidget(dialogue,EZ_STACKING, EZ_VERTICAL, EZ_TRANSIENT, 1, 0);
      tmp = EZ_CreateLabel(dialogue,"Are you sure you want to quit?");
      a = EZ_CreateFrame(dialogue, NULL);
      EZ_ConfigureWidget(a,EZ_IPADX, 20,0);
      tmp = EZ_CreateButton(a,"Yes",0);
      EZ_SetWidgetCallBack(tmp,my_exit, NULL);
      tmp = EZ_CreateButton(a,"No",0);
      EZ_SetWidgetCallBack(tmp, hide_dialogue, NULL);      
    }
  EZ_DisplayWidget(dialogue);
}
static void hide_dialogue(widget, dd)
     EZ_Widget *widget; void *dd;
{
  EZ_HideWidget(dialogue);
}

/**********************************************************************
 *
 *   Create a check button box.
 */
static void make_check_button_box(parent)
     EZ_Widget *parent;
{
  EZ_Widget *check, *tmp;
  int       i;
  char      str[256];

  check = EZ_CreateFrame(parent, "check buttons");  /* a labeled frame    */
  EZ_ConfigureWidget(check,  EZ_STACKING, EZ_VERTICAL,  0);  
  for(i = 0; i < 5; i++)
    {
      sprintf(str, "Check Button %d",i);
      tmp = EZ_CreateCheckButton(check, str, (i == 0) ? 0: -1,  
				 i+1, (10+i*i), (i == 1)? 1: 0);
    }
}

static void make_a_text_widget(parent)
     EZ_Widget *parent;
{
  EZ_Widget *textW;

  textW = EZ_CreateTextWidget(parent, 1,1,1);     /* the text widget  */
  EZ_TextLoadAnnotatedFile(textW,"text.txt");
}
/***********************************************************************
 *
 *  A frame displying info about the author
 */
static char author_info[] ="Maorong Zou\n\
Department of Mathematics\n\
The University of Texas at Austin\n\
Austin, TX 78712\n\n\
email:  mzou@ma.utexas.edu\n\
        zou@math.arizona.edu";

static void make_author_info_widget(parent)
     EZ_Widget *parent;
{
  EZ_Widget *author, *tmp;
  author = EZ_CreateFrame(parent,          /* a frame with title. Title will be used */
			  "Author info");  /* as the window title when mapped        */
  EZ_ConfigureWidget(author,               /* again, stack its children vertically   */
		     EZ_STACKING, EZ_VERTICAL, 0);

  tmp = EZ_CreateLabel(author,"A Photo");   /* label string will not be used if      */
  EZ_ConfigureWidget(tmp,EZ_IMAGE_FILE,          /* image file is found                   */
		     "author.gif", 0);
  tmp = EZ_CreateLabel(author,author_info); /* label to display address              */
  EZ_ConfigureWidget(tmp,                   /* beat the default line breaks          */
		     EZ_TEXT_LINE_LENGTH,50, 
		     0);
}
static void tswap(widget, dd)
     EZ_Widget *widget, *dd;
{
  EZ_ActivateNoteBookPage(page[2]);
}

void my_exit(ww,dd) EZ_Widget *ww, *dd;
{
  EZ_Shutdown();
  exit(0);
}
