/****************************************************************
 ***                                                          ***
 ***     entry.c                                              ***
 ***                                                          ***
 ***************************************************************/

#include "EZ.h"

static EZ_Widget *label, *entries[3];

static void entry_motioncallback(widget, ddd)
     EZ_Widget *widget; void *ddd;
{
  printf("%lx ==> %s\n",widget, EZ_GetEntryString(widget));
}


static void entry_callback(widget, ddd)
     EZ_Widget *widget; void *ddd;
{
  char   str[512], *back, *fore, *font;

  back = EZ_GetEntryString(entries[0]);
  fore = EZ_GetEntryString(entries[1]);
  font = EZ_GetEntryString(entries[2]);


  if(widget == entries[0]) EZ_SetFocusTo(entries[1]);
  else if(widget == entries[1]) EZ_SetFocusTo(entries[2]);
  else EZ_SetFocusTo(entries[0]);

  sprintf(str, "Background: %s\nForeground: %s\nFont: %s",
	  back, fore, font);
  EZ_ConfigureWidget(label, EZ_LABEL_STRING, str, 
		     EZ_BACKGROUND, back,
		     EZ_FOREGROUND, fore,
		     EZ_FONT_NAME, font, 0);
} 
void my_exit(ww,dd) EZ_Widget *ww; void *dd;
{
  EZ_Shutdown();
  exit(0);
}
/**************************************************************************/

static EZ_Widget *create_entry_box(parent, label_string)
     EZ_Widget *parent;
     char      *label_string;
{
  EZ_Widget *toplevel, *frame, *frame1, *tmp;
  toplevel = EZ_CreateFrame(NULL,NULL);
  EZ_ConfigureWidget(toplevel,  EZ_STACKING, EZ_VERTICAL, 0);

  label = EZ_CreateButton(toplevel, "Entry Widget", 0);
  EZ_ConfigureWidget(label, EZ_HEIGHT, 200,
		     EZ_CALL_BACK, my_exit, NULL,
		     EZ_TEXT_LINE_LENGTH, 80, 0);

  /*
   *  A frame contains three frames, each contains
   *  a label and an entry. 
   */
  frame = EZ_CreateFrame(toplevel, NULL);
  EZ_ConfigureWidget(frame,  
		     EZ_STACKING, EZ_VERTICAL,
		     EZ_SIDE, EZ_RIGHT, 0);

  frame1 = EZ_CreateFrame(frame,NULL);
  EZ_ConfigureWidget(frame1,  EZ_STACKING, EZ_HORIZONTAL_RIGHT, 0);
  tmp = EZ_CreateLabel(frame1, "Background Color:");
  entries[0] = tmp = EZ_CreateEntry(frame1, NULL);
  EZ_SetWidgetCallBack(tmp, entry_callback, NULL);
  EZ_AddWidgetCallBack(tmp, EZ_MOTION_CALLBACK,entry_motioncallback, NULL, 0);

  frame1 = EZ_CreateFrame(frame,NULL);
  EZ_ConfigureWidget(frame1,  EZ_STACKING, EZ_HORIZONTAL_RIGHT, 0);
  tmp = EZ_CreateLabel(frame1, "Foreground Color:");
  entries[1] = tmp = EZ_CreateEntry(frame1, "black");
  EZ_OnOffSecretEntry(tmp, 1);
  EZ_ConfigureWidget(tmp,EZ_SELECTION_BACKGROUND, "#00afaf",0);
  EZ_SetWidgetCallBack(tmp, entry_callback, NULL);
  EZ_AddWidgetCallBack(tmp, EZ_MOTION_CALLBACK,entry_motioncallback, NULL, 0);

  frame1 = EZ_CreateFrame(frame,NULL);
  EZ_ConfigureWidget(frame1,  EZ_STACKING, EZ_HORIZONTAL_RIGHT, 0);
  tmp = EZ_CreateLabel(frame1, "Font:");
  entries[2] = tmp = EZ_CreateEntry(frame1, 
				    "-Adobe-Times-Bold-R-Normal--*-120-*-*-*-*-*-*");
  EZ_SetWidgetCallBack(tmp, entry_callback, NULL);

  return(toplevel);
}
/************************************************************************/
#ifdef EZ_MAIN
main(ac,av) int ac; char **av;
{
  EZ_Initialize(ac,av,1);
  EZ_DisplayWidget(create_entry_box(NULL, NULL));
  EZ_EventMainLoop();
}
#endif



