/****************************************************************
 ***                                                          ***
 ***     menu.c                                               ***
 ***          popup and pulldown menus                        ***
 ***                                                          ***
 ***************************************************************/
#include "EZ.h"

/*************************************************************************/
static char *colors[] = {
  "Bubble On",
  "Bubble Off",
  "blue",
  "yellow",
  "cyan",
  "magenta",
  "white",
  "grey62",
};
#define REDC     0
#define GREENC   1
#define BLUEC    2
#define YELLOWC  3
#define CYANC    4
#define MAGENTAC 5
#define WHITEC   6
#define GRAYC    7

static char msg[] = "Push a button to change the\n\
foreground or background color of this label.";

static EZ_Widget *label;
/************************************************************************
 *
 *  Button call backs
 */
static void button_callbackF(widget,d)
     EZ_Widget *widget; void *d;
{
  char *str = (char *) EZ_GetWidgetPtrData(widget);
  EZ_ConfigureWidget(label, EZ_FOREGROUND, str, 0);
  if(!strcmp(str,"Bubble Off")) 
    EZ_TurnOffBubbleHelp();
  else   if(!strcmp(str,"Bubble On")) 
    EZ_TurnOnBubbleHelp();
}    
static void button_callbackB(widget,d)
     EZ_Widget *widget; void *d;
{
  char *str = (char *) EZ_GetWidgetPtrData(widget);
  EZ_ConfigureWidget(label, EZ_BACKGROUND, str, 0);
}    
/**************************************************************************/

static EZ_Widget *create_normal_button_box(parent,label_str)
     EZ_Widget *parent; 
     char      *label_str;
{
  EZ_Widget *frame1, *frame2, *tmp;
  int       i;

  frame1 = EZ_CreateFrame(NULL,NULL);

  EZ_ConfigureWidget(frame1,  EZ_STACKING, EZ_VERTICAL, EZ_WIDTH,0, EZ_HEIGHT,0, 0);
  
  label = EZ_CreateLabel(frame1, msg);
  EZ_ConfigureWidget(label, EZ_FONT_NAME, 
		      "-Adobe-Times-Bold-R-Normal--*-180-*-*-*-*-*-*",  0);
  frame2 = EZ_CreateFrame(frame1, NULL);
  EZ_ConfigureWidget(frame2, EZ_IPADX, 6, 0);  
  tmp = EZ_CreateButton(frame2, "Bitmap Label", 0);
  EZ_SetWidgetPtrData(tmp,colors[GRAYC]);  
  EZ_ConfigureWidget(tmp, EZ_BITMAP_FILE, "flagup", EZ_CALLBACK, button_callbackB, NULL,0);
  tmp = frame2;
  for(i = REDC; i <= BLUEC; i++)  /* a stack of buttons */
    {
      tmp = EZ_CreateButton(tmp, NULL, -1);
      EZ_ConfigureWidget(tmp, EZ_BACKGROUND, colors[i],
			 EZ_CALLBACK, button_callbackB, NULL, 0);
      EZ_SetWidgetPtrData(tmp,colors[i]);
    }
  tmp = EZ_CreateButton(frame2, "Image Label", 0);
  EZ_SetWidgetPtrData(tmp,colors[WHITEC]);
  EZ_ConfigureWidget(tmp, EZ_IMAGE_FILE, "cat0.ppm", EZ_CALLBACK, button_callbackB, NULL,0);

  frame2 = EZ_CreateFrame(frame1, NULL);
  EZ_ConfigureWidget(frame2, EZ_IPADX, 6, 0);
  for(i = REDC; i <= MAGENTAC; i++)  /* a stack of buttons */
    {
      tmp = EZ_CreateButton(frame2, colors[i], 0);
      EZ_ConfigureWidget(tmp, EZ_FOREGROUND, colors[i],
			 EZ_BUBBLE_HELP, i != MAGENTAC ? colors[i]: "This is a long help",

			 EZ_CALLBACK, button_callbackF, NULL,0);
      EZ_SetWidgetPtrData(tmp,colors[i]);
    }  
  return(frame1);
}
/************************************************************************/
#ifdef  EZ_MAIN
main(ac,av)
     int ac; char **av;
{
  EZ_Initialize(ac,av,0);

  {
    EZ_Widget *bubble = EZ_GetBubbleHelp();
    EZ_ConfigureWidget(bubble, EZ_BACKGROUND, "red3", 0);
  }
/*  EZ_SetGlobalLabelFont("-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*");
  EZ_SetGlobalMenuTitleFont("-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*");
  EZ_SetGlobalEntryTextFont("-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*");
*/
  EZ_DisplayWidget(create_normal_button_box(NULL, NULL));
  EZ_EventMainLoop();
}
#endif
