/****************************************************************
 ***                                                          ***
 ***     anima.c                                              ***
 ***          test timer                                      ***
 ***                                                          ***
 ***************************************************************/
#include "EZ.h"

static EZ_Widget *label;
static int counter;
EZ_LabelPixmap *labelPixmaps[40];

static void rtimer_callback(timer, pdata)
     EZ_Timer *timer; void *pdata; 
{
  static int incr = 1;
  int idata = EZ_GetTimerIntData(timer);
  int *iptr = (int *)pdata;
  int i = *iptr + incr;

  if(i > 32) { i = 32; incr = -1; }
  if( i < 0) { i = 0; incr = 1; }
  *iptr = i;

  EZ_ConfigureWidget(label, EZ_LABEL_PIXMAP, labelPixmaps[i], 0);
}

/**************************************************************************/
void my_exit()
{
  EZ_Shutdown();
  exit(0);
}
/**************************************************************************/

main(ac,av) int ac; char **av;
{
  EZ_Widget *frame, *tmp;
  EZ_Timer  *RTimer;
  int i;

  EZ_Initialize(ac,av,1);
  frame = EZ_CreateFrame(NULL,NULL);
  EZ_ConfigureWidget(frame, EZ_ORIENTATION, EZ_VERTICAL, 0);
  label = EZ_CreateLabel(frame,NULL);
  EZ_ConfigureWidget(label,EZ_PADX,0,EZ_PADY,0, EZ_BORDER_WIDTH,3,
		     EZ_BORDER_TYPE, EZ_BORDER_DOWN,
		     EZ_PROPAGATE, 0,
		     EZ_IMAGE_FILE, "cat/100",
		     0);
  tmp = EZ_CreateButton(frame, "Quit", 0);
  EZ_SetWidgetCallBack(tmp, (EZ_CallBack)my_exit, NULL);
  EZ_DisplayWidget(frame);
  for(i = 100; i <= 132; i++)
    {
      char str[32];
      sprintf(str, "cat/%d", i);
      labelPixmaps[i-100] = EZ_CreateLabelPixmapFromImageFile(str);
      EZ_ConfigureWidget(label, EZ_LABEL_PIXMAP, labelPixmaps[i-100], 0);
    }
  RTimer = EZ_CreateTimer(0, 100000, -1, rtimer_callback, &counter, 0);
  EZ_EventMainLoop();
}
/************************************************************************/
