/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
/*****************************************************************
 ***                                                           ***
 ***              Widget RowColumn (aka GridBag)               ***
 ***                                                           ***
 *****************************************************************/
#define _EZ_WIDGET_ROWCOL_C_
#include "EZ_Widget.h"

/*********************************************************************
 * 
 *  Functions implemented in this file:
 */
EZ_Widget  *EZ_CreateRowColumn MY_ANSIARGS((EZ_Widget *parent));
EZ_Widget  *EZ_CreateGridBag MY_ANSIARGS((EZ_Widget *parent));

void             EZ_DrawWidgetRowCol MY_ANSIARGS((EZ_Widget *widget));
void             EZ_ComputeWidgetRowColSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
void             EZ_FreeWidgetRowColData MY_ANSIARGS((EZ_Widget *widget));
void             EZ_RowColEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
/*********************************************************************
 * 
 *  Local Variables.
 */
static EZ_WidgetHandle EZ_RowColHandle =
{ 
  EZ_ComputeWidgetRowColSize,
  EZ_DrawWidgetRowCol,
  EZ_FreeWidgetRowColData,
  EZ_RowColEventHandle,    /* response only to Expose */
};

/*********************************************************************/
EZ_Widget  *EZ_CreateGridBag(parent) EZ_Widget *parent;
{ return(EZ_CreateRowColumn(parent));}

EZ_Widget  *EZ_CreateRowColumn(parent)
     EZ_Widget  *parent;     /* parent widget    */
{
  EZ_Widget  *tmp;
  
  tmp = EZ_CreateNewWidget(parent);
  /*--------------------------------------------------
   * Register the handling functions for label.
   *  has to be done after  EZ_CreateNewWiget.
   *-------------------------------------------------*/
  EZ_WidgetHandlingFunctions[EZ_WIDGET_ROW_COLUMN] = &EZ_RowColHandle;

  EZ_WidgetType(tmp) = EZ_WIDGET_ROW_COLUMN;
  EZ_WidgetBorderStyle(tmp)  = EZ_BORDER_NONE;
  EZ_WidgetBorderWidth(tmp)  = 0;
  EZ_WidgetPadB(tmp) = 0;

  EZ_RCRowPtr(tmp) = NULL;   
  EZ_RCColPtr(tmp) = NULL;
  EZ_RCNRows(tmp) = 0;
  EZ_RCNCols(tmp) = 0;
  EZ_RCRowSpace(tmp) = 0;
  EZ_RCColSpace(tmp) = 0;
  EZ_RCXOffset(tmp) = 0;
  EZ_RCYOffset(tmp) = 0;
  return(tmp);
}


void   EZ_FreeWidgetRowColData(widget)
     EZ_Widget *widget;
{
  if(EZ_RCRowPtr(widget) != NULL)
    {
      (void)my_free((char *)EZ_RCRowPtr(widget));
      EZ_RCRowPtr(widget) = NULL;
    }
  if(EZ_RCColPtr(widget) != NULL)
    {
      (void)my_free((char *)EZ_RCColPtr(widget));
      EZ_RCColPtr(widget) = NULL;
    }
}
 
/********************************************************************
 *
 *  Figure out the dimension of a row-col, not much.
 */

void EZ_ComputeWidgetRowColSize(widget, w, h)
    EZ_Widget *widget;
     int             *w, *h;
{
  int cw, ch;
  EZ_SetWidgetSizeComputedFlag(widget);

  cw = EZ_WidgetPadX(widget) + EZ_WidgetBorderWidth(widget);
  ch = EZ_WidgetPadY(widget) + EZ_WidgetBorderWidth(widget);
  EZ_WidgetSepX(widget) &= ~1;
  EZ_WidgetSepY(widget) &= ~1;

  *w = cw + cw;
  *h = ch + ch;
}

/*******************************************************************
 *
 *  Draw A Row ColWidget.
 */
void  EZ_DrawWidgetRowCol(wptr)
     EZ_Widget *wptr;
{
  int       w, h,fillx,filly;
  Pixmap    pixmap;
  Window    win;
  GC        gc;
  unsigned long   bgpv;

  win = EZ_WidgetWindow(wptr);
  w   = EZ_WidgetWidth(wptr);
  h   = EZ_WidgetHeight(wptr);
  EZ_GetWidgetLabelPosition(wptr, &fillx, &filly);

  pixmap = XCreatePixmap(EZ_DisplayForWidgets, win, w, h, EZ_DepthForWidgets); 
  EZ_GetBackgroundGC(wptr, &gc, &bgpv, 0, (int)EZ_LabelAlwaysHighlight(wptr));
  XFillRectangle(EZ_DisplayForWidgets, pixmap, gc, 0,0, w, h); 

  EZ_DrawRectBorder(wptr, pixmap);     
  XCopyArea(EZ_DisplayForWidgets,pixmap,win, EZ_WRITABLEGC,0,0,w,h,0,0); 
  XFreePixmap(EZ_DisplayForWidgets, pixmap); 
}

void EZ_RowColEventHandle(widget, event)
     EZ_Widget *widget;
     XEvent *event;
{
  if(widget)
    {
      if(event->type == Expose)	EZ_DrawWidget(widget);      
    }
}
/****************************************************************************/
#undef _EZ_WIDGET_ROWCOL_C_
