/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
/*****************************************************************
 ***                                                           ***
 ***              Widget RawXWindow                            ***
 ***                                                           ***
 *****************************************************************/
#define _EZ_WIDGET_RAWXWIN_C_
#include "EZ_Widget.h"

/*********************************************************************
 * 
 *  Functions implemented in this file:
 */
EZ_Widget       *EZ_CreateRawXWindow MY_ANSIARGS((EZ_Widget *parent));
void             EZ_DrawWidgetRawXWin MY_ANSIARGS((EZ_Widget *widget));
void             EZ_ComputeWidgetRawXWinSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
void             EZ_FreeWidgetRawXWinData MY_ANSIARGS((EZ_Widget *widget));
void             EZ_RawXWinEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
/*********************************************************************
 * 
 *  Local Variables.
 */
static EZ_WidgetHandle EZ_RawXWinHandle =
{ 
  EZ_ComputeWidgetRawXWinSize,
  EZ_DrawWidgetRawXWin,
  EZ_FreeWidgetRawXWinData,
  EZ_RawXWinEventHandle, 
};

/*********************************************************************/

EZ_Widget  *EZ_CreateRawXWindow(parent)
     EZ_Widget  *parent;     /* parent widget    */
{
  EZ_Widget  *tmp;
  
  tmp = EZ_CreateNewWidget(parent);
  /*--------------------------------------------------
   * Register the handling functions for label.
   *  has to be done after  EZ_CreateNewWiget.
   *-------------------------------------------------*/
  EZ_WidgetHandlingFunctions[EZ_WIDGET_RAW_XWINDOW] = &EZ_RawXWinHandle;

  EZ_WidgetType(tmp) = EZ_WIDGET_RAW_XWINDOW;
  EZ_WidgetBorderStyle(tmp)  = EZ_BORDER_NONE;
  EZ_WidgetBorderWidth(tmp)  = 0;
  EZ_WidgetPadX(tmp) = EZ_WidgetPadY(tmp) = 0;
  EZ_WidgetSepX(tmp) = EZ_WidgetSepY(tmp) = 0;

  return(tmp);
}

void   EZ_FreeWidgetRawXWinData(widget)
     EZ_Widget *widget;
{
  if(widget) return;
}

 
/********************************************************************
 *
 *  Figure out the dimension of a label widget.
 */

void EZ_ComputeWidgetRawXWinSize(widget, w, h)
    EZ_Widget *widget;
    int             *w, *h;
{
  EZ_SetWidgetSizeComputedFlag(widget);	    

  *w = 16;
  *h = 16;
}

/*******************************************************************
 *
 *  Draw does nothing
 */
void  EZ_DrawWidgetRawXWin(wptr)
     EZ_Widget *wptr;
{
  if(wptr) return;
}

/*******************************************************************
 *
 *  Handle no events;
 */
void EZ_RawXWinEventHandle(widget, event)
     EZ_Widget *widget;
     XEvent *event;
{
  return;
}
/****************************************************************************/
#undef _EZ_WIDGET_RAWXWIN_C_
