/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
/*****************************************************************
 ***                                                           ***
 ***              Widget NW Label.                             ***
 ***                                                           ***
 *****************************************************************/
#define _EZ_WIDGET_NWLABEL_C_
#include "EZ_Widget.h"

/*********************************************************************
 * 
 *  Functions implemented in this file:
 */
EZ_Widget        *EZ_CreateNWLabel MY_ANSIARGS((EZ_Widget *parent, char *label));
EZ_Widget        *EZ_CreateNWFrame MY_ANSIARGS((EZ_Widget *parent));

void              EZ_DisplayNWLabel MY_ANSIARGS((EZ_Widget *widget,
						 Pixmap pixmap,
						 unsigned long fg, unsigned long bg,
						 int disabled, int xoff, int yoff, int laboff, 
						 int disp_sib));
/*********************************************************************
 * 
 *  Local Variables.
 */
static EZ_WidgetHandle EZ_NWLabelHandle =
{ 
  EZ_ComputeWidgetLabelSize,  /* same as a regular label */
  EZ_DrawWidgetUnknown,
  EZ_FreeWidgetLabelData, /* same as a regular label */
  EZ_UnkownEventHandle,   /* never called */
};

/*********************************************************************/
EZ_Widget  *EZ_CreateNWFrame(parent)
     EZ_Widget  *parent;           /* parent widget    */
{
  EZ_Widget *tmp = EZ_CreateNWLabel(parent, NULL);
  if(tmp) EZ_IsNWFrame(tmp) = 1;
  
  return(tmp);
}
/*********************************************************************/

EZ_Widget  *EZ_CreateNWLabel(parent,label)
     EZ_Widget  *parent;           /* parent widget    */
     char             *label;      /* label string     */
{
  EZ_Widget  *tmp;

  if(parent == (EZ_Widget *)NULL)  /* cannot be a standalone widget */
    return(NULL);
  
  tmp = EZ_CreateLabel(parent,label);
  EZ_WidgetHandlingFunctions[EZ_WIDGET_NW_LABEL] = &EZ_NWLabelHandle;
  EZ_WidgetPadX(tmp)    = 0;
  EZ_WidgetPadY(tmp)    = 0;
  EZ_WidgetPadB(tmp)    = 0;
  EZ_WidgetSepX(tmp)    = EZ_WIDGET_DEFAULT_PADX;
  EZ_WidgetSepY(tmp)    = EZ_WIDGET_DEFAULT_PADY;

  EZ_WidgetType(tmp) = EZ_WIDGET_NW_LABEL;

  return(tmp);
}

/*******************************************************************
 *
 *  Display A No Window Label 'Widget'.
 */
void  EZ_DisplayNWLabel(wptr, pixmap, fg, bg, disabled,
			xoffset,yoffset, labeloffset, disp_sibling)
     EZ_Widget *wptr;                 /* the  NW Label */
     Pixmap    pixmap;                /* the pixmap to draw into */
     unsigned  long fg,bg;            /* current parent fg, bg */
     int       xoffset, yoffset;      /* start position in pixmap (Origin) */
     int       labeloffset;           /*  1 or 0. (Button down or not)   */
     int       disabled;              /* children of a disabled widget */
     int       disp_sibling;          /* disp sibling NW labels ?  */
{
  int       ox, oy,xstart, ystart, x,y,xx,yy,fillx,filly, padb;
  int       NewXOffset, NewYOffset;
  GC        gc;
  unsigned  long ufg, dfg;
  XFontStruct *ufont;
  EZ_Widget *parent;

  EZ_WidgetMapped(wptr) = 1;
  EZ_GetWidgetLabelPosition(wptr, &fillx, &filly);
  disabled = disabled || EZ_GetWidgetDisabledFlag(wptr);
  padb = EZ_WidgetPadB(wptr);
  NewXOffset =  xoffset + labeloffset + padb;
  NewYOffset =  yoffset + labeloffset + padb;
  ox = EZ_WidgetOriginX(wptr);
  oy = EZ_WidgetOriginY(wptr);
  xstart =  ox + NewXOffset;
  ystart =  oy + NewYOffset;

  /* Backgroud color  */
  if((parent = EZ_WidgetParent(wptr)))
    {
      if(EZ_WidgetBackground(parent)) EZ_WidgetParentBG(wptr) = &(EZ_WidgetBackground(parent));
      else EZ_WidgetParentBG(wptr) = EZ_WidgetParentBG(parent);
    }

  if(EZ_IsNWFrame(wptr) == 0)
    {
      xx = xstart + fillx + EZ_WidgetXOffset(wptr);
      yy = ystart + filly + EZ_WidgetYOffset(wptr);
      x = xx + EZ_WidgetPadX(wptr) + EZ_WidgetBorderWidth(wptr);
      y = yy + EZ_WidgetBorderWidth(wptr) + EZ_WidgetPadY(wptr);

      /* figure out the foreground color.  */
      dfg = EZ_DEFAULT_FOREGROUND;
      ufg = EZ_LabelForeground(wptr);
      if(ufg == dfg && fg != dfg) ufg = fg;

      if(EZ_LabelPixmap(wptr) == (EZ_Bitmap *)NULL)
	{
	  y +=  EZ_LabelFontAscent(wptr);
	  ufont = EZ_LabelFont(wptr);

	  if( disabled ) 
	    {
	      GC BTgc, DKgc, Ngc;
	      EZ_GetDarkBrightNormalBDGC(wptr, &DKgc, &BTgc, &Ngc);
	      XSetFont(EZ_DisplayForWidgets, DKgc, ufont->fid);
	      XSetFont(EZ_DisplayForWidgets, BTgc, ufont->fid);  
	      XSetFont(EZ_DisplayForWidgets, Ngc, ufont->fid);	    
	  

	      EZ_RenderLabelTextDisabled(pixmap, BTgc,DKgc,Ngc, x, y, 
					 (int)EZ_LabelTHeight(wptr), EZ_LabelString(wptr),
					 (int)EZ_LabelStringLength(wptr), (int)EZ_LabelLineLength(wptr),
					 (int)EZ_LabelNLines(wptr),
					 (int)EZ_LabelTWidth(wptr),
					 (int)EZ_WidgetJustification(wptr),
					 ufont);
	    }
	  else
	    {
	      if(ufg != dfg || ufont != EZ_GetFontFromId(EZ_LABEL_FONT))
		{
		  XSetFont(EZ_DisplayForWidgets, EZ_WRITABLEGC, ufont->fid);
		  XSetForeground(EZ_DisplayForWidgets, EZ_WRITABLEGC, ufg);
		  gc = EZ_WRITABLEGC;
		}
	      else  gc = EZ_LABEL_TEXTGC;
	  
	      EZ_RenderLabelText(pixmap, gc, x, y, (int)EZ_LabelTHeight(wptr), EZ_LabelString(wptr),
				 (int)EZ_LabelStringLength(wptr), (int)EZ_LabelLineLength(wptr),
				 (int)EZ_LabelNLines(wptr),
				 (int)EZ_LabelTWidth(wptr),
				 (int)EZ_WidgetJustification(wptr),
				 ufont);
	    }
	}
      else
	{
	  EZ_Bitmap *bitmap = EZ_LabelPixmap(wptr);

	  gc = EZ_WRITABLEGC;
	  XSetForeground(EZ_DisplayForWidgets, gc, ufg);
	  XSetBackground(EZ_DisplayForWidgets, gc, bg);

	  if(bitmap->shape != (Pixmap)NULL)
	    {
	      XSetClipMask(EZ_Display, gc, bitmap->shape);
	      XSetClipOrigin(EZ_Display, gc,x,y);
	    }
	  EZ_RenderPixmapLabelWithGC(bitmap, pixmap, gc, x,y);
	  if(bitmap->shape != (Pixmap)NULL) XSetClipMask(EZ_Display, gc, None);
	}
    }
  if(EZ_WidgetBorderWidth(wptr) != 0 && EZ_WidgetBorderStyle(wptr)!= EZ_BORDER_NONE)
    EZ_DrawRectBorderWithSize(wptr, pixmap, xstart, ystart,
			      (int) EZ_WidgetWidth(wptr),
			      (int) EZ_WidgetHeight(wptr),
			      (int) EZ_WidgetBorderWidth(wptr),
			      (int) EZ_WidgetBorderStyle(wptr));
  
  /* Now recursively display children widgets */
  {
    EZ_Widget *children = EZ_WidgetChildren(wptr);

    if(children && EZ_WidgetType(children) == EZ_WIDGET_NW_LABEL) /* can only have children of the same type */
      {
	int Xoff = NewXOffset + ox;
	int Yoff = NewYOffset + oy;
	EZ_DisplayNWLabel(children, pixmap, fg, bg, disabled, Xoff,Yoff, 0, 1);
      }
    if(disp_sibling)
      {   /* have to handle NW sibling here */	
	EZ_Widget *sibling = EZ_WidgetSibling(wptr);
	while(sibling) 
	  {
	    if(EZ_WidgetType(sibling) == EZ_WIDGET_NW_LABEL)
	      EZ_DisplayNWLabel(sibling, pixmap, fg, bg, disabled,
				xoffset,yoffset, labeloffset, 0);
	    sibling = EZ_WidgetSibling(sibling);
	  }
      }
  }
}
/****************************************************************************/
#undef _EZ_WIDGET_NWLABEL_C_
