/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
/***********************************************************************
 ***                                                                 ***
 ***                     Widget NoteBook(hack)                       ***
 ***     Composite widget, consists of 3 frames.                     ***
 ***                                                                 ***
 ***********************************************************************/
#define _EZ_WIDGET_NB_C_
#include "EZ_Widget.h"

/*********************************************************************
 * 
 *  Functions implemented in this file:
 */
EZ_Widget   *EZ_CreateNoteBook  MY_ANSIARGS((EZ_Widget *parent));

/*********************************************************************/
EZ_Widget *EZ_CreateNoteBook(parent)
     EZ_Widget *parent;
{
  EZ_Widget  *tmp, *tframe, *bframe;

  tmp = EZ_CreateNewWidget(parent);

  /* use the default widget handle */

  EZ_WidgetType(tmp) = EZ_WIDGET_NOTE_BOOK;
  EZ_WidgetBorderWidth(tmp) = 0;
  EZ_WidgetBorderStyle(tmp)  = EZ_BORDER_NONE;
  EZ_WidgetPixmap(tmp) = (EZ_Bitmap *)NULL;

  EZ_WidgetFont(tmp) = EZ_GetFontFromId(EZ_ITALIC_FONT);
  EZ_WidgetStacking(tmp) = EZ_VERTICAL_TOP;
  EZ_WidgetFillMode(tmp) = EZ_FILL_BOTH;
  EZ_WidgetAlignment(tmp) = EZ_LEFT;
  EZ_WidgetPadX(tmp) = 0;
  EZ_WidgetPadY(tmp) = 0; 
  EZ_WidgetPadB(tmp) = 0; 

  /* top frame, holds page stubs (buttons) */
  tframe = EZ_CreateFrame(tmp,NULL);
  EZ_WidgetPadX(tframe) = 0;
  EZ_WidgetPadY(tframe) = 0;
  EZ_WidgetPadB(tframe) = 0;
  EZ_WidgetSepX(tframe) = 0; 
  EZ_WidgetStacking(tframe) = EZ_HORIZONTAL_LEFT;
  EZ_WidgetFillMode(tframe) = EZ_FILL_VERTICALLY;
  EZ_SetWidgetHeightSetFlag(tframe);
  EZ_SetWidgetWidthSetFlag(tframe);
  EZ_WidgetBorderWidth(tframe) = 0;
  EZ_WidgetBorderStyle(tframe)  = EZ_BORDER_NONE;

  /* bottom frame */
  bframe = EZ_CreateFrame(tmp,NULL);
  EZ_WidgetBorderStyle(bframe) = EZ_BORDER_NONE;
  EZ_WidgetBorderWidth(bframe) = 0;
  EZ_WidgetPadX(bframe) = 0;
  EZ_WidgetPadY(bframe) = 0;
  EZ_WidgetPadB(bframe) = 0; 
  EZ_WidgetFillMode(bframe) = EZ_FILL_BOTH;

  EZ_NoteBookFrame(tmp) = tmp;
  EZ_NoteBookTFrame(tmp) = tframe;
  EZ_NoteBookBFrame(tmp) = bframe;
  EZ_NoteBookActivePage(tmp) = NULL;
  EZ_NoteBookMaxMinWidth(tmp) = 0;
  EZ_NoteBookMaxMinHeight(tmp) = 0;

  return(tmp);
}
/*********************************************************************/
#undef _EZ_WIDGET_NB_C_
