/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
/*******************************************************************
 *  
 *  EZ Widget library. 
 */
#define _EZ_WIDGET_C_
#include <ctype.h>
#include "EZ_Widget.h"

/*******************************************************************
 *
 * Functions implemented in this file:
 */
EZ_Widget             *EZ_CreateNewWidget MY_ANSIARGS((EZ_Widget *parent));
void                  EZ_DestroyWidget MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_DestroyCloneWidget MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_RemoveWidget MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_DestroyWidgetReal MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_GetWidgetLabelPosition MY_ANSIARGS((EZ_Widget *widget, int *x, int *y));
void                  EZ_MarkAllChildrenWidgetSizeChanged MY_ANSIARGS((EZ_Widget *widget, int flag));

void                  EZ_FigureLabelExtent MY_ANSIARGS((XFontStruct  *font_info,
							char         *string,
							int          length, int linelength,
							int          *numlines, int *twidth
							));
void                  EZ_RenderLabelText MY_ANSIARGS((Drawable drawable,
						      GC       gc,
						      int      x, int y,
						      int height, 
						      char     *string,
						      int length,
						      int linelength, int nlines,
						      int twidth, int justification,
						      XFontStruct  *font_info
						      ));
void                   EZ_RenderLabelTextDisabled  MY_ANSIARGS((Drawable drawable,
								GC       BTgc, GC DKgc, GC Ngc,
								int      x, int y,
								int height, 
								char     *string,
								int length,
								int linelength, int nlines,
								int twidth, int justification,
								XFontStruct  *font_info
								));

void                  EZ_RenderPixmapLabel MY_ANSIARGS((EZ_Widget *wptr,
							EZ_Bitmap *bitmap,
							Drawable  drawable,
							int       x,int y
							));
void                  EZ_RenderPixmapLabelWithGC  MY_ANSIARGS((EZ_Bitmap *bitmap,
							       Drawable  drawable,
							       GC        gc,
							       int       x,int y
							       ));
void                  EZ_InitializeCursors MY_ANSIARGS((void));

void                  EZ_SetWidgetPosition MY_ANSIARGS((EZ_Widget *widget, int x, int y));
void                  EZ_SetWidgetWidth MY_ANSIARGS((EZ_Widget *widget, int width));
void                  EZ_SetWidgetHeight MY_ANSIARGS((EZ_Widget *widget, int height));
void                  EZ_GetWidgetPosition MY_ANSIARGS((EZ_Widget *widget, int *x, int *y));
int                   EZ_GetWidgetWidth MY_ANSIARGS((EZ_Widget *widget));
int                   EZ_GetWidgetHeight MY_ANSIARGS((EZ_Widget *widget));
int                   EZ_GetWidgetMinWidth MY_ANSIARGS((EZ_Widget *widget));
int                   EZ_GetWidgetMinHeight MY_ANSIARGS((EZ_Widget *widget));
int                   EZ_GetWidgetBorderWidth MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_GetWidgetDimension MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
void                  EZ_GetWidgetGeometry MY_ANSIARGS((EZ_Widget *widget, int *x,int *y, int *w, int *h));
void                  EZ_GetWidgetAbsoluteGeometry MY_ANSIARGS((EZ_Widget *widget, int *x,int *y, int *w, int *h));
void                  EZ_GetWidgetMinDimension MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
void                  EZ_DisableWidget MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_EnableWidget MY_ANSIARGS((EZ_Widget *widget));
int                   EZ_SetWidgetLabelString MY_ANSIARGS((EZ_Widget *widget, char *str));
char                  *EZ_GetWidgetLabelString MY_ANSIARGS((EZ_Widget *widget));
int                   EZ_GetWidgetIntData MY_ANSIARGS((EZ_Widget *widget));
void                  *EZ_GetWidgetPtrData MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_GetWidgetClientData MY_ANSIARGS((EZ_Widget *widget, int *i, void **p));
int                   EZ_GetWidgetReturnedData MY_ANSIARGS((EZ_Widget *widget));
int                   EZ_GetWidgetReturnData MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_SetWidgetIntData MY_ANSIARGS((EZ_Widget *widget, int idata));
void                  EZ_SetWidgetPtrData MY_ANSIARGS((EZ_Widget *widget, void *ptr));
void                  EZ_SetWidgetClientData MY_ANSIARGS((EZ_Widget *widget, int i, void *p));
void                  EZ_HideWidget MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_DeActivateWidget MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_ActivateWidget MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_FreezeWidget MY_ANSIARGS((EZ_Widget *widget));
void                  EZ_UnFreezeWidget MY_ANSIARGS((EZ_Widget *widget));

void                  EZ_GetBackgroundGC MY_ANSIARGS((EZ_Widget *widget,
						      GC *gc, unsigned long *pv,
						      int highlight, int specialhighlight));
void                  EZ_GetParentBgGCN MY_ANSIARGS((EZ_Widget *widget,
						      GC *gc, unsigned long *pv));

void                  EZ_GetBackgroundPV MY_ANSIARGS((EZ_Widget *widget,
						      unsigned long *pv, 
						      int hlight, int specialhlight));
void                  EZ_GetDarkBDGC MY_ANSIARGS((EZ_Widget *widget, GC *gc));
void                  EZ_GetDarkBDpv MY_ANSIARGS((EZ_Widget *widget, unsigned long *pv));
void                  EZ_GetBrightBDGC MY_ANSIARGS((EZ_Widget *widget, GC *gc));
void                  EZ_GetBrightBDpv MY_ANSIARGS((EZ_Widget *widget, unsigned long *pv));
void                  EZ_GetDarkBrightNormalBDGC MY_ANSIARGS((EZ_Widget *widget, GC *dk, GC *bt, GC *ngc));
int                   EZ_GetLabel2XPosition MY_ANSIARGS((EZ_Widget *widget,int l2width, int offset));
int                   EZ_GetWidgetOrientation MY_ANSIARGS((EZ_Widget *widget));

Window                EZ_GetWidgetWindow MY_ANSIARGS((EZ_Widget *widget));





void                  EZ_SetWidgetCallBack MY_ANSIARGS((EZ_Widget *widget, EZ_CallBack callback, void *data));
void                  EZ_AddWidgetCallBack MY_ANSIARGS((EZ_Widget *widget, int wlist,
							EZ_CallBack callback, void *data,int where));
void                  EZ_AddWidgetCallBackInternal MY_ANSIARGS((EZ_Widget *widget, int wlist,
								EZ_CallBack callback, void *data,int where));
void                  EZ_RemoveWidgetCallBack MY_ANSIARGS((EZ_Widget *widget, int wlist,
							   EZ_CallBack callback, void *data));
void                  EZ_RemoveAllWidgetCallBacks MY_ANSIARGS((EZ_Widget *widget, int wlist));

void                  EZ_AddCallBackWork MY_ANSIARGS((EZ_CallBackStruct **list, EZ_CallBack callback,
						      void *data, int where, int flag));
void                  EZ_RemoveCallBackWork MY_ANSIARGS((EZ_CallBackStruct **list, EZ_CallBack callback, void *data));
void                  EZ_RemoveAllCallBacksWork MY_ANSIARGS((EZ_CallBackStruct **list ));

void                  EZ_AddEventHandler MY_ANSIARGS((EZ_Widget *widget, EZ_EventHandler handler,
						      void *data, int where));
void                  EZ_RemoveEventHandler MY_ANSIARGS((EZ_Widget *widget, EZ_EventHandler handler, void *data));
void                  EZ_RemoveAllEventHandlers MY_ANSIARGS((EZ_Widget *widget));

/*************************************************************************/
static  EZ_CallBackStruct     **EZ_GetCallbackType MY_ANSIARGS((EZ_Widget *widget, int which));
static  EZ_EventHandlerStruct **GetWidgetEventHandlers MY_ANSIARGS((EZ_Widget *widget));
/*************************************************************************
 ***                                                                   ***
 ***  Create a Widget data structure and initialize the common fields. ***
 ***  All EZ widget creation routines call this function.              ***
 ***                                                                   ***
 *************************************************************************/

EZ_Widget *EZ_CreateNewWidget(parent)
     EZ_Widget  *parent;     /* parent widget    */
{
  EZ_Widget *tmp, *ptr;  

  /*----------------------------------------------------
   * Make sure that the widget lib has been initialized.
   *---------------------------------------------------*/
  EZ_Initialize(0,NULL,1);
  
  /*-------------------------------------------
   * allocate a new widget and initialize it.
   *-----------------------------------------*/
  tmp = (EZ_Widget *)my_malloc(sizeof(EZ_Widget), _NEW_WIDGET_);
  if(!tmp)  EZ_OutOfMemory("EZ_CreateNewWidget");
  (void) memset(tmp,0, sizeof(EZ_Widget));

  EZ_WidgetOriginX(tmp)      = 0;
  EZ_WidgetOriginY(tmp)      = 0;
  EZ_WidgetWidth(tmp)        = 1;
  EZ_WidgetHeight(tmp)       = 1;
  EZ_WidgetMinWidth(tmp)     = 0;
  EZ_WidgetMinHeight(tmp)    = 0;
  EZ_WidgetAWidth(tmp)       = 0;
  EZ_WidgetAHeight(tmp)      = 0;
  EZ_WidgetCW(tmp)           = 0;
  EZ_WidgetCH(tmp)           = 0;

  EZ_WidgetWidthHint(tmp)    = 0;
  EZ_WidgetHeightHint(tmp)   = 0;
  EZ_WidgetWindow(tmp)       = (Window )NULL;
  EZ_WidgetParent(tmp)       = parent;
  EZ_WidgetChildren(tmp)     = (EZ_Widget *)NULL;   
  EZ_WidgetSibling(tmp)      = (EZ_Widget *)NULL;

  EZ_WidgetDnDApplName(tmp)  = (Window )NULL;
  EZ_WidgetDnDParent(tmp)    = (Window )NULL;
  EZ_WidgetAMinWidth(tmp)    = 0;
  EZ_WidgetAMinHeight(tmp)   = 0;

  EZ_WidgetFlags(tmp)        = 0;
  EZ_WidgetBubbleString(tmp) = (char *)NULL;
  EZ_WidgetPixmap(tmp)       = (EZ_Bitmap *)NULL;
  EZ_WidgetForeground(tmp)   = EZ_DEFAULT_FOREGROUND;
  EZ_WidgetBackground(tmp)   = 0;
  EZ_WidgetParentBG(tmp)     = (unsigned long *)NULL;
  EZ_WidgetFont(tmp)         = (XFontStruct *)NULL;

  EZ_WidgetNumChildren(tmp)  = 0;
  EZ_WidgetPadX(tmp)         = EZ_WIDGET_DEFAULT_PADX;
  EZ_WidgetPadY(tmp)         = EZ_WIDGET_DEFAULT_PADY;
  EZ_WidgetPadB(tmp)         = 0;
  EZ_WidgetSepX(tmp)         = 0;
  EZ_WidgetSepY(tmp)         = 0;
  EZ_WidgetAuxXLeft(tmp)     = 0;
  EZ_WidgetAuxXRight(tmp)    = 0;
  EZ_WidgetAuxY(tmp)         = 0;
  EZ_WidgetHAdjust(tmp)      = 0;
  EZ_WidgetMaped(tmp)        = 0;
  EZ_WidgetStacking(tmp)     = EZ_HORIZONTAL;
  EZ_WidgetAlignment(tmp)    = EZ_CENTER_ALIGNED;
  EZ_WidgetLabelPosition(tmp)= EZ_CENTER;
  EZ_WidgetJustification(tmp)= EZ_LEFT;
  EZ_WidgetFillMode(tmp)     = 0;
  EZ_WidgetBorderWidth(tmp)  = 2;
  EZ_WidgetBorderStyle(tmp)  = EZ_BORDER_NONE;

  EZ_WidgetIntData(tmp)      = 0;
  EZ_WidgetPtrData(tmp)      = (void *)NULL;
  EZ_WidgetRetData(tmp)      = 0;

  EZ_WidgetCallBack(tmp) = (EZ_CallBackStruct *)NULL;  
  EZ_WidgetMotionCallBack(tmp) = (EZ_CallBackStruct *)NULL;  
  EZ_WidgetDestroyCallback(tmp) = (EZ_CallBackStruct *)NULL;  
  EZ_WidgetEventHandler(tmp) = (EZ_EventHandlerStruct *)NULL;  

  EZ_WidgetDnDDragCursor(tmp) = (Cursor)NULL;
  EZ_WidgetDnDTmp(tmp) = (void *)NULL;
  EZ_WidgetDnDHandler(tmp) = (EZ_DnDMsgHandler)NULL;  
  EZ_WidgetDnDDataEncoders(tmp) = (EZ_DnDDataEncoder *)NULL;
  EZ_WidgetDnDDataDecoders(tmp) = (EZ_DnDDataDecoder *)NULL;
  EZ_WidgetDnDTargetHelp(tmp) = (char *)NULL;
  EZ_WidgetGBW(tmp) = 1;
  EZ_WidgetGBH(tmp) = 1;
  EZ_WidgetNameString(tmp) = (char *)NULL;
      
  /*------------------------------------------
   * Insert it into its parent's children list
   *-----------------------------------------*/  
  if(parent != (EZ_Widget *)NULL)
    {
      EZ_ClearWidgetSizeComputedFlag(parent);  
      EZ_WidgetNumChildren(parent)  += 1;
      ptr = EZ_WidgetChildren(parent);
      /*------------------------------------
       * tmp is the first widget of parent
       *-----------------------------------*/
      if(ptr == (EZ_Widget *)NULL)
	EZ_WidgetChildren(parent) = tmp;
      else
	{
	  /*-------------------------------
	   * insert tmp at the end of 
	   * children's sibling list.
	   *------------------------------*/
	  while(EZ_WidgetSibling(ptr)) ptr = EZ_WidgetSibling(ptr);
	  EZ_WidgetSibling(ptr) = tmp;
	}
    }  
  /*-----------------------------------------
   * insert tmp into the Widget hash table 
   *----------------------------------------*/
  EZ_InsertWidgetToAllHT(tmp);
  return(tmp);
}

/*******************************************************************************
 ***                                                                         ***
 ***  Destroy a widget. We do this in two steps.                             ***
 ***  [1].  ReChain its parent' children list, which is on the sibling       ***
 ***        list of its parent' first child widget.                          ***
 ***  [2].  Disconnect widget from its parent and sibling list and do        ***
 ***        a recursive destruction.                                         ***
 ***                                                                         ***
 *******************************************************************************/
void  EZ_DestroyWidget(widget)
     EZ_Widget *widget;
{
  int WType;

  if(EZ_LookupWidgetFromAllHT(widget) == (EZ_Widget *)NULL) return;
  WType = EZ_WidgetType(widget);

  /*----------------------------------------------------------------
   * special case first. NoteBookPage has a special button companion
   *----------------------------------------------------------------*/
  if(WType == EZ_WIDGET_NORMAL_BUTTON)
    {
      EZ_Widget *companion = EZ_ButtonCompanion(widget);
      if(companion) EZ_NBPageCompanion(companion) = NULL;
    }
  else if(WType == EZ_WIDGET_NB_PAGE)
    {
      EZ_Widget *companion = EZ_NBPageCompanion(widget);
      EZ_DestroyWidget(companion);
    }

  /*----------------------------------
   *    Fix its parent
   *---------------------------------*/ 
  EZ_RemoveWidget(widget);
  /*---------------------------------
   * Now, the real destruction
   *--------------------------------*/
  EZ_WidgetSibling(widget) = (EZ_Widget *)NULL;
  EZ_WidgetParent(widget) = (EZ_Widget *)NULL; 
  if(EZ_GetWidgetIsCloneFlag(widget))  EZ_DestroyCloneWidget(widget);
  else  EZ_DestroyWidgetReal(widget);
}

void EZ_DestroyWidgetReal(widget)
     EZ_Widget *widget;
{
  EZ_Widget *children, *sibling;
  int WType;

  if(widget == (EZ_Widget *)NULL) return;  
  WType = EZ_WidgetType(widget);

  children = EZ_WidgetChildren(widget);
  sibling = EZ_WidgetSibling(widget);
  EZ_DestroyWidgetReal(children);
  EZ_DestroyWidgetReal(sibling);

  /*-------------------------------------------------
   * remove it fm the widget HT and close its window.
   *------------------------------------------------*/
  EZ_RemoveWidgetFromAllHT(widget);  
  EZ_RemoveWidgetFromMappedHT(widget);  
  EZ_RemveWidgetFromDnDList(widget);
  /*
   * destroy embeded application. This is a simple minded
   * solution. We cannot just destroy widget or leave the
   * windows unattended. Both destroy the window at the time
   * the applicatione exists. This leave the embeded window
   * be destroyed, which causes X errors ...
   * Ths soln here is to reparent the embeded window to 
   * ROOTWINDOW, send a destroy message to the embeded 
   * application, and just let it handle itself.
   */
  if(WType == EZ_WIDGET_EMBEDER || WType == EZ_WIDGET_EXECUTOR)
    {
      if(EZ_EmbederConfirmed(widget) > 0)  /* embeding is alive */
	{
	  Window commWin = EZ_EmbederCommuWin(widget);
	  Window eWin = EZ_EmbederWin(widget);
	  unsigned long id = EZ_EmbederWidgetAddr(widget);
	  
	  EZ_GrabServer(); /* have to grab server */
	  if(EZ_EmbederId(widget) == EZ_VerifyExistence(commWin) && EZ_WindowExist(eWin))
	    {
	      int x = EZ_WidgetOriginX(widget); /* absolute coor ?? */
	      int y = EZ_WidgetOriginY(widget); 
	      int w = EZ_WidgetWidth(widget);
	      int h = EZ_WidgetHeight(widget);
	      EZ_SetWMHintForWindow(eWin, x,y,w,h);
	      XReparentWindow(EZ_Display, eWin, 
			      RootWindow(EZ_Display, EZ_ScreenNum),
			      x,y);  /* approximate location */
	    }
	  EZ_UngrabServer();

	  EZ_EmbederConfirmed(widget) = 0;
	  EZ_SendEmbedingMessage(EZ_EMBEDING_DESTROY_YOUSELF_C,
				 EZ_DummyWindow, EZ_WidgetWindow(widget),(unsigned long)widget,
				 commWin,eWin, id, EZ_EmbederId(widget), 0,0,0,0, 0, 0);
	}
    }
  {
    Window win = EZ_WidgetWindow(widget);
    if(EZ_WindowExist(win))
      {
	EZ_RemoveFromDnDWindowList(widget); /* 5-20-97 */
	XDestroyWindow(EZ_Display,win);
      }
  }
  
  if(EZ_GetWidgetEmbededFlag(widget))
    {
      /* widget is embeded in another application 
       * send a message to the embeder.
       */
      Window commWin, win;
      
      commWin = EZ_WidgetDnDApplName(widget);
      win = EZ_WidgetDnDParent(widget);
      if(EZ_VerifyExistence(commWin) && EZ_WindowExist(win))
	{
	  EZ_SendEmbedingMessage(EZ_EMBEDING_CLIENT_DIED_S,
				 EZ_DummyWindow, EZ_WidgetWindow(widget), (unsigned long)widget,
				 commWin, win, 0, EZ_ApplicationSetupTime, 0,0,0,0, 0, 0);
	}
    }
  
  /*-------------------------------------------------
   * If there is a bubble help string, release it
   *------------------------------------------------*/  
  if(EZ_WidgetBubbleString(widget))
    {
      (void)my_free(EZ_WidgetBubbleString(widget));
      EZ_WidgetBubbleString(widget) = (char *)NULL;
    }
  if(EZ_WidgetDnDTargetHelp(widget))
    {
      (void)my_free(EZ_WidgetDnDTargetHelp(widget));
      EZ_WidgetDnDTargetHelp(widget) = (char *)NULL;
    }
  if(EZ_WidgetNameString(widget))
    {
      (void)my_free(EZ_WidgetNameString(widget));
      EZ_WidgetNameString(widget) = (char *)NULL;
    }
  /*-------------------------------------------------
   * Call user-defined  DestroyCallbacks
   *------------------------------------------------*/  
  if(EZ_WidgetDestroyCallback(widget))
    {
      EZ_CallBackStruct *next, *funcList = EZ_WidgetDestroyCallBack(widget); 
      if(funcList)
	{
	  EZ_WidgetDestroyCallBack(widget) = (EZ_CallBackStruct *)NULL;
	  while(funcList)
	    {
	      if(EZ_LookupWidgetFromAllHT(widget) == widget)
		{
		  if(funcList->callback)
		    (funcList->callback)(widget,funcList->data);
		}
	      next = funcList->next;
	      (void)my_free((char *)funcList);
	      funcList = next;
	    }
	}
    }
  /*-------------------------------------------------
   * remove the callback lists and event handlers
   *------------------------------------------------*/  
  {
    EZ_CallBackStruct *next, *funcList = EZ_WidgetCallBackFunc(widget);
    while(funcList)
      {
	next = funcList->next;
	(void)my_free(funcList);      
	funcList = next;
      }
    EZ_WidgetCallBackFunc(widget) = (EZ_CallBackStruct *)NULL;

    funcList = EZ_WidgetMotionCallBack(widget);
    while(funcList)
      {
	next = funcList->next;
	(void)my_free(funcList);      
	funcList = next;
      }
    EZ_WidgetMotionCallBack(widget) = (EZ_CallBackStruct *)NULL;
  }
  {
    EZ_EventHandlerStruct *next, *funcList = EZ_WidgetEventHandlers(widget);
    while(funcList)
      {
	next = funcList->next;
	(void)my_free(funcList);      
	funcList = next;
      }    
    EZ_WidgetEventHandlers(widget) = (EZ_EventHandlerStruct *)NULL;      
  }
  /*-------------------------------------------------
   * remove DnD message En(De)coders
   *------------------------------------------------*/  
  {
    EZ_DnDDataEncoder *next, *tmp = EZ_WidgetDnDDataEncoders(widget);
    while(tmp)
      {
	next = tmp->next;
	(void)my_free((char *)tmp);
	tmp = next;
      }
    EZ_WidgetDnDDataEncoders(widget) = (EZ_DnDDataEncoder *)NULL;
  }
  {
    EZ_DnDDataDecoder *next, *tmp = EZ_WidgetDnDDataDecoders(widget);
    while(tmp)
      {
	next = tmp->next;
	(void)my_free((char *)tmp);
	tmp = next;
      }
    EZ_WidgetDnDDataDecoders(widget) = (EZ_DnDDataDecoder *)NULL;
  }
  
  /*-------------------------------------------------
   * free widget specific data.
   *------------------------------------------------*/  
  (EZ_WidgetHandlingFunctions[WType]->FreeData)(widget);
  /*-------------------------------------------------
   * and finally, free the widget.
   *------------------------------------------------*/  
  (void) my_free( (char *)widget);
}

/******************************************************
 * used only for destroying tear off menu
 */
void EZ_DestroyCloneWidget(widget)
     EZ_Widget *widget;
{
  EZ_Widget *children, *sibling;
  int WType;

  if(widget == (EZ_Widget *)NULL) return;  
  WType = EZ_WidgetType(widget);

  children = EZ_WidgetChildren(widget);
  sibling = EZ_WidgetSibling(widget);
  EZ_DestroyCloneWidget(children);
  EZ_DestroyCloneWidget(sibling);

  /*-------------------------------------------------
   * remove it fm the widget HT and close its window.
   *------------------------------------------------*/
  EZ_RemoveWidgetFromAllHT(widget);  
  EZ_RemoveWidgetFromMappedHT(widget);  
  EZ_RemveWidgetFromDnDList(widget);
  /* destroy widget window */
  {
    Window win = EZ_WidgetWindow(widget);
    if(EZ_WindowExist(win))
      {
	EZ_RemoveFromDnDWindowList(widget); /* 5-20-97 */
	XDestroyWindow(EZ_Display,win);
      }
  }
  
  if(EZ_GetWidgetEmbededFlag(widget))
    {
      /* widget is embeded in another application 
       * send a message to the embeder.
       */
      Window commWin, win;
      
      commWin = EZ_WidgetDnDApplName(widget);
      win = EZ_WidgetDnDParent(widget);
      if(EZ_VerifyExistence(commWin) && EZ_WindowExist(win))
	{
	  EZ_SendEmbedingMessage(EZ_EMBEDING_CLIENT_DIED_S,
				 EZ_DummyWindow, EZ_WidgetWindow(widget), (unsigned long)widget,
				 commWin, win, 0, EZ_ApplicationSetupTime, 0,0,0,0, 0, 0);
	}
    }
  
  /*-------------------------------------------------------
   * RADIO buttons are grouped with others. Fix its group
   *------------------------------------------------------*/  
  if(WType == EZ_WIDGET_MENU_RADIO_BUTTON || WType == EZ_WIDGET_RADIO_BUTTON)
      EZ_RemoveRBtnFromItsGroup(widget);
  /*-------------------------------------------------
   * and finally, free the widget.
   *------------------------------------------------*/  
  (void) my_free( (char *)widget);
}

/****************************************************************/
void EZ_RemoveWidget(widget)
     EZ_Widget *widget;
{
  if(widget)
    {
      EZ_Widget *parent = NULL;
      if( (parent = EZ_WidgetParent(widget)) != (EZ_Widget *)NULL)
	{
	  EZ_Widget *wptr, *children = EZ_WidgetChildren(parent);
      
	  if(children == widget)
	    { 
	      EZ_WidgetChildren(parent) = EZ_WidgetSibling(widget);
	    }
	  else
	    {
	      wptr = children;
	      while(wptr && EZ_WidgetSibling(wptr) != widget)
		{
		  wptr =  EZ_WidgetSibling(wptr);
		}
	      if(wptr)
		{
		  children = EZ_WidgetSibling(wptr);
		  EZ_WidgetSibling(wptr) = EZ_WidgetSibling(children);
		}
	    }
	  EZ_ClearWidgetSizeComputedFlag(parent);  
	  EZ_WidgetNumChildren(parent) -= 1;
	}
    }
}

/**************************************************************
 *
 *  Extract the displacement for placing  LABEL
 *  on a widget.
 */
void  EZ_GetWidgetLabelPosition(wptr, x,y)
     EZ_Widget *wptr;
     int *x, *y;
{
  int  fillx, filly;

  if(wptr == (EZ_Widget *)NULL)
    {
      *x = 0; *y = 0;
      return;
    }
  fillx = filly = 0;
  switch(EZ_WidgetLabelPosition(wptr))
    {
    case EZ_LEFT:
    case EZ_LEFT_2_RIGHT:
      fillx = - EZ_WidgetXOffset(wptr);
      break;
    case EZ_RIGHT:
      fillx =  EZ_WidgetXOffset(wptr);
      break;
    case EZ_TOP:
      filly = - EZ_WidgetYOffset(wptr);
      break;
    case EZ_BOTTOM:
      filly = EZ_WidgetYOffset(wptr);
      break;
    case EZ_TOP_LEFT:
      filly = - EZ_WidgetYOffset(wptr);
      fillx = - EZ_WidgetXOffset(wptr);
      break;
    case EZ_TOP_RIGHT:
      filly = - EZ_WidgetYOffset(wptr);
      fillx = EZ_WidgetXOffset(wptr);
      break;
    case EZ_BOTTOM_LEFT:
      filly = EZ_WidgetYOffset(wptr);
      fillx = -EZ_WidgetXOffset(wptr);
      break;
    case EZ_BOTTOM_RIGHT:
      filly = EZ_WidgetYOffset(wptr);
      fillx = EZ_WidgetXOffset(wptr);
      break;
    case EZ_CENTER:
    default:
      break;
    }
  *x = fillx;
  *y = filly;
}

int EZ_GetLabel2XPosition(wptr, l2width, offset)
     EZ_Widget *wptr;
     int l2width, offset;
{
  int w = EZ_WidgetWidth(wptr);
  int bwpdx = EZ_WidgetPadX(wptr) + EZ_WidgetBorderWidth(wptr) + EZ_WidgetPadB(wptr);
  int tmpx;

  tmpx = w - bwpdx -l2width + offset;
  if(EZ_WidgetChildren(wptr) == NULL &&
     EZ_WidgetLabelPosition(wptr) == EZ_CENTER)
    tmpx -= EZ_WidgetXOffset(wptr);

  return(tmpx);
}
/********************************************************************************
 ***                                                                          ***
 ***  The Next two functions compute/display a lable string on a button       ***
 ***  and/or label.  They use the same simple algorithm to break long         ***
 ***  labels into pieces. Both should be modified if we want to change to a   ***
 ***  better algorithm !                                                      ***
 ***                                                                          ***
 ********************************************************************************/

/*
 *  Figure out the text extent of label.
 */

void EZ_FigureLabelExtent(font_info, string, length, linelength, numlines, twidth)
     XFontStruct  *font_info;
     char         *string;
     int          length, linelength;
     int          *numlines, *twidth;
{
  char   *str, *tmp, *tmpa = (char *)NULL;
  int    i, j, itmp, nlines, slen, llen, trylen, lookahead, maxwidth;

  str = string;
  slen = length;
  llen = (linelength <= 0? 16: linelength);

  if(llen < 8)
    {
      trylen = (llen >>1) + 1;
      lookahead = llen - trylen;
    }
  else
    {
      trylen = llen - 8;
      lookahead = 8;
    }
  maxwidth = 0;
  nlines = 0;
	      
  while(slen > 0)
    {
      if(slen > llen)
	{
	  itmp = -1;
	  for(i = 0; i < trylen + lookahead; i++)
	    {
	      if( *(str + i) == '\n')
		{
		  itmp = i+1;
		  tmpa = str + i+1;
		  j = XTextWidth(font_info, str, itmp);
		  maxwidth = MAXV(maxwidth, j);
		  str = tmpa;
		  slen = slen - itmp;
		  nlines++;
		  break;
		}
	    }
	  if( itmp == -1) 
	    {
	      tmp = str + trylen;
	      for(i = 0; i < lookahead; i++)
		{
		  if(IS_END_OF_WORD(*tmp))
		    {
		      tmpa = tmp+1;
		      itmp = i+1;
		    }
		  tmp++;
		}
	      if(itmp == -1) 
		{
		  itmp = lookahead;
		  tmpa = tmp;
		}
	      i = XTextWidth(font_info, str, trylen + itmp);
	      maxwidth = MAXV(maxwidth, i);
	      nlines++;
	      str = tmpa;
	      slen = slen - (trylen + itmp);
	    }
	}
      else
	{
	  itmp = -1;
	  for(i = 0; i < slen; i++)
	    {
	      if( *(str + i) == '\n')
		{
		  j = XTextWidth(font_info, str, i);
		  maxwidth = MAXV(maxwidth, j); 
		  str = str + i+1;
		  slen = slen - (i+1); 
		  nlines++;
		  itmp = 0;
		  break;
		}
	    }
	  if(itmp == -1)
	    {
	      i = XTextWidth(font_info, str, slen);
	      slen = 0;
	      maxwidth = MAXV(maxwidth, i); 
	      nlines++;
	    }
	}
    }
  *numlines = nlines;
  *twidth = maxwidth;
}

/*
 *  Draw the label string on widgets.
 */
void EZ_RenderLabelText(drawable,gc,x,y,height,string,length, linelength, nlines,
			twidth, justification, font_info)
     Drawable drawable;
     GC       gc;
     int      x,y,height,length,linelength, nlines, twidth, justification;
     char     *string;
     XFontStruct  *font_info;     
{

  char   *str, *tmp, *tmpa = (char *)NULL;
  int    i, itmp, slen, llen, trylen, lookahead, offset;

  str = string;
  if(str[0] == '\0') return;

  slen = length;
  llen = (linelength <=0 ? 16: linelength);;

  if(nlines == 1)
    {
      XDrawString(EZ_DisplayForWidgets, drawable, gc, x, y, string, slen);
      return;
    }
  
  if(llen < 8)
    {
      trylen = (llen >>1) + 1;
      lookahead = llen - trylen;
    }
  else
    {
      trylen = llen - 8;
      lookahead = 8;
    }
	  
  while(slen > 0)
    {
      if(slen > llen)
	{
	  itmp = -1;
	  for(i = 0; i < trylen + lookahead; i++)
	    {
	      if( *(str + i) == '\n')
		{
		  itmp = i+1;
		  tmpa = str + i+1;
		  if(justification == EZ_LEFT) offset = 0;
		  else
		    { 
		      int tlen = XTextWidth(font_info, str, itmp);
		      offset = twidth - tlen;
		      if(justification == EZ_CENTER) offset = offset >> 1;
		    }
		  XDrawString(EZ_DisplayForWidgets, drawable, gc, x + offset,y, str, itmp);
		  str = tmpa;
		  slen = slen - itmp;
		  break;
		}
	    }
	  if(itmp == -1)
	    {
	      tmp = str + trylen;
	      for(i = 0; i < lookahead; i++)
		{
		  if(IS_END_OF_WORD(*tmp))
		    {
		      tmpa = tmp+1;
		      itmp = i+1;
		    }
		  tmp++;
		}
	      if(itmp == -1) 
		{
		  itmp = lookahead;
		  tmpa = tmp;
		}
	      i = trylen + itmp;
	      if(justification == EZ_LEFT) offset = 0;
	      else
		{ 
		  int tlen = XTextWidth(font_info, str, i);
		  offset = twidth - tlen;
		  if(justification == EZ_CENTER) offset = offset >> 1;
		}
	      XDrawString(EZ_DisplayForWidgets, drawable, gc, x + offset, y, str, i);
	      str = tmpa;
	      slen = slen - i;
	    }
	}
      else
	{
	  itmp = -1;
	  for(i = 0; i < slen; i++)
	    {
	      if( *(str + i) == '\n')
		{
		  if(justification == EZ_LEFT) offset = 0;
		  else
		    { 
		      int tlen = XTextWidth(font_info, str, i+1);
		      offset = twidth - tlen;
		      if(justification == EZ_CENTER) offset = offset >> 1;
		    }
		  XDrawString(EZ_DisplayForWidgets, drawable, gc, x + offset, y, str, i+1);
		  str = str + i+1;
		  slen = slen - (i+1); 
		  itmp = 0;
		  break;
		}
	    }
	  if(itmp == -1)
	    {
	      if(justification == EZ_LEFT) offset = 0;
	      else
		{ 
		  int tlen = XTextWidth(font_info, str, slen);
		  offset = twidth - tlen;
		  if(justification == EZ_CENTER) offset = offset >> 1;
		}
	      XDrawString(EZ_DisplayForWidgets, drawable, gc, x+offset, y, str, slen);
	      slen = 0;
	    }
	}
      y += height;
    }
}


/*
 * Disabled widget label is displayed differently.
 */
void EZ_RenderLabelTextDisabled(drawable,BTgc,DKgc,Ngc, x,y,height,string,length, linelength, nlines,
				twidth, justification, font_info)
     Drawable drawable;
     GC       BTgc, DKgc, Ngc;
     int      x,y,height,length,linelength, nlines, twidth, justification;
     char     *string;
     XFontStruct  *font_info;     

{
  EZ_RenderLabelText(drawable,DKgc, x+1,y+1,height,string,length, linelength, nlines,
		     twidth, justification, font_info);
  EZ_RenderLabelText(drawable,BTgc, x-1,y-1,height,string,length, linelength, nlines,
		     twidth, justification, font_info);
  EZ_RenderLabelText(drawable,Ngc, x,y,height,string,length, linelength, nlines,
		     twidth, justification, font_info);
}

/*
 * render a pixmap label.
 */
void EZ_RenderPixmapLabel(wptr, bitmap, drawable, x, y)
     EZ_Widget *wptr;
     EZ_Bitmap *bitmap;  /* the bitmap   */
     Drawable  drawable; /* the drawable */
     int       x,y;      /* UL corner    */
{
  unsigned long  back_color = EZ_ColorArray[EZ_NORMAL_GRAY1];
  unsigned long  fore_color = EZ_DEFAULT_FOREGROUND;
  GC             gc;

    
  if(EZ_GetWidgetHighlightFlag(wptr))
    {
      if(EZ_WidgetBackground(wptr) != 0)
	back_color = EZ_GetHighlightColor(EZ_WidgetBackground(wptr));
      else if(EZ_WidgetParentBG(wptr) && *(EZ_WidgetParentBG(wptr)))
	back_color = EZ_GetHighlightColor(*(EZ_WidgetParentBG(wptr)));
      else  back_color = EZ_ColorArray[EZ_NORMAL_GRAY2];
    }
  else if(EZ_WidgetBackground(wptr) != 0) back_color = EZ_WidgetBackground(wptr);
  else if(EZ_WidgetParentBG(wptr) && *(EZ_WidgetParentBG(wptr)))
    back_color = *(EZ_WidgetParentBG(wptr));

  if(EZ_WidgetForeground(wptr) != EZ_DEFAULT_FOREGROUND)
    fore_color = EZ_WidgetForeground(wptr);
  gc = EZ_WRITABLEGC;
  
  XSetForeground(EZ_DisplayForWidgets, gc, fore_color);
  XSetBackground(EZ_DisplayForWidgets, gc, back_color);

  if(bitmap->shape != (Pixmap)NULL)
    {
      XSetClipMask(EZ_Display, gc, bitmap->shape);
      XSetClipOrigin(EZ_Display, gc,x,y);
    }
  EZ_RenderPixmapLabelWithGC(bitmap, drawable, gc, x,y);
  if(bitmap->shape != (Pixmap)NULL) XSetClipMask(EZ_Display, gc, None);
}

void EZ_RenderPixmapLabelWithGC(bitmap, drawable, gc, x,y)
     EZ_Bitmap *bitmap;
     Drawable drawable;
     GC       gc;
     int      x,y;
{
  if(EZ_BitmapType(bitmap) == EZ_BITMAP_IS_BITMAP)
    XCopyPlane(EZ_DisplayForWidgets,
	       bitmap->pixmap,
	       drawable,
	       gc,
	       0,0,
	       (unsigned int)(bitmap->width),
	       (unsigned int)(bitmap->height),
	       x,y,
	       1);
  else 
    XCopyArea(EZ_DisplayForWidgets,
	      bitmap->pixmap,
	      drawable,
	      gc,
	      0,0,
	      (unsigned int)(bitmap->width),
	      (unsigned int)(bitmap->height),
	      x,y);
}


/*
 *  set the GC for rendering background
 */
void  EZ_GetBackgroundGC(wptr, gcptr, pv, hlight, specialhlight)
     EZ_Widget *wptr;
     GC        *gcptr;
     unsigned long *pv;
     int       hlight, specialhlight;
{
  if(wptr)
    {
      if((hlight && EZ_GetWidgetHighlightFlag(wptr)) || specialhlight)
	{
	  if(EZ_WidgetBackground(wptr) != 0)
	    {
	      *pv = EZ_GetHighlightColor(EZ_WidgetBackground(wptr));
	      XSetForeground(EZ_Display, EZ_WRITABLEGC, *pv);
	      *gcptr = EZ_WRITABLEGC;
	    }
	  else if(EZ_WidgetParentBG(wptr) && *(EZ_WidgetParentBG(wptr)))
	    {
	      *pv = EZ_GetHighlightColor(*(EZ_WidgetParentBG(wptr)));
	      XSetForeground(EZ_Display, EZ_WRITABLEGC, *pv);
	      *gcptr = EZ_WRITABLEGC;
	    }
	  else 
	    {
	      *pv = EZ_ColorArray[EZ_NORMAL_GRAY2];
	      *gcptr = EZ_NORMALGC2;
	    }
	}
      else if(EZ_WidgetBackground(wptr) != 0)
	{
	  *pv = EZ_WidgetBackground(wptr);
	  XSetForeground(EZ_Display, EZ_WRITABLEGC, *pv);
	  *gcptr = EZ_WRITABLEGC;
	}
      else if(EZ_WidgetParentBG(wptr) && *(EZ_WidgetParentBG(wptr)))
	{
	  *pv = *(EZ_WidgetParentBG(wptr));
	  XSetForeground(EZ_Display, EZ_WRITABLEGC, *pv);
	  *gcptr = EZ_WRITABLEGC;
	}
      else 
	{
	  *pv = EZ_ColorArray[EZ_NORMAL_GRAY1];
	  *gcptr = EZ_NORMALGC1;
	}
    }
}

void EZ_GetParentBgGCN(wptr, gcptr, pv)
     EZ_Widget *wptr;
     GC        *gcptr;
     unsigned long *pv;
{
  if(wptr)
    {
      EZ_Widget *tmp = EZ_WidgetParent(wptr);
      if(tmp) wptr = tmp;
      if(EZ_WidgetBackground(wptr) != 0)
	*pv = EZ_WidgetBackground(wptr);
      else if(EZ_WidgetParentBG(wptr) && *(EZ_WidgetParentBG(wptr)))
	*pv = *(EZ_WidgetParentBG(wptr));
      else 
	*pv = EZ_ColorArray[EZ_NORMAL_GRAY1];
      XSetForeground(EZ_Display, EZ_WRITABLEGC2, *pv);
      *gcptr = EZ_WRITABLEGC2;
    }
}



void EZ_GetDarkBrightNormalBDGC(widget, darkgc, brightgc, normalgc)
     EZ_Widget *widget;
     GC        *darkgc, *brightgc, *normalgc;
{
  unsigned long pixel, dbg;
  if(EZ_WidgetBackground(widget))
    {
      dbg = EZ_WidgetBackground(widget);
      pixel = EZ_GetDarkColor(dbg);
      XSetForeground(EZ_Display, EZ_BD_DARKGC, pixel);
      *darkgc = EZ_BD_DARKGC;
      pixel = EZ_GetBrightColor(dbg);
      XSetForeground(EZ_Display, EZ_BD_BRIGHTGC, pixel);
      *brightgc = EZ_BD_BRIGHTGC;      
      XSetForeground(EZ_Display, EZ_BD_NORMALGC, dbg);
      *normalgc = EZ_BD_NORMALGC; 
    }
  else if(EZ_WidgetParentBG(widget) && *(EZ_WidgetParentBG(widget)))
    {
      dbg = *(EZ_WidgetParentBG(widget));
      pixel = EZ_GetDarkColor(dbg);
      XSetForeground(EZ_Display, EZ_BD_DARKGC, pixel);
      *darkgc = EZ_BD_DARKGC;
      pixel = EZ_GetBrightColor(dbg);
      XSetForeground(EZ_Display, EZ_BD_BRIGHTGC, pixel);
      *brightgc = EZ_BD_BRIGHTGC;
      XSetForeground(EZ_Display, EZ_BD_NORMALGC, dbg);
      *normalgc = EZ_BD_NORMALGC;      
    }
  else
    {
      *darkgc = EZ_DARKGC2;
      *brightgc = EZ_BRIGHTGC1;
      *normalgc = EZ_NORMALGC1;
    }
}


void EZ_GetDarkBDGC(widget, gcptr)
     EZ_Widget *widget;
     GC        *gcptr;
{
  unsigned long pixel;
  if(EZ_WidgetBackground(widget))
    {
      pixel = EZ_GetDarkColor(EZ_WidgetBackground(widget));
      XSetForeground(EZ_Display, EZ_BD_DARKGC, pixel);
      *gcptr = EZ_BD_DARKGC;
    }
  else if(EZ_WidgetParentBG(widget) && *(EZ_WidgetParentBG(widget)))
    {
      pixel = EZ_GetDarkColor(*(EZ_WidgetParentBG(widget)));
      XSetForeground(EZ_Display, EZ_BD_DARKGC, pixel);
      *gcptr = EZ_BD_DARKGC;
    }
  else *gcptr = EZ_DARKGC2;
}

void EZ_GetBrightBDGC(widget, gcptr)
     EZ_Widget *widget;
     GC        *gcptr;
{
  unsigned long pixel;
  if(EZ_WidgetBackground(widget))
    {
      pixel = EZ_GetBrightColor(EZ_WidgetBackground(widget));
      XSetForeground(EZ_Display, EZ_BD_BRIGHTGC, pixel);
      *gcptr = EZ_BD_BRIGHTGC;
    }
  else if(EZ_WidgetParentBG(widget) && *(EZ_WidgetParentBG(widget)))
    {
      pixel = EZ_GetBrightColor(*(EZ_WidgetParentBG(widget)));
      XSetForeground(EZ_Display, EZ_BD_BRIGHTGC, pixel);
      *gcptr = EZ_BD_BRIGHTGC;
    }
  else *gcptr = EZ_BRIGHTGC1;
}

void EZ_GetDarkBDpv(widget, ptr)
     EZ_Widget *widget;
     unsigned long   *ptr;
{
  unsigned long pixel;
  if(EZ_WidgetBackground(widget))
    pixel = EZ_GetDarkColor(EZ_WidgetBackground(widget));
  else if(EZ_WidgetParentBG(widget) && *(EZ_WidgetParentBG(widget)))
    pixel = EZ_GetDarkColor(*(EZ_WidgetParentBG(widget)));
  else pixel = EZ_ColorArray[EZ_DARK_GRAY2];
  *ptr = pixel;
}

void EZ_GetBrightBDpv(widget, ptr)
     EZ_Widget *widget;
     unsigned long   *ptr;
{
  unsigned long pixel;
  if(EZ_WidgetBackground(widget))
    pixel = EZ_GetBrightColor(EZ_WidgetBackground(widget));
  else if(EZ_WidgetParentBG(widget) && *(EZ_WidgetParentBG(widget)))
    pixel = EZ_GetBrightColor(*(EZ_WidgetParentBG(widget)));
  else pixel = EZ_ColorArray[EZ_BRIGHT_GRAY2];
  *ptr = pixel;
}


void  EZ_GetBackgroundPV(wptr,pv, hlight, specialhlight)
     EZ_Widget *wptr;
     unsigned long *pv;
     int       hlight, specialhlight;
{
  if(wptr)
    {
      int set = 0;
      switch(EZ_WidgetType(wptr))
	{
	case EZ_WIDGET_ITREE:
	  if(EZ_ITreeWTextBG(wptr) != ~0)
	    {
	      set = 1;
	      *pv = EZ_ITreeWTextBG(wptr);
	    }
	  break;
	case EZ_WIDGET_ITEXT:
	  if(EZ_ITextTextBG(wptr) != ~0)
	    {
	      set = 1;
	      *pv = EZ_ITextTextBG(wptr);
	    }
	  break;
	case EZ_WIDGET_ILIST_BOX:
	  if(EZ_IListBoxTextBG(wptr) != ~0)
	    {
	      set = 1;
	      *pv= EZ_IListBoxTextBG(wptr);
	    }
	  break;
	case EZ_WIDGET_IWORK_AREA:
	  if(EZ_IWorkAreaTextBG(wptr) != ~0)
	    {
	      set = 1;
	      *pv= EZ_IWorkAreaTextBG(wptr);
	    }
	  break;
	default:
	  break;
	}
      if(set == 0)
	{
	  if((hlight && EZ_GetWidgetHighlightFlag(wptr)) || specialhlight)
	    {
	      if(EZ_WidgetBackground(wptr) != 0)
		*pv = EZ_GetHighlightColor(EZ_WidgetBackground(wptr));
	      else if(EZ_WidgetParentBG(wptr) && *(EZ_WidgetParentBG(wptr)))
		*pv = EZ_GetHighlightColor(*(EZ_WidgetParentBG(wptr)));
	      else 
		*pv = EZ_ColorArray[EZ_NORMAL_GRAY2];
	    }
	  else if(EZ_WidgetBackground(wptr) != 0)
	    *pv = EZ_WidgetBackground(wptr);
	  else if(EZ_WidgetParentBG(wptr) && *(EZ_WidgetParentBG(wptr)))
	    *pv = *(EZ_WidgetParentBG(wptr));
	  else 
	    *pv = EZ_ColorArray[EZ_NORMAL_GRAY1];
	}
    }
  else
    {
      *pv = EZ_ColorArray[EZ_NORMAL_GRAY1];
    }
}
/**************************************************************************
 * 
 * Mark children widgets that their size may  not be current
 *
 **************************************************************************/
void EZ_MarkAllChildrenWidgetSizeChanged(widget, sibling_also)
     EZ_Widget *widget; int sibling_also;
{
  EZ_Widget *children, *sibling;
  
  if(EZ_LookupWidgetFromAllHT(widget) == (EZ_Widget *)NULL) return;

  /*-------------------------------------
   * recursively mark all children widgets
   * and sibling widgets.
   *------------------------------------*/
  EZ_SetWidgetSizeMayBeChandedFlag(widget);
  children = EZ_WidgetChildren(widget);
  EZ_MarkAllChildrenWidgetSizeChanged(children,1);
  if(sibling_also)
    {
      sibling = EZ_WidgetSibling(widget);
      EZ_MarkAllChildrenWidgetSizeChanged(sibling,1);
    }
  if( EZ_WidgetWindow(widget) != (Window )NULL)
    {
      /*--------------------------------------
       * if window is maped, mark that it need
       * to me MoveResized.
       *-------------------------------------*/
      if(EZ_WidgetMaped(widget) != 0)
	EZ_WidgetMaped(widget) = 2;
    }
}

/***************************************************************
 *
 *  Widget Configuration functions.
 *
 ***************************************************************/
void EZ_SetWidgetCallBack(widget,callback, data)
     EZ_Widget *widget;
     EZ_CallBack callback;
     void *data;
{
  /* set callback to be the only callback, for compatibility */
  EZ_RemoveAllWidgetCallBacks(widget, EZ_CALLBACK);
  EZ_AddWidgetCallBack(widget,EZ_CALLBACK, callback, data, 0);
}
/*****************************************************************************/
void EZ_AddCallBackWork(funcList,callback, data, where, flag)
     EZ_CallBackStruct **funcList;
     EZ_CallBack callback;
     void *data;
     int flag;  /* 1 means this callback is internal */
     int where; /* 0: insert at the front, !=0: insert at the end */
{
  if(*funcList == NULL)
    {
      *funcList =  (EZ_CallBackStruct *)my_malloc(sizeof(EZ_CallBackStruct), _CALL_BACK_);
      if(!(*funcList))  EZ_OutOfMemory("EZ_AddCallBackWork");
      (*funcList)->callback = callback;
      (*funcList)->data = data;
      (*funcList)->next = NULL;
      (*funcList)->internal = flag;
    }
  else
    {
      EZ_CallBackStruct *tmp = (EZ_CallBackStruct *)my_malloc(sizeof(EZ_CallBackStruct), _CALL_BACK_);     
      tmp->callback = callback;
      tmp->data = data;
      tmp->internal = flag;
      if(where == 0) /* insert at the front */
	{
	  EZ_CallBackStruct *f = *funcList;
	  if(flag != 0 || f->internal == 0)
	    {
	      tmp->next = *funcList;
	      *funcList = tmp;
	    }
	  else
	    {
	      EZ_CallBackStruct *chase = f;
	      while(f && f->internal)
		{
		  chase = f;
		  f = f->next;
		}
	      chase->next = tmp;
	    }
	}
      else
	{
	  EZ_CallBackStruct *chase = *funcList;	  
	  while(chase->next != NULL) chase = chase->next;
	  chase->next = tmp;
	  tmp->next = NULL;
	}
    }
}
/*****************************************************************************/
void EZ_RemoveCallBackWork(funcList,callback, data)
     EZ_CallBackStruct **funcList;
     EZ_CallBack callback;
     void *data;
{
  if(*funcList == NULL) return;
  else
    {
      int found = 0;
      EZ_CallBackStruct *chase, *tmp;
      chase = tmp = *funcList;
      while(tmp)
	{
	  if(tmp->callback == callback && tmp->data == data)
	    { found = 1; break;}
	  else
	    {
	      chase = tmp; 
	      tmp = tmp->next;
	    }
	}
      if(found)
	{
	  if(tmp == *funcList) /* the first one */
	    *funcList = tmp->next;
	  else
	    chase->next = tmp->next;
	  (void)my_free((char *)tmp);
	}
    }
}
/*****************************************************************************/
void EZ_RemoveAllCallBacksWork(funcList)
     EZ_CallBackStruct **funcList;
{
  if(*funcList == NULL) return;
  else
    {
      EZ_CallBackStruct *next, *tmp = *funcList;
      int allgone = 1;
      if(tmp->internal)
	{
	  while(tmp && tmp->internal)
	    tmp = tmp->next;
	  allgone = 0;
	}
      while(tmp)
	{
	  next = tmp->next;
	  (void)my_free((char *)tmp);
	  tmp = next;
	}
      if(allgone) *funcList = NULL;
    }
}
/*****************************************************************************/
void  EZ_SetWidgetPosition(widget, x,y)
     EZ_Widget *widget;
     int       x,y;
{
  if(EZ_LookupWidgetFromAllHT(widget) && x >= 0 && y >= 0)
    {
      EZ_SetWidgetXSetFlag(widget);
      EZ_SetWidgetYSetFlag(widget);
      EZ_WidgetOriginX(widget) = x;
      EZ_WidgetOriginY(widget) = y;
      EZ_ClearWidgetSizeComputedFlag(widget);
      if(EZ_WidgetMapped(widget)) EZ_ReDisplayWidget(widget);
    }
}

void  EZ_SetWidgetWidth(widget,width)
     EZ_Widget *widget;
     int             width;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      EZ_WidgetWidthHint(widget) = width;
      EZ_SetWidgetWidthSetFlag(widget);
      EZ_ClearWidgetSizeComputedFlag(widget);
      if(EZ_WidgetMapped(widget)) EZ_ReDisplayWidget(widget);
    }
}

void  EZ_SetWidgetHeight(widget,height)
     EZ_Widget *widget;
     int             height;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    { 
      EZ_WidgetHeightHint(widget) = height;
      EZ_SetWidgetHeightSetFlag(widget);
      EZ_ClearWidgetSizeComputedFlag(widget);
      if(EZ_WidgetMapped(widget)) EZ_ReDisplayWidget(widget);
    }
}

int EZ_GetWidgetWidth(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    return(EZ_WidgetWidth(widget));
  else return(0);
}
int EZ_GetWidgetMinWidth(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    return(EZ_WidgetMinWidth(widget));
  else return(0);
}

int EZ_GetWidgetHeight(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    return(EZ_WidgetHeight(widget));
  else return(0);
}

int EZ_GetWidgetMinHeight(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    return(EZ_WidgetMinHeight(widget));
  else return(0);
}

int EZ_GetWidgetBorderWidth(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    return(EZ_WidgetBorderWidth(widget));
  else return(0);
}

void EZ_GetWidgetDimension(widget, w, h)
     EZ_Widget *widget;
     int       *w, *h;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      *w = EZ_WidgetWidth(widget);
      *h = EZ_WidgetHeight(widget);
    }
}

void EZ_GetWidgetGeometry(widget, x,y,w, h)
     EZ_Widget *widget;
     int       *x,*y, *w, *h;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      *x = EZ_WidgetOriginX(widget);
      *y = EZ_WidgetOriginY(widget);
      *w = EZ_WidgetWidth(widget);
      *h = EZ_WidgetHeight(widget);
    }
}

void EZ_GetWidgetPosition(widget, x, y)
     EZ_Widget *widget;
     int       *x, *y;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      *x = EZ_WidgetOriginX(widget);
      *y = EZ_WidgetOriginY(widget);
    }
}

void EZ_GetWidgetMinDimension(widget, w, h)
     EZ_Widget *widget;
     int       *w, *h;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      *w = EZ_WidgetMinWidth(widget);
      *h = EZ_WidgetMinHeight(widget);
    }
}
/***************************************************************
 *
 *   De-activate  and activate a widget. 
 *
 */
void EZ_DisableWidget(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget) &&
     EZ_GetWidgetDisabledFlag(widget) == 0)
    {
      int type = EZ_WidgetType(widget);

      EZ_SetWidgetDisabledFlag(widget);
      EZ_ClearWidgetHighlightFlag(widget);
      if(type >= EZ_WIDGET_MENU_SEPARATOR && type <= EZ_WIDGET_MENU_RADIO_BUTTON)
	EZ_WidgetBorderStyle(widget) = EZ_BORDER_NONE;
      else if(type == EZ_WIDGET_NB_PAGE)
	{
	  EZ_Widget *companion = EZ_NBPageCompanion(widget);
	  EZ_DisableWidget(companion);
	}
      if(EZ_WidgetMapped(widget)) EZ_ReDisplayWidget(widget);
    }
}

void  EZ_EnableWidget(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget) &&
     EZ_GetWidgetDisabledFlag(widget))
    {
      EZ_ClearWidgetDisabledFlag(widget);
      if(EZ_WidgetType(widget) == EZ_WIDGET_NB_PAGE)
	{
	  EZ_Widget *companion = EZ_NBPageCompanion(widget);
	  EZ_ClearWidgetDisabledFlag(companion);
	}
      if(EZ_WidgetMapped(widget)) EZ_ReDisplayWidget(widget);
    }
}
/***************************************************************
 *
 *   Change the label string for a  button-like widget.
 *
 */
char *EZ_GetWidgetLabelString(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget) == (EZ_Widget *)NULL) return(NULL);
  return(EZ_LabelString(widget));
}

int EZ_SetWidgetLabelString(widget,str)
     EZ_Widget *widget;
     char            *str;
{
  int  underline, len, redisplay = 1;
  char tmp[4];

  if(EZ_LookupWidgetFromAllHT(widget) == (EZ_Widget *)NULL) return(0);

  if(str != (char *)NULL)
    len = strlen(str);
  else 
    { 
      len = 1;
      tmp[0]=' '; tmp[1] = '\0';
      str = tmp;
    }
  
  switch(EZ_WidgetType(widget))
    {
    case EZ_WIDGET_FRAME:
      if(EZ_FrameHasLabel(widget) == 0) redisplay = 2;
      if(EZ_FrameLabelLength(widget) < len)
	{
	  EZ_FrameLabel(widget) = (char *)my_realloc(EZ_FrameLabel(widget),len+1, _LABEL_STRING_);
	  if(!EZ_FrameLabel(widget)) EZ_OutOfMemory("EZ_SetWidgetLabelString");
	  redisplay = 2;
	}
      EZ_FrameLabelLength(widget) = len;
      (void)strcpy(EZ_FrameLabel(widget),str); 
      break;
    case EZ_WIDGET_LABEL:
    case EZ_WIDGET_ITOPLEVEL:
    case EZ_WIDGET_NW_LABEL:
      if(EZ_LabelStringLength(widget) < len)
	{
	  EZ_LabelString(widget) = (char *)my_realloc(EZ_LabelString(widget),len+1, _LABEL_STRING_);
	  if(!EZ_LabelString(widget)) EZ_OutOfMemory("EZ_SetWidgetLabelString");
	  redisplay = 2;
	}
      EZ_LabelStringLength(widget) = len;
      (void)strcpy(EZ_LabelString(widget),str);
      break;
    case EZ_WIDGET_NORMAL_BUTTON:
    case EZ_WIDGET_MENU_NORMAL_BUTTON:
      if(EZ_ButtonLabelLength(widget) < len)
	{
	  EZ_ButtonLabel(widget) = (char *)my_realloc(EZ_ButtonLabel(widget),len+1, _LABEL_STRING_);
	  if(!EZ_ButtonLabel(widget)) EZ_OutOfMemory("EZ_SetWidgetLabelString");
	  redisplay = 2;
	}
      EZ_CButtonLabelLength(widget) = len;
      (void)strcpy(EZ_ButtonLabel(widget),str); 
      underline =  EZ_ButtonUnderLine(widget);
      if(underline >= 0)
	{
	  if(underline < len && isprint(str[underline]))
	    {
	      EZ_ButtonModifiers(widget) = Mod1Mask;
	      EZ_ButtonShortcut(widget)  = (EZ_ButtonLabel(widget) + underline);
	      EZ_InsertGlobalKeyPressEvent(widget, Mod1Mask, (str+underline));
	    }
	  else
	    {
	      EZ_ButtonUnderLine(widget) = -1;
	      EZ_ButtonModifiers(widget) = 0;
	      EZ_ButtonShortcut(widget)  = (char *)NULL;
	    }
	}
      break;
    case EZ_WIDGET_CHECK_BUTTON:
    case EZ_WIDGET_MENU_CHECK_BUTTON:
      if(EZ_CButtonLabelLength(widget) < len)
	{
	  EZ_CButtonLabel(widget) = (char *)my_realloc(EZ_CButtonLabel(widget),len+1,_LABEL_STRING_);
	  if(!EZ_CButtonLabel(widget)) EZ_OutOfMemory("EZ_SetWidgetLabelString");
	  redisplay = 2;
	}
      EZ_CButtonLabelLength(widget) = len;
      (void)strcpy(EZ_CButtonLabel(widget),str); 
      underline =  EZ_CButtonUnderLine(widget);
      if(underline >= 0)
	{
	  if(underline < len && isprint(str[underline]))
	    {
	      EZ_CButtonModifiers(widget) = Mod1Mask;
	      EZ_CButtonShortcut(widget)  = (EZ_CButtonLabel(widget) + underline);
	      EZ_InsertGlobalKeyPressEvent(widget, Mod1Mask, (str+underline));
	    }
	  else
	    {
	      EZ_CButtonUnderLine(widget) = -1;
	      EZ_CButtonModifiers(widget) = 0;
	      EZ_CButtonShortcut(widget)  = (char *)NULL;
	    }
	}
      break;
    case EZ_WIDGET_RADIO_BUTTON:
    case EZ_WIDGET_MENU_RADIO_BUTTON:
      if(EZ_RButtonLabelLength(widget) < len)
	{
	  EZ_RButtonLabel(widget) = (char *)my_realloc(EZ_RButtonLabel(widget),len+1,_LABEL_STRING_);
	  if(!EZ_RButtonLabel(widget)) EZ_OutOfMemory("EZ_SetWidgetLabelString");
	  redisplay = 2;
	}
      EZ_RButtonLabelLength(widget) = len;
      (void)strcpy(EZ_RButtonLabel(widget),str); 
      underline =  EZ_RButtonUnderLine(widget);
      if(underline >= 0)
	{
	  if( underline < len && isprint(str[underline]))
	    {
	      EZ_RButtonModifiers(widget) = Mod1Mask;
	      EZ_RButtonShortcut(widget)  = (EZ_RButtonLabel(widget) + underline);
	      EZ_InsertGlobalKeyPressEvent(widget, Mod1Mask, (str+underline));
	    }
	  else 
	    {
	      EZ_RButtonUnderLine(widget) = -1;
	      EZ_RButtonModifiers(widget) = 0;
	      EZ_RButtonShortcut(widget)  = (char *)NULL;
	    }
	}
      break;
    case EZ_WIDGET_MENU_BUTTON:
      if(EZ_MButtonLabelLength(widget) < len)
	{
	  EZ_MButtonLabel(widget) = (char *)my_realloc(EZ_MButtonLabel(widget),len+1,_LABEL_STRING_);
	  if(!EZ_MButtonLabel(widget)) EZ_OutOfMemory("EZ_SetWidgetLabelString");
	  redisplay = 2;
	}
      EZ_MButtonLabelLength(widget) = len;
      (void)strcpy(EZ_MButtonLabel(widget),str); 
      underline =  EZ_MButtonUnderLine(widget);
      if(underline >= 0)
	{
	  if(underline < len && isprint(str[underline]))
	    {
	      EZ_MButtonModifiers(widget) = Mod1Mask;
	      EZ_MButtonShortcut(widget)  = (EZ_MButtonLabel(widget) + underline);
	      EZ_InsertGlobalKeyPressEvent(widget, Mod1Mask, (str+underline));
	    }
	  else
	    {
	      EZ_MButtonUnderLine(widget) = -1;
	      EZ_MButtonModifiers(widget) = 0;
	      EZ_MButtonShortcut(widget)  = (char *)NULL;
	    }
	}
      break;
    case EZ_WIDGET_NB_PAGE:
      {
	EZ_Widget *companion = EZ_NBPageCompanion(widget);
	if(EZ_ButtonLabelLength(companion) < len)
	  {
	    EZ_ButtonLabel(companion) = 
	      (char *)my_realloc(EZ_ButtonLabel(companion),len+1,_LABEL_STRING_);
	    if(!EZ_ButtonLabel(widget)) EZ_OutOfMemory("EZ_SetWidgetLabelString");
	    EZ_ClearWidgetSizeComputedFlag(companion);
	    EZ_ClearWidgetSizeComputedFlag(EZ_WidgetParent(companion));
	    redisplay = 2;
	  }
	EZ_ButtonLabelLength(companion) = len;
	(void)strcpy(EZ_ButtonLabel(companion),str); 
	underline =  EZ_ButtonUnderLine(companion);
	if(underline >= 0)
	  {
	    if(underline < len && isprint(str[underline]))
	      {
		EZ_ButtonModifiers(companion) = Mod1Mask;
		EZ_ButtonShortcut(companion)  = (EZ_ButtonLabel(widget) + underline);
		EZ_InsertGlobalKeyPressEvent(companion, Mod1Mask, (str+underline));
	      }
	    else
	      {
		EZ_ButtonUnderLine(companion) = -1;
		EZ_ButtonModifiers(companion) = 0;
		EZ_ButtonShortcut(companion)  = (char *)NULL;
	      }
	  }
      }
      break;
    case EZ_WIDGET_VERTICAL_SLIDER:
    case EZ_WIDGET_HORIZONTAL_SLIDER:
      if(EZ_SliderLabelLength(widget) < len)
	{
	  EZ_SliderLabel(widget) = (char *)my_realloc(EZ_SliderLabel(widget),len+1,_LABEL_STRING_);
	  if(!EZ_SliderLabel(widget)) EZ_OutOfMemory("EZ_SetWidgetLabelString");
	  redisplay = 2;
	}
      EZ_SliderLabelLength(widget) = len;
      (void)strcpy(EZ_SliderLabel(widget),str); 
      break;
    default:
      (void)fprintf(stderr,"EZ_SetWidgetLabelString(): invalid widget type.\n");
      redisplay = 0;
      break;
    }
  /*--------------------------------------------
   * Send an expose event so that the change
   * get displayed.
   *-------------------------------------------*/
  if(redisplay)
    {
      /*if(redisplay == 2) EZ_ClearWidgetSizeComputedFlag(widget);
	if(EZ_WidgetMapped(widget)) EZ_ReDisplayWidget(widget);*/
      return(1);
    }
  return(0);
}
/***************************************************************
 *
 *   Return the integer stored in widget->common.IntData.
 */

int EZ_GetWidgetIntData(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    return(EZ_WidgetIntData(widget));
  return(0);
}

void *EZ_GetWidgetPtrData(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    return(EZ_WidgetPtrData(widget));
  return(0);
}
void EZ_GetWidgetClientData(widget, i, p)
     EZ_Widget *widget; int *i; void **p;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      *i = EZ_WidgetIntData(widget);
      *p = EZ_WidgetPtrData(widget);
    }
}
int EZ_GetWidgetReturnedData(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    return(EZ_WidgetRetData(widget));
  return(0);
}

int EZ_GetWidgetReturnData(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    return(EZ_WidgetRetData(widget));
  return(0);
}

/***************************************************************
 *
 *   Set  widget->common.IntData and  widget->common.PtrData.
 */
void EZ_SetWidgetIntData(widget,data)
     EZ_Widget *widget;
     int             data;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      int type = EZ_WidgetType(widget);
      EZ_Widget *twidget = NULL;
      switch(type)
	{
	case EZ_WIDGET_TREE:
	  twidget = EZ_TreeWITree(widget);		  
	  break;
	case EZ_WIDGET_LIST_BOX:
	  twidget = EZ_ListBoxIListBox(widget);
	  break;
	case EZ_WIDGET_FANCY_LIST_BOX:
	  twidget = EZ_FListBoxIFListBox(widget);
	  break;
	case EZ_WIDGET_WORK_AREA:
	  twidget = EZ_WorkAreaIWorkArea(widget);
	  break;
	default:
	  break;
	}
      EZ_WidgetIntData(widget) = data;
      if(twidget) EZ_WidgetIntData(twidget) = data;
    }
}


void EZ_SetWidgetPtrData(widget,data)
     EZ_Widget *widget;
     void            *data;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      int type = EZ_WidgetType(widget);
      EZ_Widget *twidget = NULL;
      switch(type)
	{
	case EZ_WIDGET_TREE:
	  twidget = EZ_TreeWITree(widget);		  
	  break;
	case EZ_WIDGET_LIST_BOX:
	  twidget = EZ_ListBoxIListBox(widget);
	  break;
	case EZ_WIDGET_FANCY_LIST_BOX:
	  twidget = EZ_FListBoxIFListBox(widget);
	  break;
	case EZ_WIDGET_WORK_AREA:
	  twidget = EZ_WorkAreaIWorkArea(widget);
	  break;
	default:
	  break;
	}
      EZ_WidgetPtrData(widget) = data;
      if(twidget) EZ_WidgetPtrData(twidget) = data;
    }
}

void EZ_SetWidgetClientData(widget, i, p)
     EZ_Widget *widget;
     int i; void *p;
{
  EZ_SetWidgetIntData(widget, i);
  EZ_SetWidgetPtrData(widget, p);
}

/***************************************************************
 *
 *  Hide a widget. This is primarily for toplevel widgets like
 *  a dialogue. For non-toplevel widgets, this it will only 
 *  hide the widget temporary (till the next redisplay of
 *  parent widget).  Use EZ_DeActivateWidget() for non-toplevel
 *  widgets.
 */
void  EZ_HideWidget(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      if( EZ_WidgetMapped(widget) != 0)
	{
	  XUnmapWindow(EZ_Display, EZ_WidgetWindow(widget));
	  EZ_WidgetMapped(widget) = 0;
	  if(EZ_GetWidgetEmbededFlag(widget))
	    {
	      Window commWin = EZ_WidgetDnDApplName(widget);
	      Window pWin = EZ_WidgetDnDParent(widget);
	      if(EZ_VerifyExistence(commWin) && EZ_WindowExist(pWin))
		EZ_SendEmbedingMessage(EZ_EMBEDING_UNMAPPED_S,
				       EZ_DummyWindow, EZ_WidgetWindow(widget), (unsigned long)widget,
				       commWin, pWin, 0,
				       EZ_ApplicationSetupTime,
				       0,0,0,0,0,0);
	    }
	}
    }
}

/***************************************************************
 *
 *   De-activate a widget. It non-destructively remove widget
 *   from display. The geometry of parent widget will be 
 *   re-computed.  
 *   De-activated widget can be Activated again by calling
 *   EZ_ActivateWidget().
 */
void EZ_DeActivateWidget(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      if(EZ_GetWidgetNonActiveFlag(widget) == 0)
	{
	  /*--------------------------------------------------------
	   *  If it is being displayed now, unmap it.
	   *-------------------------------------------------------*/
	  EZ_SetWidgetNonActiveFlag(widget);
	  if(EZ_WidgetMapped(widget) != 0)
	    {
	      XUnmapWindow(EZ_DisplayForWidgets, EZ_WidgetWindow(widget));
	      EZ_WidgetMapped(widget) = 0;
	      if(EZ_GetWidgetEmbededFlag(widget))
		{
		  Window commWin = EZ_WidgetDnDApplName(widget);
		  Window pWin = EZ_WidgetDnDParent(widget);
		  if(EZ_VerifyExistence(commWin) && EZ_WindowExist(pWin))
		    EZ_SendEmbedingMessage(EZ_EMBEDING_UNMAPPED_S,
					   EZ_DummyWindow, EZ_WidgetWindow(widget),
					   (unsigned long)widget,
					   commWin, pWin, 0,
					   EZ_ApplicationSetupTime,
					   0,0,0,0,0,0);
		}
	    }
	}
    }
}

void EZ_ActivateWidget(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      if(EZ_GetWidgetNonActiveFlag(widget) != 0)
	{
	  EZ_ClearWidgetNonActiveFlag(widget);
	  EZ_ClearWidgetSizeComputedFlag(widget);
	  EZ_ReDisplayWidget(widget);
	}
    }
}

/***************************************************************
 *
 *  Initialize two cursors.
 */
void  EZ_InitializeCursors()
{
  if(EZ_EntryCursor == (Cursor )NULL)
    {
      EZ_EntryCursor = XCreateFontCursor(EZ_DisplayForWidgets, XC_xterm);
      EZ_RightPtrCursor = XCreateFontCursor(EZ_DisplayForWidgets, XC_right_ptr);
      EZ_LeftPtrCursor = XCreateFontCursor(EZ_DisplayForWidgets, XC_left_ptr);
      EZ_ExpandCursor = XCreateFontCursor(EZ_DisplayForWidgets, XC_hand2);
      EZ_WatchCursor = XCreateFontCursor(EZ_DisplayForWidgets, XC_watch);
    }
}
/***************************************************************/
static void EZ_FreezeWidgetWork(widget, level)
     EZ_Widget *widget;
     int       level;
{
  if(widget != (EZ_Widget *)NULL)
    {
      EZ_SetWidgetFreezedFlag(widget);

      EZ_FreezeWidgetWork(EZ_WidgetChildren(widget), 1);
      if(level) EZ_FreezeWidgetWork(EZ_WidgetSibling(widget), 1);
    }
}

static void EZ_UnFreezeWidgetWork(widget, level)
     EZ_Widget *widget;
     int       level;
{
  if(widget != (EZ_Widget *)NULL)
    {
      EZ_ClearWidgetFreezedFlag(widget);

      EZ_UnFreezeWidgetWork(EZ_WidgetChildren(widget), 1);
      if(level) EZ_UnFreezeWidgetWork(EZ_WidgetSibling(widget), 1);
    }
}

void EZ_FreezeWidget(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    { 
      if( EZ_GetWidgetFreezedFlag(widget) == 0)
	EZ_FreezeWidgetWork(widget, 0);
    }
}

void EZ_UnFreezeWidget(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    {
      if( EZ_GetWidgetFreezedFlag(widget) != 0)
	{
	  EZ_UnFreezeWidgetWork(widget, 0);
	  if(EZ_WidgetMapped(widget) != 0) EZ_ReDisplayWidget(widget);
	}
    }
}
/***************************************************************/
      
int EZ_GetWidgetOrientation(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    return((int)EZ_WidgetStacking(widget));
  return(0);
}
/***************************************************************/
/*
 * return the geometry of widget in screen coordinates.
 * position is relative to the upper-left corner of the display
 */
void EZ_GetWidgetAbsoluteGeometry(widget, x_ret,y_ret, w_ret, h_ret)
     EZ_Widget *widget;
     int *x_ret,*y_ret, *w_ret, *h_ret;
{
  if(EZ_LookupWidgetFromAllHT(widget) && EZ_WidgetMapped(widget) != 0)  
    {
      Window junkwin, win = EZ_WidgetWindow(widget);

      XTranslateCoordinates(EZ_Display, win,
			    RootWindow(EZ_Display, EZ_ScreenNum),
			    0,0, x_ret,y_ret, &junkwin); 
      *w_ret = EZ_WidgetWidth(widget);
      *h_ret = EZ_WidgetHeight(widget);
    }
}
/****************************************************************
 *
 *   Manipulating callbacks: For internal use only
 */
void  EZ_AddWidgetCallBackInternal(widget, which, callback, data, where)
     EZ_Widget *widget;
     EZ_CallBack callback;
     void *data;
     int where;
     int which;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    { 
      EZ_CallBackStruct **funcList = EZ_GetCallbackType(widget, which);
      if(funcList) EZ_AddCallBackWork(funcList,callback,data, where, 1);
      else { fprintf(stderr,"EZ_AddWidgetCallBack(), unknown callback type\n");}
    }
}

void  EZ_AddWidgetCallBack(widget, which, callback, data, where)
     EZ_Widget *widget;
     EZ_CallBack callback;
     void *data;
     int where;
     int which;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    { 
      EZ_CallBackStruct **funcList = EZ_GetCallbackType(widget, which);
      if(funcList) EZ_AddCallBackWork(funcList,callback,data, where, 0);
      else { fprintf(stderr,"EZ_AddWidgetCallBack(), unknown callback type\n");}
    }
}
/*****************************************************************************/
void EZ_RemoveWidgetCallBack(widget, which, callback, data)
     EZ_Widget *widget;
     EZ_CallBack callback;
     void *data;
     int which;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    { 
      EZ_CallBackStruct **funcList = EZ_GetCallbackType(widget, which);
      if(funcList) EZ_RemoveCallBackWork(funcList,callback,data);
      else {fprintf(stderr, "EZ_RemoveWidgetCallBack(), unknown callback type\n");}
    }
}
/*****************************************************************************/
void EZ_RemoveAllWidgetCallBacks(widget, which)
     EZ_Widget *widget;
     int which;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    { 
      EZ_CallBackStruct **funcList = EZ_GetCallbackType(widget, which);
      if(funcList) EZ_RemoveAllCallBacksWork(funcList);
      else {fprintf(stderr, "EZ_RemoveAllWidgetCallBack(), unknown callback type\n");}
    }
}
/*****************************************************************************/
static EZ_CallBackStruct  **EZ_GetCallbackType(widget, which)
     EZ_Widget *widget;
     int which;
{
  EZ_CallBackStruct **funcList = NULL;

  EZ_Widget *twidget;
  
  switch(EZ_WidgetType(widget))
    {
    case EZ_WIDGET_LIST_BOX:
      twidget = EZ_ListBoxIListBox(widget);
      break;
    case EZ_WIDGET_TEXT:
      twidget = EZ_TextIText(widget); 
      break;
    case EZ_WIDGET_TREE:
      twidget = EZ_TreeWITree(widget);
      break;
    case EZ_WIDGET_FANCY_LIST_BOX:
      twidget = EZ_FListBoxIFListBox(widget);
      break;
    case EZ_WIDGET_WORK_AREA:
      twidget = EZ_WorkAreaIWorkArea(widget);
      break;
    default:
      twidget = widget;
      break;
    }  
  
  switch(which)
    {
    case EZ_CALLBACK:
      funcList = &(EZ_WidgetCallback(twidget)); 
      break;
    case EZ_DESTROY_CALLBACK:
      funcList = &(EZ_WidgetDestroyCallBack(twidget)); 
      break;
    case EZ_MOTION_CALLBACK:
      funcList = &(EZ_WidgetMotionCallBack(twidget)); 
      break;
    default:
      break;
    }
  return(funcList);
}
/*****************************************************************************/
static EZ_EventHandlerStruct **GetWidgetEventHandlers(widget)
     EZ_Widget *widget;
{
  EZ_EventHandlerStruct **handlers = NULL;

  if(widget)
    {
      EZ_Widget *twidget = widget;

      switch(EZ_WidgetType(widget))
	{
	case EZ_WIDGET_LIST_BOX:
	  twidget = EZ_ListBoxIListBox(widget);
	  break;
	case EZ_WIDGET_TEXT:
	  twidget = EZ_TextIText(widget); 
	  break;
	case EZ_WIDGET_TREE:
	  twidget = EZ_TreeWITree(widget);
	  break;
	case EZ_WIDGET_FANCY_LIST_BOX:
	  twidget = EZ_FListBoxIFListBox(widget);
	  break;
	case EZ_WIDGET_WORK_AREA:
	  twidget = EZ_WorkAreaIWorkArea(widget);
	  break;
	default:
	  break;
	}
      handlers = &(EZ_WidgetEventHandler(twidget)); 
    }
  return(handlers);
}


void  EZ_AddEventHandler(widget, handler, data, where)
     EZ_Widget *widget;
     EZ_EventHandler handler;
     void *data;
     int where;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    { 
      EZ_CallBackStruct **funcList = (EZ_CallBackStruct **) GetWidgetEventHandlers(widget);
      if(funcList) EZ_AddCallBackWork(funcList,(EZ_CallBack)handler, data, where, 0);
    }
}

void EZ_RemoveEventHandler(widget, handler, data)
     EZ_Widget *widget;
     EZ_EventHandler handler;
     void *data;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    { 
      EZ_CallBackStruct **funcList = (EZ_CallBackStruct **) GetWidgetEventHandlers(widget);
      if(funcList) EZ_RemoveCallBackWork(funcList,(EZ_CallBack)handler, data);
    }
} 

void EZ_RemoveAllEventHandlers(widget)
     EZ_Widget *widget;
{
  if(EZ_LookupWidgetFromAllHT(widget))
    { 
      EZ_CallBackStruct **funcList = (EZ_CallBackStruct **) GetWidgetEventHandlers(widget);
      if(funcList) EZ_RemoveAllCallBacksWork(funcList);
    }
}
/************************************************************************************/
#undef _EZ_WIDGET_C   
