/************************** Example 3 ***********************/
#include "EZ.h"                     /* the header file      */

void listTreeCallBack(EZ_Widget *widget, void *data) 
{                                  /* callback for listTree */
  EZ_TreeNode  *node = EZ_GetListTreeWidgetSelection(widget);
  EZ_Widget    *textWidget = (EZ_Widget *)data;
  if(node && textWidget)
    {
      EZ_Item *item = EZ_TreeNodeGetItem(node);
      if(item)
	{
	  char *str=NULL;   int len;
	  EZ_GetLabelItemStringInfo(item, &str, &len);
	  if(str)  EZ_TextLoadFile(textWidget, str);
	}
    }
}

main(int argc, char **argv)
{
  EZ_Widget *frame, *listTree;
  EZ_Widget *textW, *tmp;
  EZ_TreeNode *root;

  frame = EZ_CreateWidget(EZ_WIDGET_FRAME, NULL,  /* a toplevel frame   */
		     EZ_WIDTH, 600, EZ_HEIGHT, 400,
		     EZ_PADY, 10, EZ_PADX,10, 
		     EZ_BACKGROUND, "bisque2",
		     EZ_FILL_MODE, EZ_FILL_BOTH, 0);

                                         /* a list tree   */
  listTree = EZ_CreateWidget(EZ_WIDGET_TREE, frame,
                             EZ_WIDTH, 200,     /* width  */
                             EZ_OPTIONAL_HSCROLLBAR, True,
                             EZ_OPTIONAL_VSCROLLBAR, True,
                             0);
  /* add a pane handle so that user can adjust the relative 
   * size of the two sibling widgets */
  tmp = EZ_CreateWidget(EZ_WIDGET_PANE_HANDLE, frame,
                        0);
  textW = EZ_CreateWidget(EZ_WIDGET_TEXT, frame,
                          EZ_OPTIONAL_HSCROLLBAR, True,
                          EZ_OPTIONAL_VSCROLLBAR, True,                 
                          EZ_TEXT_WIDGET_EDITABLE, True,
                          EZ_SELECTION_BACKGROUND, "yellow",
                          0);

  root = EZ_CreateDirTree("./*");  /* open the current dir   */

  EZ_AddWidgetCallBack(listTree, EZ_CALLBACK, 
		       listTreeCallBack, textW, 0);

  EZ_SetListTreeWidgetTree(listTree, /* link root to listTree*/
		       root); 
  
  EZ_DisplayWidget(frame);
  EZ_EventMainLoop();
}
/************************** Example 3 ***********************/
