/*
 * $Id: Button.h,v 1.1 1999/08/18 17:13:30 falk Exp $
 *
 * This is a "generic" button widget
 */


#ifndef	BUTTON_H
#define	BUTTON_H

#include <X11/Core.h>

/* Button widget resources:

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 set		Set		Boolean		False
 switchType	SwitchType	SwitchType	MomentaryOn
 callback	Callback	XtCallbackList	NULL
 stateCallback	Callback	XtCallbackList	NULL

 callback is called whenever the button state (on/off) changes.  The
 data argument is an int.

 stateCallback is called whenever *any* part of the button state
 changes.  The data argument is is an unsigned int containing
 the flags listed below.

*/


typedef	enum {
	  MomentaryOn,		/* normally off */
	  MomentaryOff,		/* normally on */
	  Toggle
	} SwitchType ;



/* These are the state flags passed to stateCallback procs.
 * "Highlit" means the button now has the focus (mouse or keyboard).
 * "Armed" means that the user has pressed the button (toggle only)
 * "Set" means that the button is in its "on" state.
 * "Insensitive" means that the button does not respond to input
 *
 * Not all combinations are legal; e.g. an insensitive button cannot
 * be highlit or armed.
 *
 * Other combinations are also named below.  There are a total
 * of eight legal states.
 */

#define	Highlit	1			/* state flags */
#define	Armed	2
#define	Set	4
#define	Insensitive 8

#define	Unset		0		/* combinations of state flags */
#define	UnsetHighlit	Highlit
#define	SetHighlit	(Set|Highlit)
#define	SetArmed	(Set|Armed)
#define	SetInsensitive	(Set|Insensitive)


#ifndef	XtNset
#define	XtNset	"set"
#define	XtCSet	"Set"
#endif

#define	XtNswitchType	"switchType"
#define	XtCSwitchType	"SwitchType"
#define	XtRSwitchType	"SwitchType"

#ifndef	XtNstateCallback
#define	XtNstateCallback	"stateCallback"
#endif

extern	WidgetClass	buttonWidgetClass;

typedef	struct	_ButtonClassRec	*ButtonWidgetClass;
typedef	struct	_ButtonRec	*ButtonWidget;

#endif	/* BUTTON_H */
