/* --------------------------------- mouse.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Handler for the mouse as a pointing device for UNIX/X11.
*/

#include "fly.h"


extern int	FAR GetMouse (int *x, int *y, char *btn, int *nbtn);

#define USELOG		0x0001		/* log scale on x/y (default) */

#define PO		p->opt
#define FA1D		PO[0]
#define FA1F		PO[1]
#define FA2D		PO[2]
#define FA2F		PO[3]
#define FSPEEDX		PO[4]
#define FSPEEDY		PO[5]
#define FOPTS		PO[6]

static int FAR
Mcal (POINTER *p)
{return (0);}

static int FAR
Minit (POINTER *p, char *options)
{
	long	l;

	if (get_narg (options, "sx=", &l) || l <= 0)
		FSPEEDX = 10;
	else
		FSPEEDX = (int)l;

	if (get_narg (options, "sy=", &l) || l <= 0)
		FSPEEDY = 10;
	else
		FSPEEDY = (int)l;

	if (get_arg (options, "linear"))
		FOPTS &= ~USELOG;
	else
		FOPTS |= USELOG;

	get_btn (p, options);

	return (0);
}

static void FAR
Mterm (POINTER *p)
{}

static int FAR
Mread (POINTER *p, int transfer)
{
	int	reading, win_x, win_y, sizex, sizey, nbtn;
	char	btn[36];

	if (T(reading = GetMouse (&win_x, &win_y, btn, &nbtn)))
		return (reading);

	sizex = fmul (CW->orgx, CS->sizex);
	sizey = fmul (CW->orgy, CS->sizey);
	win_x -= sizex + CS->minx;
	win_y -= sizey + CS->miny;

	sizex = fmul (CW->maxx, CS->sizex);
	sizey = fmul (CW->maxy, CS->sizey);

	reading = muldiv (win_y, 100, sizey);		/* y */
	reading = muldiv (reading*FA2D, 10, FSPEEDY);
	if (reading > 100)
		reading = 100;
	if (reading < -100)
		reading = -100;
	p->a[FA2F] = reading;
	if (transfer)
		p->l[FA2F] = (FOPTS & USELOG) ? lin2log (reading) : reading;

	reading = muldiv (win_x, 100, sizex);		/* x */
	reading = muldiv (reading*-FA1D, 10, FSPEEDX);
	if (reading > 100)
		reading = 100;
	if (reading < -100)
		reading = -100;
	p->a[FA1F] = reading;
	if (transfer)
		p->l[FA1F] = (FOPTS & USELOG) ? lin2log (reading) : reading;

	do_btns (p, btn, nbtn);

	return (0);
}

struct PtrDriver NEAR PtrMouse = {
	"MOUSE",
	0,
	Minit,
	Mterm,
	Mcal,
	Mcal,			/* center */
	Mread,
	std_key
};

#undef USELOG
#undef PO
#undef FA1D
#undef FA1F
#undef FA2D
#undef FA2F
#undef FSPEEDX
#undef FSPEEDY
#undef FOPTS
