/* --------------------------------- orunway.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* object runway: a standard airfield with two runways.
*/

#include "fly.h"


static SHAPE shape_runway = {
	0,
	0,
	0,
	1L,		/* weight */
	0		/* drag */
};

static int FAR
init_runway (BODY *b)
{
	if (shape_read (&shape_runway, "runway"))
		return (1);
	return (0);
}

static void FAR
term_runway (BODY *b)
{
	shape_free (shape_runway.v);
}

static int FAR
create_runway (OBJECT *p)
{
	p->color = st.brown;
	p->time = FOREVER;
	p->flags |= F_VISIBLE;
	Mident (p->T);
	return (0);
}

BODY BoRunway = {
	0,
	0,
	"RUNWAY",
	&shape_runway,
	init_runway,
	term_runway,
	create_runway,
	body_delete,
	body_dynamics,
	body_hit
};
