/* --------------------------------- ohouse.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* object 'house'.
*/

#include "fly.h"


static SHAPE shape_house = {
	0,
	0,
	0,
	2000*1000L,	/* weight */
	0		/* drag */
};

static int FAR
init_house (BODY *b)
{
	if (shape_read (&shape_house, "house"))
		return (1);
	return (0);
}

static void FAR
term_house (BODY *b)
{
	shape_free (shape_house.v);
}

static int FAR
create_house (OBJECT *p)
{
	p->color = st.red;
	p->time = FOREVER;
	p->flags |= F_VISIBLE;
	Mident (p->T);
	return (0);
}

BODY BoHouse = {
	0,
	0,
	"HOUSE",
	&shape_house,
	init_house,
	term_house,
	create_house,
	body_delete,
	body_dynamics,
	body_hit
};
