#include "xstar.h"
#include "xstar_ext.h"


/*
** XStar -- a animated n-body solver for X windows
** Copyright (C) 1995-1996  Wayne Schlitt (wayne@midwestcs.com)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
*/



void init_sys_8b( point_2d *cur, point_2d *prev, double *m,
	      point_2d *vk[], point_2d *ak[],
	      int max_stars, sys_param_type *sp )
{
    int		i, k;

    sp->star_distrib  = 0;
    sp->size          = 3.0300000000000000e+02;
    sp->num_collapsar = 0;
    sp->mono_stars    = 8;

    sp->star_circle   = 0;
    sp->cir_dist      = 0;

    sp->star_line     = 0;

    sp->do_bounce     = 0;
    sp->no_speed      = 0;
    sp->few_stars     = 0;
    sp->drift         = 0;
    sp->min_angular_mom  = 0;

    sp->min_stars     = 1;
    sp->num_add       = 0;
    sp->live_stars    = 8;

/* star 0 */

    m[0]        = 3.2820512820512824e+00;
    cur[0].x    = -5.9426018201326272e+01;
    cur[0].y    = 1.7647796986427664e+01;
    prev[0].x   = -5.9426018201326272e+01;
    prev[0].y   = 1.7647796986427664e+01;
    vk[0][0].x  = 4.8740542740093326e-03;
    vk[0][0].y  = 1.0900511132255125e-02;
    ak[0][0].x  = 2.5173820214687024e-06;
    ak[0][0].y  = -2.4452551992655210e-06;

/* star 1 */

    m[1]        = 2.0968660968660968e+00;
    cur[1].x    = 9.3599198133270978e-01;
    cur[1].y    = -4.0668403188234521e+01;
    prev[1].x   = 9.3599198133270978e-01;
    prev[1].y   = -4.0668403188234521e+01;
    vk[0][1].x  = -7.7175472328441120e-03;
    vk[0][1].y  = -3.7383560620019456e-03;
    ak[0][1].x  = -3.2319296217630353e-06;
    ak[0][1].y  = 1.7991971056596420e-06;

/* star 2 */

    m[2]        = 2.0512820512820515e+00;
    cur[2].x    = -5.9384119374432700e+01;
    cur[2].y    = 9.8236339712784101e+01;
    prev[2].x   = -5.9384119374432700e+01;
    prev[2].y   = 9.8236339712784101e+01;
    vk[0][2].x  = 1.5656891177842101e-02;
    vk[0][2].y  = 8.0608082916574265e-03;
    ak[0][2].x  = 8.2457296929936326e-07;
    ak[0][2].y  = -3.3782755206993198e-06;

/* star 3 */

    m[3]        = 9.3447293447293456e-01;
    cur[3].x    = -7.0405575139421671e+01;
    cur[3].y    = -2.7001090804229296e+01;
    prev[3].x   = -7.0405575139421671e+01;
    prev[3].y   = -2.7001090804229296e+01;
    vk[0][3].x  = -7.6525422837526603e-03;
    vk[0][3].y  = 1.6937754974762298e-02;
    ak[0][3].x  = 6.5073079181275713e-06;
    ak[0][3].y  = 3.6029649981805933e-06;

/* star 4 */

    m[4]        = 2.2336182336182335e+00;
    cur[4].x    = 9.2302766801034323e+01;
    cur[4].y    = -6.0862441826543247e+01;
    prev[4].x   = 9.2302766801034323e+01;
    prev[4].y   = -6.0862441826543247e+01;
    vk[0][4].x  = -1.0083930782485945e-02;
    vk[0][4].y  = -1.3905687652693736e-02;
    ak[0][4].x  = -2.1482127913348859e-06;
    ak[0][4].y  = 2.1385211861947785e-06;

/* star 5 */

    m[5]        = 7.5213675213675213e-01;
    cur[5].x    = -7.2473741939590468e+00;
    cur[5].y    = 1.6015571178554193e+01;
    prev[5].x   = -7.2473741939590468e+00;
    prev[5].y   = 1.6015571178554193e+01;
    vk[0][5].x  = 8.7707293778696745e-03;
    vk[0][5].y  = -9.8131165679121637e-04;
    ak[0][5].x  = -4.0382422553598351e-06;
    ak[0][5].y  = -3.0253523635815457e-06;

/* star 6 */

    m[6]        = 2.9173789173789175e+00;
    cur[6].x    = 8.7255538788646888e+01;
    cur[6].y    = 2.6925933985080562e+01;
    prev[6].x   = 8.7255538788646888e+01;
    prev[6].y   = 2.6925933985080562e+01;
    vk[0][6].x  = 5.5994912063467676e-03;
    vk[0][6].y  = -1.4944457539263970e-02;
    ak[0][6].x  = -2.0118695310450290e-06;
    ak[0][6].y  = -1.6850985387665771e-06;

/* star 7 */

    m[7]        = 1.7321937321937322e+00;
    cur[7].x    = -4.3062922104262000e+01;
    cur[7].y    = -5.9796442419559682e+01;
    prev[7].x   = -4.3062922104262000e+01;
    prev[7].y   = -5.9796442419559682e+01;
    vk[0][7].x  = -1.4541568021132618e-02;
    vk[0][7].y  = 8.7153380803802905e-03;
    ak[0][7].x  = 2.5674930287103935e-06;
    ak[0][7].y  = 5.9061580476882484e-06;


    /* scale things to the current accuracy */

    for( i = 0; i < max_stars; i++ )
    {
	if( m[i] <= 0 )
	    continue;
	
	m[i] *= fm;

	for( k = 0; k < K; k++ )
	{
	    vk[k][i].x *= fv_inv;
	    vk[k][i].y *= fv_inv;

	    ak[k][i].x *= fv_inv*fv_inv;
	    ak[k][i].y *= fv_inv*fv_inv;
	}
    }
}
