.\" $Id: xpaint.man.in,v 1.2 1996/08/07 07:10:07 torsten Exp $
.\" 
.TH xpaint l "Release 2.4.7"
.SH NAME
xpaint \- Simple Paint program
.SH SYNOPSIS
.B xpaint
[
.RI -size " WIDTH" x HEIGHT
] [ -12 ] [ -24 ] [
.RI -rcFile " file"
] [ -popped ] [ -nowarn ] [ -help ] [
.IR filenames "... ]"
.br
.SH DESCRIPTION
.I XPaint
is a color image editing tool which features most standard paint 
program options, as well as advanced features such as image processing
algorithms.
It allows for the editing of multiple images simultaneously and supports
various formats, including PPM, XBM, TIFF, JPEG, etc. 
.PP
The functionality of XPaint is divided into a toolbox area for selecting
the current paint operation and paint windows for modifying/creating
images.
Each paint window has access to its own color palette and set
of patterns, although the paint operation in use is globally selected
for all windows. 
.PP
XPaint runs on a variety of displays.
It should be noted that saving images will adapt them to the current display
type (i.e. a color image loaded on a greyscale screen will be saved as a grey
image).
.PP
There is also an extensive on-line help system available.
.SH OPTIONS
In addition to being able to specify image files to open,
the following options are available on the command line:
.RS 0.5i
.TP 1i
.BI -size " w" x h
Default width and height for new images.
.TP 1i
.B -12
Use a 12 bit PseudoColor visual.
.TP 1i
.B -24
Use a 24 bit TrueColor visual.
.TP 1i
.BI -rcFile " file"
Load
.I file
instead of the default RC file specified at compile time. See also
the section RC FILE FORMAT below.
.TP 1i
.B -popped
Popup an empty canvas on startup.
.TP 1i
.B -nowarn
Do not emit warnings about possible data loss due to different depth of
display and image.
.TP 1i
.B -help
Give a summary of the available options.
.RE
.SH TOOLBOX
The toolbox window is displayed when XPaint is started.
The toolbox is used to select an operation which can then be applied to any
image area presented (painting window, fat bits, pattern editor, etc.).
The window has a selection of painting operations (as icons) and several pull
down menus.
.SH PAINTING WINDOW
The painting window holds a canvas area for painting the displayed image,
menus for performing operations on this image, and primary and secondary
color/pattern palettes along with buttons for adding to these.

.SH RC FILE FORMAT
The RC file can be used to customize the color/pattern palettes.
If a system-wide RC file is specified with the
.B -rcFile
option, that file is read first; otherwise, the defaults specified at compile
time are loaded.
Then, the file
.B .XPaintrc
is searched for first in the user's home directory and then in the current
directory. Any settings specified here are appended to the one in the
system-wide RC file.

Any time a new canvas is created, the
.B .XPaintrc
file is read again if it has changed.

The RC file can contain any of the following entries, in any order: 

.RS 0.5i
.TP 1i
.B #
or
.TP 1i
.B !
at the start of a line initiates a comment.
The rest of the line is ignored.
.TP 1i
.BI solid " color"
where
.I color
is a color in standard X11 format (eg. 
.BR GoldenRod1 ,
.BR #a2b5cd 
- see also
X(1))
adds a solid color to the palette.
.TP 1i
.BI "pattern BeginData" " bitmap " EndData
where
.I bitmap
is a bitmap specification in XBM or XPM format, adds a fill pattern to
the palette.

Note that there must be a newline after 
.BR BeginData ,
and that
.B EndData
must appear on a line by itself.

.TP 1i
.BI pattern " filename"
where
.I filename
is a file containing a bitmap in XBM or XPM format, also adds a 
pattern to the palette.
.RE

The squares in the palette have a default size of 24 by 24 pixels. This can be
changed by setting the
.B XPaint.patternsize
resource to a number between 4 and 64.

.\" -- section on BRUSH keyword commented out until some point in the future
.\"    when the information is actually used
.\" 
.\" .TP 1i
.\" .BI "brush BeginData" " bitmap " EndData
.\" where
.\" .I bitmap
.\" is a bitmap specification in XBM or XPM format, adds a brush pattern to
.\" the brush selector box.
.\" 
.\" .BR NOTE :
.\" The
.\" .B brush
.\" keyword currently has no effect.
.\" 
.\" .TP 1i
.\" .BI brush " filename"
.\" where
.\" .I filename
.\" is a file containing a bitmap in XBM or XPM format, adds a brush
.\" pattern to the brush selector box.
.\" 
.\" .BR NOTE :
.\" The
.\" .B brush
.\" keyword currently has no effect.

.SH AUTHOR
David Koblas, koblas@netcom.com.  
I am interested in how this program is used, if you find any bugs, I'll 
fix them.
If you notice any rough spots, or think of some way in which it could be
better, feel free to drop me a message.

Torsten Martinsen, bullestock@dk-online.dk, is to blame for any (mis)features
added in XPaint release 2.2 and following releases.

Many people, too numerous to mention, have contributed to the development of
XPaint. See the file Doc/CHANGES in the source distribution for details.
