/* mesh.h -- mesh handling routines header
**
** Written and Copyright (C) 1994 by Michael J. Gourlay
**
** NO WARRANTEES, EXPRESS OR IMPLIED.
*/

#ifndef _MESH_H__INCLUDED_
#define _MESH_H__INCLUDED_

typedef struct {
  long nx;    /* number of mesh points in the x-direction */
  long ny;    /* number of mesh points in the y-direction */
  double *x;  /* 2D array of x-values */
  double *y;  /* 2D array of y-values */
} MeshT;



extern void meshInterp(const MeshT *m1P, const MeshT *m2P,double t,MeshT *moP);
extern int meshCheck(const MeshT *mesh1, const MeshT *mesh2);
extern void meshReset(MeshT *mP, int mw, int mh);
extern int meshFunctionalize(MeshT *mP, int mw, int mh);

extern int meshPointNearest(const MeshT *mP, int px, int py, int *mi, int *mj, int *dx, int *dy);
extern void meshFree(MeshT *mP, char *proc);
extern int meshAlloc(MeshT *meshP, char *proc);
extern int meshLineAdd(MeshT *mP, int mi, double mt, int type);
extern int meshLineDelete(MeshT *mP, int mi, int type);
extern int meshLoad(MeshT *meshP, const char *fn);
extern int meshSave(const MeshT *mP, char *fn);

#endif /* _MESH_H__INCLUDED_ */
